"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class LBPersistenceType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'method': 'str',
        'cookie_name': 'str',
        'cookie_mode': 'str'
    }

    attribute_map = {
        'method': 'method',
        'cookie_name': 'cookieName',
        'cookie_mode': 'cookieMode'
    }

    def __init__(self, method=None,cookie_name=None,cookie_mode=None):
        self._method = None
        self._cookie_name = None
        self._cookie_mode = None

        if method is not None:
            self.method = method
        if cookie_name is not None:
            self.cookie_name = cookie_name
        if cookie_mode is not None:
            self.cookie_mode = cookie_mode

    @property
    def method(self):
        return self._method
    
    @method.setter
    def method(self, method):
        self._method = method

    @property
    def cookie_name(self):
        return self._cookie_name
    
    @cookie_name.setter
    def cookie_name(self, cookie_name):
        self._cookie_name = cookie_name

    @property
    def cookie_mode(self):
        return self._cookie_mode
    
    @cookie_mode.setter
    def cookie_mode(self, cookie_mode):
        self._cookie_mode = cookie_mode


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LBPersistenceType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
