"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .network_service_type import NetworkServiceType


class IpsecVpnServiceType(NetworkServiceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'external_ip_address': 'str',
        'public_ip_address': 'str',
        'ipsec_vpn_tunnel': 'list[IpsecVpnTunnelType]'
    }

    attribute_map = {
        'external_ip_address': 'externalIpAddress',
        'public_ip_address': 'publicIpAddress',
        'ipsec_vpn_tunnel': 'ipsecVpnTunnel'
    }

    def __init__(self, external_ip_address=None,public_ip_address=None,ipsec_vpn_tunnel=None):
        self._external_ip_address = None
        self._public_ip_address = None
        self._ipsec_vpn_tunnel = None

        if external_ip_address is not None:
            self.external_ip_address = external_ip_address
        if public_ip_address is not None:
            self.public_ip_address = public_ip_address
        if ipsec_vpn_tunnel is not None:
            self.ipsec_vpn_tunnel = ipsec_vpn_tunnel

    @property
    def external_ip_address(self):
        return self._external_ip_address
    
    @external_ip_address.setter
    def external_ip_address(self, external_ip_address):
        self._external_ip_address = external_ip_address

    @property
    def public_ip_address(self):
        return self._public_ip_address
    
    @public_ip_address.setter
    def public_ip_address(self, public_ip_address):
        self._public_ip_address = public_ip_address

    @property
    def ipsec_vpn_tunnel(self):
        return self._ipsec_vpn_tunnel
    
    @ipsec_vpn_tunnel.setter
    def ipsec_vpn_tunnel(self, ipsec_vpn_tunnel):
        self._ipsec_vpn_tunnel = ipsec_vpn_tunnel


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IpsecVpnServiceType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
