"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class HardDiskAdapterType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'bus_number_ranges': 'RangesType',
        'unit_number_ranges': 'RangesType',
        'reserved_bus_unit_number': 'BusUnitNumberType',
        'id': 'str',
        'legacy_id': 'int',
        'maximum_disk_size_gb': 'int',
        'name': 'str'
    }

    attribute_map = {
        'bus_number_ranges': 'busNumberRanges',
        'unit_number_ranges': 'unitNumberRanges',
        'reserved_bus_unit_number': 'reservedBusUnitNumber',
        'id': 'id',
        'legacy_id': 'legacyId',
        'maximum_disk_size_gb': 'maximumDiskSizeGb',
        'name': 'name'
    }

    def __init__(self, bus_number_ranges=None,unit_number_ranges=None,reserved_bus_unit_number=None,id=None,legacy_id=None,maximum_disk_size_gb=None,name=None):
        self._bus_number_ranges = None
        self._unit_number_ranges = None
        self._reserved_bus_unit_number = None
        self._id = None
        self._legacy_id = None
        self._maximum_disk_size_gb = None
        self._name = None

        if bus_number_ranges is not None:
            self.bus_number_ranges = bus_number_ranges
        if unit_number_ranges is not None:
            self.unit_number_ranges = unit_number_ranges
        if reserved_bus_unit_number is not None:
            self.reserved_bus_unit_number = reserved_bus_unit_number
        if id is not None:
            self.id = id
        if legacy_id is not None:
            self.legacy_id = legacy_id
        if maximum_disk_size_gb is not None:
            self.maximum_disk_size_gb = maximum_disk_size_gb
        if name is not None:
            self.name = name

    @property
    def bus_number_ranges(self):
        return self._bus_number_ranges
    
    @bus_number_ranges.setter
    def bus_number_ranges(self, bus_number_ranges):
        self._bus_number_ranges = bus_number_ranges

    @property
    def unit_number_ranges(self):
        return self._unit_number_ranges
    
    @unit_number_ranges.setter
    def unit_number_ranges(self, unit_number_ranges):
        self._unit_number_ranges = unit_number_ranges

    @property
    def reserved_bus_unit_number(self):
        return self._reserved_bus_unit_number
    
    @reserved_bus_unit_number.setter
    def reserved_bus_unit_number(self, reserved_bus_unit_number):
        self._reserved_bus_unit_number = reserved_bus_unit_number

    @property
    def id(self):
        return self._id
    
    @id.setter
    def id(self, id):
        self._id = id

    @property
    def legacy_id(self):
        return self._legacy_id
    
    @legacy_id.setter
    def legacy_id(self, legacy_id):
        self._legacy_id = legacy_id

    @property
    def maximum_disk_size_gb(self):
        return self._maximum_disk_size_gb
    
    @maximum_disk_size_gb.setter
    def maximum_disk_size_gb(self, maximum_disk_size_gb):
        self._maximum_disk_size_gb = maximum_disk_size_gb

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HardDiskAdapterType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
