"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class GatewayInterfaceType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'display_name': 'str',
        'network': 'ReferenceType',
        'interface_type': 'str',
        'subnet_participation': 'list[SubnetParticipationType]',
        'apply_rate_limit': 'bool',
        'in_rate_limit': 'int',
        'out_rate_limit': 'int',
        'use_for_default_route': 'bool',
        'connected': 'bool',
        'quick_add_allocated_ip_count': 'int'
    }

    attribute_map = {
        'name': 'name',
        'display_name': 'displayName',
        'network': 'network',
        'interface_type': 'interfaceType',
        'subnet_participation': 'subnetParticipation',
        'apply_rate_limit': 'applyRateLimit',
        'in_rate_limit': 'inRateLimit',
        'out_rate_limit': 'outRateLimit',
        'use_for_default_route': 'useForDefaultRoute',
        'connected': 'connected',
        'quick_add_allocated_ip_count': 'quickAddAllocatedIpCount'
    }

    def __init__(self, name=None,display_name=None,network=None,interface_type=None,subnet_participation=None,apply_rate_limit=None,in_rate_limit=None,out_rate_limit=None,use_for_default_route=None,connected=None,quick_add_allocated_ip_count=None):
        self._name = None
        self._display_name = None
        self._network = None
        self._interface_type = None
        self._subnet_participation = None
        self._apply_rate_limit = None
        self._in_rate_limit = None
        self._out_rate_limit = None
        self._use_for_default_route = None
        self._connected = None
        self._quick_add_allocated_ip_count = None

        if name is not None:
            self.name = name
        if display_name is not None:
            self.display_name = display_name
        if network is not None:
            self.network = network
        if interface_type is not None:
            self.interface_type = interface_type
        if subnet_participation is not None:
            self.subnet_participation = subnet_participation
        if apply_rate_limit is not None:
            self.apply_rate_limit = apply_rate_limit
        if in_rate_limit is not None:
            self.in_rate_limit = in_rate_limit
        if out_rate_limit is not None:
            self.out_rate_limit = out_rate_limit
        if use_for_default_route is not None:
            self.use_for_default_route = use_for_default_route
        if connected is not None:
            self.connected = connected
        if quick_add_allocated_ip_count is not None:
            self.quick_add_allocated_ip_count = quick_add_allocated_ip_count

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def display_name(self):
        return self._display_name
    
    @display_name.setter
    def display_name(self, display_name):
        self._display_name = display_name

    @property
    def network(self):
        return self._network
    
    @network.setter
    def network(self, network):
        self._network = network

    @property
    def interface_type(self):
        return self._interface_type
    
    @interface_type.setter
    def interface_type(self, interface_type):
        self._interface_type = interface_type

    @property
    def subnet_participation(self):
        return self._subnet_participation
    
    @subnet_participation.setter
    def subnet_participation(self, subnet_participation):
        self._subnet_participation = subnet_participation

    @property
    def apply_rate_limit(self):
        return self._apply_rate_limit
    
    @apply_rate_limit.setter
    def apply_rate_limit(self, apply_rate_limit):
        self._apply_rate_limit = apply_rate_limit

    @property
    def in_rate_limit(self):
        return self._in_rate_limit
    
    @in_rate_limit.setter
    def in_rate_limit(self, in_rate_limit):
        self._in_rate_limit = in_rate_limit

    @property
    def out_rate_limit(self):
        return self._out_rate_limit
    
    @out_rate_limit.setter
    def out_rate_limit(self, out_rate_limit):
        self._out_rate_limit = out_rate_limit

    @property
    def use_for_default_route(self):
        return self._use_for_default_route
    
    @use_for_default_route.setter
    def use_for_default_route(self, use_for_default_route):
        self._use_for_default_route = use_for_default_route

    @property
    def connected(self):
        return self._connected
    
    @connected.setter
    def connected(self, connected):
        self._connected = connected

    @property
    def quick_add_allocated_ip_count(self):
        return self._quick_add_allocated_ip_count
    
    @quick_add_allocated_ip_count.setter
    def quick_add_allocated_ip_count(self, quick_add_allocated_ip_count):
        self._quick_add_allocated_ip_count = quick_add_allocated_ip_count


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GatewayInterfaceType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
