"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class FromCloudTunnelListenerCreateParamsType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'port': 'int',
        'traffic_type': 'str',
        'endpoint_tag': 'str'
    }

    attribute_map = {
        'port': 'port',
        'traffic_type': 'trafficType',
        'endpoint_tag': 'endpointTag'
    }

    def __init__(self, port=None,traffic_type=None,endpoint_tag=None):
        self._port = None
        self._traffic_type = None
        self._endpoint_tag = None

        if port is not None:
            self.port = port
        if traffic_type is not None:
            self.traffic_type = traffic_type
        if endpoint_tag is not None:
            self.endpoint_tag = endpoint_tag

    @property
    def port(self):
        return self._port
    
    @port.setter
    def port(self, port):
        self._port = port

    @property
    def traffic_type(self):
        return self._traffic_type
    
    @traffic_type.setter
    def traffic_type(self, traffic_type):
        self._traffic_type = traffic_type

    @property
    def endpoint_tag(self):
        return self._endpoint_tag
    
    @endpoint_tag.setter
    def endpoint_tag(self, endpoint_tag):
        self._endpoint_tag = endpoint_tag


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FromCloudTunnelListenerCreateParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
