"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class FirewallRuleType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'is_enabled': 'bool',
        'match_on_translate': 'bool',
        'description': 'str',
        'policy': 'str',
        'protocols': 'FirewallRuleProtocols',
        'icmp_sub_type': 'str',
        'port': 'int',
        'destination_port_range': 'str',
        'destination_ip': 'str',
        'destination_vm': 'VmSelectionType',
        'source_port': 'int',
        'source_port_range': 'str',
        'source_ip': 'str',
        'source_vm': 'VmSelectionType',
        'direction': 'str',
        'enable_logging': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'is_enabled': 'isEnabled',
        'match_on_translate': 'matchOnTranslate',
        'description': 'description',
        'policy': 'policy',
        'protocols': 'protocols',
        'icmp_sub_type': 'icmpSubType',
        'port': 'port',
        'destination_port_range': 'destinationPortRange',
        'destination_ip': 'destinationIp',
        'destination_vm': 'destinationVm',
        'source_port': 'sourcePort',
        'source_port_range': 'sourcePortRange',
        'source_ip': 'sourceIp',
        'source_vm': 'sourceVm',
        'direction': 'direction',
        'enable_logging': 'enableLogging'
    }

    def __init__(self, id=None,is_enabled=None,match_on_translate=None,description=None,policy=None,protocols=None,icmp_sub_type=None,port=None,destination_port_range=None,destination_ip=None,destination_vm=None,source_port=None,source_port_range=None,source_ip=None,source_vm=None,direction=None,enable_logging=None):
        self._id = None
        self._is_enabled = None
        self._match_on_translate = None
        self._description = None
        self._policy = None
        self._protocols = None
        self._icmp_sub_type = None
        self._port = None
        self._destination_port_range = None
        self._destination_ip = None
        self._destination_vm = None
        self._source_port = None
        self._source_port_range = None
        self._source_ip = None
        self._source_vm = None
        self._direction = None
        self._enable_logging = None

        if id is not None:
            self.id = id
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if match_on_translate is not None:
            self.match_on_translate = match_on_translate
        if description is not None:
            self.description = description
        if policy is not None:
            self.policy = policy
        if protocols is not None:
            self.protocols = protocols
        if icmp_sub_type is not None:
            self.icmp_sub_type = icmp_sub_type
        if port is not None:
            self.port = port
        if destination_port_range is not None:
            self.destination_port_range = destination_port_range
        if destination_ip is not None:
            self.destination_ip = destination_ip
        if destination_vm is not None:
            self.destination_vm = destination_vm
        if source_port is not None:
            self.source_port = source_port
        if source_port_range is not None:
            self.source_port_range = source_port_range
        if source_ip is not None:
            self.source_ip = source_ip
        if source_vm is not None:
            self.source_vm = source_vm
        if direction is not None:
            self.direction = direction
        if enable_logging is not None:
            self.enable_logging = enable_logging

    @property
    def id(self):
        return self._id
    
    @id.setter
    def id(self, id):
        self._id = id

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def match_on_translate(self):
        return self._match_on_translate
    
    @match_on_translate.setter
    def match_on_translate(self, match_on_translate):
        self._match_on_translate = match_on_translate

    @property
    def description(self):
        return self._description
    
    @description.setter
    def description(self, description):
        self._description = description

    @property
    def policy(self):
        return self._policy
    
    @policy.setter
    def policy(self, policy):
        self._policy = policy

    @property
    def protocols(self):
        return self._protocols
    
    @protocols.setter
    def protocols(self, protocols):
        self._protocols = protocols

    @property
    def icmp_sub_type(self):
        return self._icmp_sub_type
    
    @icmp_sub_type.setter
    def icmp_sub_type(self, icmp_sub_type):
        self._icmp_sub_type = icmp_sub_type

    @property
    def port(self):
        return self._port
    
    @port.setter
    def port(self, port):
        self._port = port

    @property
    def destination_port_range(self):
        return self._destination_port_range
    
    @destination_port_range.setter
    def destination_port_range(self, destination_port_range):
        self._destination_port_range = destination_port_range

    @property
    def destination_ip(self):
        return self._destination_ip
    
    @destination_ip.setter
    def destination_ip(self, destination_ip):
        self._destination_ip = destination_ip

    @property
    def destination_vm(self):
        return self._destination_vm
    
    @destination_vm.setter
    def destination_vm(self, destination_vm):
        self._destination_vm = destination_vm

    @property
    def source_port(self):
        return self._source_port
    
    @source_port.setter
    def source_port(self, source_port):
        self._source_port = source_port

    @property
    def source_port_range(self):
        return self._source_port_range
    
    @source_port_range.setter
    def source_port_range(self, source_port_range):
        self._source_port_range = source_port_range

    @property
    def source_ip(self):
        return self._source_ip
    
    @source_ip.setter
    def source_ip(self, source_ip):
        self._source_ip = source_ip

    @property
    def source_vm(self):
        return self._source_vm
    
    @source_vm.setter
    def source_vm(self, source_vm):
        self._source_vm = source_vm

    @property
    def direction(self):
        return self._direction
    
    @direction.setter
    def direction(self, direction):
        self._direction = direction

    @property
    def enable_logging(self):
        return self._enable_logging
    
    @enable_logging.setter
    def enable_logging(self, enable_logging):
        self._enable_logging = enable_logging


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FirewallRuleType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
