"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .entity_type import EntityType


class FileType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'bytes_transferred': 'int',
        'checksum': 'str',
        'size': 'int'
    }

    attribute_map = {
        'bytes_transferred': 'bytesTransferred',
        'checksum': 'checksum',
        'size': 'size'
    }

    def __init__(self, bytes_transferred=None,checksum=None,size=None):
        self._bytes_transferred = None
        self._checksum = None
        self._size = None

        if bytes_transferred is not None:
            self.bytes_transferred = bytes_transferred
        if checksum is not None:
            self.checksum = checksum
        if size is not None:
            self.size = size

    @property
    def bytes_transferred(self):
        return self._bytes_transferred
    
    @bytes_transferred.setter
    def bytes_transferred(self, bytes_transferred):
        self._bytes_transferred = bytes_transferred

    @property
    def checksum(self):
        return self._checksum
    
    @checksum.setter
    def checksum(self, checksum):
        self._checksum = checksum

    @property
    def size(self):
        return self._size
    
    @size.setter
    def size(self, size):
        self._size = size


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FileType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
