"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..entity_type import EntityType


class VMWVdcTemplateType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'tenant_name': 'str',
        'tenant_description': 'str',
        'provider_vdc_reference': 'list[VMWVdcTemplateProviderVdcSpecificationType]',
        'vdc_template_specification': 'VMWVdcTemplateSpecificationType'
    }

    attribute_map = {
        'tenant_name': 'tenantName',
        'tenant_description': 'tenantDescription',
        'provider_vdc_reference': 'providerVdcReference',
        'vdc_template_specification': 'vdcTemplateSpecification'
    }

    def __init__(self, tenant_name=None,tenant_description=None,provider_vdc_reference=None,vdc_template_specification=None):
        self._tenant_name = None
        self._tenant_description = None
        self._provider_vdc_reference = None
        self._vdc_template_specification = None

        if tenant_name is not None:
            self.tenant_name = tenant_name
        if tenant_description is not None:
            self.tenant_description = tenant_description
        if provider_vdc_reference is not None:
            self.provider_vdc_reference = provider_vdc_reference
        if vdc_template_specification is not None:
            self.vdc_template_specification = vdc_template_specification

    @property
    def tenant_name(self):
        return self._tenant_name
    
    @tenant_name.setter
    def tenant_name(self, tenant_name):
        self._tenant_name = tenant_name

    @property
    def tenant_description(self):
        return self._tenant_description
    
    @tenant_description.setter
    def tenant_description(self, tenant_description):
        self._tenant_description = tenant_description

    @property
    def provider_vdc_reference(self):
        return self._provider_vdc_reference
    
    @provider_vdc_reference.setter
    def provider_vdc_reference(self, provider_vdc_reference):
        self._provider_vdc_reference = provider_vdc_reference

    @property
    def vdc_template_specification(self):
        return self._vdc_template_specification
    
    @vdc_template_specification.setter
    def vdc_template_specification(self, vdc_template_specification):
        self._vdc_template_specification = vdc_template_specification


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VMWVdcTemplateType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
