"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .vmw_vdc_template_specification_type import VMWVdcTemplateSpecificationType


class VMWAllocationPoolVdcTemplateSpecificationType(VMWVdcTemplateSpecificationType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cpu_allocation_mhz': 'int',
        'memory_allocation_mb': 'int',
        'cpu_guaranteed_percentage': 'int',
        'v_cpu_in_mhz': 'int',
        'memory_guaranteed_percentage': 'int'
    }

    attribute_map = {
        'cpu_allocation_mhz': 'cpuAllocationMhz',
        'memory_allocation_mb': 'memoryAllocationMB',
        'cpu_guaranteed_percentage': 'cpuGuaranteedPercentage',
        'v_cpu_in_mhz': 'vCpuInMhz',
        'memory_guaranteed_percentage': 'memoryGuaranteedPercentage'
    }

    def __init__(self, cpu_allocation_mhz=None,memory_allocation_mb=None,cpu_guaranteed_percentage=None,v_cpu_in_mhz=None,memory_guaranteed_percentage=None):
        self._cpu_allocation_mhz = None
        self._memory_allocation_mb = None
        self._cpu_guaranteed_percentage = None
        self._v_cpu_in_mhz = None
        self._memory_guaranteed_percentage = None

        if cpu_allocation_mhz is not None:
            self.cpu_allocation_mhz = cpu_allocation_mhz
        if memory_allocation_mb is not None:
            self.memory_allocation_mb = memory_allocation_mb
        if cpu_guaranteed_percentage is not None:
            self.cpu_guaranteed_percentage = cpu_guaranteed_percentage
        if v_cpu_in_mhz is not None:
            self.v_cpu_in_mhz = v_cpu_in_mhz
        if memory_guaranteed_percentage is not None:
            self.memory_guaranteed_percentage = memory_guaranteed_percentage

    @property
    def cpu_allocation_mhz(self):
        return self._cpu_allocation_mhz
    
    @cpu_allocation_mhz.setter
    def cpu_allocation_mhz(self, cpu_allocation_mhz):
        self._cpu_allocation_mhz = cpu_allocation_mhz

    @property
    def memory_allocation_mb(self):
        return self._memory_allocation_mb
    
    @memory_allocation_mb.setter
    def memory_allocation_mb(self, memory_allocation_mb):
        self._memory_allocation_mb = memory_allocation_mb

    @property
    def cpu_guaranteed_percentage(self):
        return self._cpu_guaranteed_percentage
    
    @cpu_guaranteed_percentage.setter
    def cpu_guaranteed_percentage(self, cpu_guaranteed_percentage):
        self._cpu_guaranteed_percentage = cpu_guaranteed_percentage

    @property
    def v_cpu_in_mhz(self):
        return self._v_cpu_in_mhz
    
    @v_cpu_in_mhz.setter
    def v_cpu_in_mhz(self, v_cpu_in_mhz):
        self._v_cpu_in_mhz = v_cpu_in_mhz

    @property
    def memory_guaranteed_percentage(self):
        return self._memory_guaranteed_percentage
    
    @memory_guaranteed_percentage.setter
    def memory_guaranteed_percentage(self, memory_guaranteed_percentage):
        self._memory_guaranteed_percentage = memory_guaranteed_percentage


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VMWAllocationPoolVdcTemplateSpecificationType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
