"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re


class VmObjectRefsListType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'vm_object_ref': 'list[VmObjectRefType]',
        'number_of_pages': 'int',
        'page': 'int'
    }

    attribute_map = {
        'vm_object_ref': 'vmObjectRef',
        'number_of_pages': 'numberOfPages',
        'page': 'page'
    }

    def __init__(self, vm_object_ref=None,number_of_pages=None,page=None):
        self._vm_object_ref = None
        self._number_of_pages = None
        self._page = None

        if vm_object_ref is not None:
            self.vm_object_ref = vm_object_ref
        if number_of_pages is not None:
            self.number_of_pages = number_of_pages
        if page is not None:
            self.page = page

    @property
    def vm_object_ref(self):
        return self._vm_object_ref
    
    @vm_object_ref.setter
    def vm_object_ref(self, vm_object_ref):
        self._vm_object_ref = vm_object_ref

    @property
    def number_of_pages(self):
        return self._number_of_pages
    
    @number_of_pages.setter
    def number_of_pages(self, number_of_pages):
        self._number_of_pages = number_of_pages

    @property
    def page(self):
        return self._page
    
    @page.setter
    def page(self, page):
        self._page = page


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmObjectRefsListType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
