"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .server_type import ServerType


class VimServerType(ServerType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'is_enabled': 'bool',
        'root_folder': 'str',
        'vc_none_network': 'str',
        'compute_provider_scope': 'str',
        'is_connected': 'bool',
        'shield_manager_host': 'str',
        'shield_manager_user_name': 'str',
        'uuid': 'str',
        'vc_proxy': 'str',
        'vc_version': 'str',
        'use_vsphere_service': 'bool',
        'vsphere_web_client_server_url': 'str',
        'tenant_scoped': 'bool',
        'provider_scoped': 'bool',
        'listener_state': 'str',
        'cluster_health_status': 'str',
        'proxy_enabled': 'bool',
        'clusters_count': 'int',
        'total_vm_count': 'int',
        'powered_on_vm_count': 'int',
        'total_mem_mb': 'int',
        'reserved_mem_mb': 'int',
        'demanded_mem_mb': 'int',
        'total_cpu_mhz': 'int',
        'reserved_cpu_mhz': 'int',
        'demanded_cpu_mhz': 'int',
        'total_storage_mb': 'int',
        'free_storage_mb': 'int',
        'uncommitted_storage_mb': 'int'
    }

    attribute_map = {
        'is_enabled': 'isEnabled',
        'root_folder': 'rootFolder',
        'vc_none_network': 'vcNoneNetwork',
        'compute_provider_scope': 'computeProviderScope',
        'is_connected': 'isConnected',
        'shield_manager_host': 'shieldManagerHost',
        'shield_manager_user_name': 'shieldManagerUserName',
        'uuid': 'uuid',
        'vc_proxy': 'vcProxy',
        'vc_version': 'vcVersion',
        'use_vsphere_service': 'useVsphereService',
        'vsphere_web_client_server_url': 'vsphereWebClientServerUrl',
        'tenant_scoped': 'tenantScoped',
        'provider_scoped': 'providerScoped',
        'listener_state': 'listenerState',
        'cluster_health_status': 'clusterHealthStatus',
        'proxy_enabled': 'proxyEnabled',
        'clusters_count': 'clustersCount',
        'total_vm_count': 'totalVmCount',
        'powered_on_vm_count': 'poweredOnVmCount',
        'total_mem_mb': 'totalMemMb',
        'reserved_mem_mb': 'reservedMemMb',
        'demanded_mem_mb': 'demandedMemMb',
        'total_cpu_mhz': 'totalCpuMhz',
        'reserved_cpu_mhz': 'reservedCpuMhz',
        'demanded_cpu_mhz': 'demandedCpuMhz',
        'total_storage_mb': 'totalStorageMb',
        'free_storage_mb': 'freeStorageMb',
        'uncommitted_storage_mb': 'uncommittedStorageMb'
    }

    def __init__(self, is_enabled=None,root_folder=None,vc_none_network=None,compute_provider_scope=None,is_connected=None,shield_manager_host=None,shield_manager_user_name=None,uuid=None,vc_proxy=None,vc_version=None,use_vsphere_service=None,vsphere_web_client_server_url=None,tenant_scoped=None,provider_scoped=None,listener_state=None,cluster_health_status=None,proxy_enabled=None,clusters_count=None,total_vm_count=None,powered_on_vm_count=None,total_mem_mb=None,reserved_mem_mb=None,demanded_mem_mb=None,total_cpu_mhz=None,reserved_cpu_mhz=None,demanded_cpu_mhz=None,total_storage_mb=None,free_storage_mb=None,uncommitted_storage_mb=None):
        self._is_enabled = None
        self._root_folder = None
        self._vc_none_network = None
        self._compute_provider_scope = None
        self._is_connected = None
        self._shield_manager_host = None
        self._shield_manager_user_name = None
        self._uuid = None
        self._vc_proxy = None
        self._vc_version = None
        self._use_vsphere_service = None
        self._vsphere_web_client_server_url = None
        self._tenant_scoped = None
        self._provider_scoped = None
        self._listener_state = None
        self._cluster_health_status = None
        self._proxy_enabled = None
        self._clusters_count = None
        self._total_vm_count = None
        self._powered_on_vm_count = None
        self._total_mem_mb = None
        self._reserved_mem_mb = None
        self._demanded_mem_mb = None
        self._total_cpu_mhz = None
        self._reserved_cpu_mhz = None
        self._demanded_cpu_mhz = None
        self._total_storage_mb = None
        self._free_storage_mb = None
        self._uncommitted_storage_mb = None

        if is_enabled is not None:
            self.is_enabled = is_enabled
        if root_folder is not None:
            self.root_folder = root_folder
        if vc_none_network is not None:
            self.vc_none_network = vc_none_network
        if compute_provider_scope is not None:
            self.compute_provider_scope = compute_provider_scope
        if is_connected is not None:
            self.is_connected = is_connected
        if shield_manager_host is not None:
            self.shield_manager_host = shield_manager_host
        if shield_manager_user_name is not None:
            self.shield_manager_user_name = shield_manager_user_name
        if uuid is not None:
            self.uuid = uuid
        if vc_proxy is not None:
            self.vc_proxy = vc_proxy
        if vc_version is not None:
            self.vc_version = vc_version
        if use_vsphere_service is not None:
            self.use_vsphere_service = use_vsphere_service
        if vsphere_web_client_server_url is not None:
            self.vsphere_web_client_server_url = vsphere_web_client_server_url
        if tenant_scoped is not None:
            self.tenant_scoped = tenant_scoped
        if provider_scoped is not None:
            self.provider_scoped = provider_scoped
        if listener_state is not None:
            self.listener_state = listener_state
        if cluster_health_status is not None:
            self.cluster_health_status = cluster_health_status
        if proxy_enabled is not None:
            self.proxy_enabled = proxy_enabled
        if clusters_count is not None:
            self.clusters_count = clusters_count
        if total_vm_count is not None:
            self.total_vm_count = total_vm_count
        if powered_on_vm_count is not None:
            self.powered_on_vm_count = powered_on_vm_count
        if total_mem_mb is not None:
            self.total_mem_mb = total_mem_mb
        if reserved_mem_mb is not None:
            self.reserved_mem_mb = reserved_mem_mb
        if demanded_mem_mb is not None:
            self.demanded_mem_mb = demanded_mem_mb
        if total_cpu_mhz is not None:
            self.total_cpu_mhz = total_cpu_mhz
        if reserved_cpu_mhz is not None:
            self.reserved_cpu_mhz = reserved_cpu_mhz
        if demanded_cpu_mhz is not None:
            self.demanded_cpu_mhz = demanded_cpu_mhz
        if total_storage_mb is not None:
            self.total_storage_mb = total_storage_mb
        if free_storage_mb is not None:
            self.free_storage_mb = free_storage_mb
        if uncommitted_storage_mb is not None:
            self.uncommitted_storage_mb = uncommitted_storage_mb

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def root_folder(self):
        return self._root_folder
    
    @root_folder.setter
    def root_folder(self, root_folder):
        self._root_folder = root_folder

    @property
    def vc_none_network(self):
        return self._vc_none_network
    
    @vc_none_network.setter
    def vc_none_network(self, vc_none_network):
        self._vc_none_network = vc_none_network

    @property
    def compute_provider_scope(self):
        return self._compute_provider_scope
    
    @compute_provider_scope.setter
    def compute_provider_scope(self, compute_provider_scope):
        self._compute_provider_scope = compute_provider_scope

    @property
    def is_connected(self):
        return self._is_connected
    
    @is_connected.setter
    def is_connected(self, is_connected):
        self._is_connected = is_connected

    @property
    def shield_manager_host(self):
        return self._shield_manager_host
    
    @shield_manager_host.setter
    def shield_manager_host(self, shield_manager_host):
        self._shield_manager_host = shield_manager_host

    @property
    def shield_manager_user_name(self):
        return self._shield_manager_user_name
    
    @shield_manager_user_name.setter
    def shield_manager_user_name(self, shield_manager_user_name):
        self._shield_manager_user_name = shield_manager_user_name

    @property
    def uuid(self):
        return self._uuid
    
    @uuid.setter
    def uuid(self, uuid):
        self._uuid = uuid

    @property
    def vc_proxy(self):
        return self._vc_proxy
    
    @vc_proxy.setter
    def vc_proxy(self, vc_proxy):
        self._vc_proxy = vc_proxy

    @property
    def vc_version(self):
        return self._vc_version
    
    @vc_version.setter
    def vc_version(self, vc_version):
        self._vc_version = vc_version

    @property
    def use_vsphere_service(self):
        return self._use_vsphere_service
    
    @use_vsphere_service.setter
    def use_vsphere_service(self, use_vsphere_service):
        self._use_vsphere_service = use_vsphere_service

    @property
    def vsphere_web_client_server_url(self):
        return self._vsphere_web_client_server_url
    
    @vsphere_web_client_server_url.setter
    def vsphere_web_client_server_url(self, vsphere_web_client_server_url):
        self._vsphere_web_client_server_url = vsphere_web_client_server_url

    @property
    def tenant_scoped(self):
        return self._tenant_scoped
    
    @tenant_scoped.setter
    def tenant_scoped(self, tenant_scoped):
        self._tenant_scoped = tenant_scoped

    @property
    def provider_scoped(self):
        return self._provider_scoped
    
    @provider_scoped.setter
    def provider_scoped(self, provider_scoped):
        self._provider_scoped = provider_scoped

    @property
    def listener_state(self):
        return self._listener_state
    
    @listener_state.setter
    def listener_state(self, listener_state):
        self._listener_state = listener_state

    @property
    def cluster_health_status(self):
        return self._cluster_health_status
    
    @cluster_health_status.setter
    def cluster_health_status(self, cluster_health_status):
        self._cluster_health_status = cluster_health_status

    @property
    def proxy_enabled(self):
        return self._proxy_enabled
    
    @proxy_enabled.setter
    def proxy_enabled(self, proxy_enabled):
        self._proxy_enabled = proxy_enabled

    @property
    def clusters_count(self):
        return self._clusters_count
    
    @clusters_count.setter
    def clusters_count(self, clusters_count):
        self._clusters_count = clusters_count

    @property
    def total_vm_count(self):
        return self._total_vm_count
    
    @total_vm_count.setter
    def total_vm_count(self, total_vm_count):
        self._total_vm_count = total_vm_count

    @property
    def powered_on_vm_count(self):
        return self._powered_on_vm_count
    
    @powered_on_vm_count.setter
    def powered_on_vm_count(self, powered_on_vm_count):
        self._powered_on_vm_count = powered_on_vm_count

    @property
    def total_mem_mb(self):
        return self._total_mem_mb
    
    @total_mem_mb.setter
    def total_mem_mb(self, total_mem_mb):
        self._total_mem_mb = total_mem_mb

    @property
    def reserved_mem_mb(self):
        return self._reserved_mem_mb
    
    @reserved_mem_mb.setter
    def reserved_mem_mb(self, reserved_mem_mb):
        self._reserved_mem_mb = reserved_mem_mb

    @property
    def demanded_mem_mb(self):
        return self._demanded_mem_mb
    
    @demanded_mem_mb.setter
    def demanded_mem_mb(self, demanded_mem_mb):
        self._demanded_mem_mb = demanded_mem_mb

    @property
    def total_cpu_mhz(self):
        return self._total_cpu_mhz
    
    @total_cpu_mhz.setter
    def total_cpu_mhz(self, total_cpu_mhz):
        self._total_cpu_mhz = total_cpu_mhz

    @property
    def reserved_cpu_mhz(self):
        return self._reserved_cpu_mhz
    
    @reserved_cpu_mhz.setter
    def reserved_cpu_mhz(self, reserved_cpu_mhz):
        self._reserved_cpu_mhz = reserved_cpu_mhz

    @property
    def demanded_cpu_mhz(self):
        return self._demanded_cpu_mhz
    
    @demanded_cpu_mhz.setter
    def demanded_cpu_mhz(self, demanded_cpu_mhz):
        self._demanded_cpu_mhz = demanded_cpu_mhz

    @property
    def total_storage_mb(self):
        return self._total_storage_mb
    
    @total_storage_mb.setter
    def total_storage_mb(self, total_storage_mb):
        self._total_storage_mb = total_storage_mb

    @property
    def free_storage_mb(self):
        return self._free_storage_mb
    
    @free_storage_mb.setter
    def free_storage_mb(self, free_storage_mb):
        self._free_storage_mb = free_storage_mb

    @property
    def uncommitted_storage_mb(self):
        return self._uncommitted_storage_mb
    
    @uncommitted_storage_mb.setter
    def uncommitted_storage_mb(self, uncommitted_storage_mb):
        self._uncommitted_storage_mb = uncommitted_storage_mb


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VimServerType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
