"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..params_type import ParamsType


class TenantMigrationParamsType(ParamsType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'orgs': 'OrgsType',
        'source_datastores': 'DatastoresType',
        'target_datastores': 'DatastoresType'
    }

    attribute_map = {
        'orgs': 'orgs',
        'source_datastores': 'sourceDatastores',
        'target_datastores': 'targetDatastores'
    }

    def __init__(self, orgs=None,source_datastores=None,target_datastores=None):
        self._orgs = None
        self._source_datastores = None
        self._target_datastores = None

        if orgs is not None:
            self.orgs = orgs
        if source_datastores is not None:
            self.source_datastores = source_datastores
        if target_datastores is not None:
            self.target_datastores = target_datastores

    @property
    def orgs(self):
        return self._orgs
    
    @orgs.setter
    def orgs(self, orgs):
        self._orgs = orgs

    @property
    def source_datastores(self):
        return self._source_datastores
    
    @source_datastores.setter
    def source_datastores(self, source_datastores):
        self._source_datastores = source_datastores

    @property
    def target_datastores(self):
        return self._target_datastores
    
    @target_datastores.setter
    def target_datastores(self, target_datastores):
        self._target_datastores = target_datastores


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TenantMigrationParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
