"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..v_cloud_extensible_type import VCloudExtensibleType


class SerialPortConfigType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'status': 'str',
        'start_connected': 'bool',
        'allow_guest_control': 'bool',
        'direction': 'str',
        'service_uri': 'str',
        'yield_on_poll': 'bool'
    }

    attribute_map = {
        'status': 'status',
        'start_connected': 'startConnected',
        'allow_guest_control': 'allowGuestControl',
        'direction': 'direction',
        'service_uri': 'serviceUri',
        'yield_on_poll': 'yieldOnPoll'
    }

    def __init__(self, status=None,start_connected=None,allow_guest_control=None,direction=None,service_uri=None,yield_on_poll=None):
        self._status = None
        self._start_connected = None
        self._allow_guest_control = None
        self._direction = None
        self._service_uri = None
        self._yield_on_poll = None

        if status is not None:
            self.status = status
        if start_connected is not None:
            self.start_connected = start_connected
        if allow_guest_control is not None:
            self.allow_guest_control = allow_guest_control
        if direction is not None:
            self.direction = direction
        if service_uri is not None:
            self.service_uri = service_uri
        if yield_on_poll is not None:
            self.yield_on_poll = yield_on_poll

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status

    @property
    def start_connected(self):
        return self._start_connected
    
    @start_connected.setter
    def start_connected(self, start_connected):
        self._start_connected = start_connected

    @property
    def allow_guest_control(self):
        return self._allow_guest_control
    
    @allow_guest_control.setter
    def allow_guest_control(self, allow_guest_control):
        self._allow_guest_control = allow_guest_control

    @property
    def direction(self):
        return self._direction
    
    @direction.setter
    def direction(self, direction):
        self._direction = direction

    @property
    def service_uri(self):
        return self._service_uri
    
    @service_uri.setter
    def service_uri(self, service_uri):
        self._service_uri = service_uri

    @property
    def yield_on_poll(self):
        return self._yield_on_poll
    
    @yield_on_poll.setter
    def yield_on_poll(self, yield_on_poll):
        self._yield_on_poll = yield_on_poll


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SerialPortConfigType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
