"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..entity_type import EntityType


class ResourcePoolType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'mo_ref': 'str',
        'vim_object_type': 'str',
        'data_store_refs': 'VimObjectRefsType'
    }

    attribute_map = {
        'mo_ref': 'moRef',
        'vim_object_type': 'vimObjectType',
        'data_store_refs': 'dataStoreRefs'
    }

    def __init__(self, mo_ref=None,vim_object_type=None,data_store_refs=None):
        self._mo_ref = None
        self._vim_object_type = None
        self._data_store_refs = None

        if mo_ref is not None:
            self.mo_ref = mo_ref
        if vim_object_type is not None:
            self.vim_object_type = vim_object_type
        if data_store_refs is not None:
            self.data_store_refs = data_store_refs

    @property
    def mo_ref(self):
        return self._mo_ref
    
    @mo_ref.setter
    def mo_ref(self, mo_ref):
        self._mo_ref = mo_ref

    @property
    def vim_object_type(self):
        return self._vim_object_type
    
    @vim_object_type.setter
    def vim_object_type(self, vim_object_type):
        self._vim_object_type = vim_object_type

    @property
    def data_store_refs(self):
        return self._data_store_refs
    
    @data_store_refs.setter
    def data_store_refs(self, data_store_refs):
        self._data_store_refs = data_store_refs


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ResourcePoolType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
