"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..resource_type import ResourceType


class LicenseType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'serial_number': 'str',
        'licensed_vm_count': 'int',
        'expiration_date': 'str',
        'valid_serial': 'bool',
        'expired': 'bool',
        'persisted': 'bool',
        'publishing_to_remote_sites_feature': 'bool',
        'subscribing_to_remote_sites_feature': 'bool',
        'license_metrics_info': 'LicenseMetricsInfoType'
    }

    attribute_map = {
        'serial_number': 'serialNumber',
        'licensed_vm_count': 'licensedVMCount',
        'expiration_date': 'expirationDate',
        'valid_serial': 'validSerial',
        'expired': 'expired',
        'persisted': 'persisted',
        'publishing_to_remote_sites_feature': 'publishingToRemoteSitesFeature',
        'subscribing_to_remote_sites_feature': 'subscribingToRemoteSitesFeature',
        'license_metrics_info': 'licenseMetricsInfo'
    }

    def __init__(self, serial_number=None,licensed_vm_count=None,expiration_date=None,valid_serial=None,expired=None,persisted=None,publishing_to_remote_sites_feature=None,subscribing_to_remote_sites_feature=None,license_metrics_info=None):
        self._serial_number = None
        self._licensed_vm_count = None
        self._expiration_date = None
        self._valid_serial = None
        self._expired = None
        self._persisted = None
        self._publishing_to_remote_sites_feature = None
        self._subscribing_to_remote_sites_feature = None
        self._license_metrics_info = None

        if serial_number is not None:
            self.serial_number = serial_number
        if licensed_vm_count is not None:
            self.licensed_vm_count = licensed_vm_count
        if expiration_date is not None:
            self.expiration_date = expiration_date
        if valid_serial is not None:
            self.valid_serial = valid_serial
        if expired is not None:
            self.expired = expired
        if persisted is not None:
            self.persisted = persisted
        if publishing_to_remote_sites_feature is not None:
            self.publishing_to_remote_sites_feature = publishing_to_remote_sites_feature
        if subscribing_to_remote_sites_feature is not None:
            self.subscribing_to_remote_sites_feature = subscribing_to_remote_sites_feature
        if license_metrics_info is not None:
            self.license_metrics_info = license_metrics_info

    @property
    def serial_number(self):
        return self._serial_number
    
    @serial_number.setter
    def serial_number(self, serial_number):
        self._serial_number = serial_number

    @property
    def licensed_vm_count(self):
        return self._licensed_vm_count
    
    @licensed_vm_count.setter
    def licensed_vm_count(self, licensed_vm_count):
        self._licensed_vm_count = licensed_vm_count

    @property
    def expiration_date(self):
        return self._expiration_date
    
    @expiration_date.setter
    def expiration_date(self, expiration_date):
        self._expiration_date = expiration_date

    @property
    def valid_serial(self):
        return self._valid_serial
    
    @valid_serial.setter
    def valid_serial(self, valid_serial):
        self._valid_serial = valid_serial

    @property
    def expired(self):
        return self._expired
    
    @expired.setter
    def expired(self, expired):
        self._expired = expired

    @property
    def persisted(self):
        return self._persisted
    
    @persisted.setter
    def persisted(self, persisted):
        self._persisted = persisted

    @property
    def publishing_to_remote_sites_feature(self):
        return self._publishing_to_remote_sites_feature
    
    @publishing_to_remote_sites_feature.setter
    def publishing_to_remote_sites_feature(self, publishing_to_remote_sites_feature):
        self._publishing_to_remote_sites_feature = publishing_to_remote_sites_feature

    @property
    def subscribing_to_remote_sites_feature(self):
        return self._subscribing_to_remote_sites_feature
    
    @subscribing_to_remote_sites_feature.setter
    def subscribing_to_remote_sites_feature(self, subscribing_to_remote_sites_feature):
        self._subscribing_to_remote_sites_feature = subscribing_to_remote_sites_feature

    @property
    def license_metrics_info(self):
        return self._license_metrics_info
    
    @license_metrics_info.setter
    def license_metrics_info(self, license_metrics_info):
        self._license_metrics_info = license_metrics_info


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LicenseType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
