"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..entity_type import EntityType


class HostType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ready': 'bool',
        'available': 'bool',
        'enabled': 'bool',
        'busy': 'bool',
        'enable_host_for_host_spanning': 'bool',
        'cpu_type': 'str',
        'num_of_cpus_packages': 'int',
        'num_of_cpus_logical': 'int',
        'cpu_total': 'int',
        'mem_used': 'int',
        'mem_total': 'int',
        'host_os_name': 'str',
        'host_os_version': 'str',
        'system_messages': 'str',
        'vim_property_page_url': 'str',
        'vm_mo_ref': 'str'
    }

    attribute_map = {
        'ready': 'ready',
        'available': 'available',
        'enabled': 'enabled',
        'busy': 'busy',
        'enable_host_for_host_spanning': 'enableHostForHostSpanning',
        'cpu_type': 'cpuType',
        'num_of_cpus_packages': 'numOfCpusPackages',
        'num_of_cpus_logical': 'numOfCpusLogical',
        'cpu_total': 'cpuTotal',
        'mem_used': 'memUsed',
        'mem_total': 'memTotal',
        'host_os_name': 'hostOsName',
        'host_os_version': 'hostOsVersion',
        'system_messages': 'systemMessages',
        'vim_property_page_url': 'vimPropertyPageUrl',
        'vm_mo_ref': 'vmMoRef'
    }

    def __init__(self, ready=None,available=None,enabled=None,busy=None,enable_host_for_host_spanning=None,cpu_type=None,num_of_cpus_packages=None,num_of_cpus_logical=None,cpu_total=None,mem_used=None,mem_total=None,host_os_name=None,host_os_version=None,system_messages=None,vim_property_page_url=None,vm_mo_ref=None):
        self._ready = None
        self._available = None
        self._enabled = None
        self._busy = None
        self._enable_host_for_host_spanning = None
        self._cpu_type = None
        self._num_of_cpus_packages = None
        self._num_of_cpus_logical = None
        self._cpu_total = None
        self._mem_used = None
        self._mem_total = None
        self._host_os_name = None
        self._host_os_version = None
        self._system_messages = None
        self._vim_property_page_url = None
        self._vm_mo_ref = None

        if ready is not None:
            self.ready = ready
        if available is not None:
            self.available = available
        if enabled is not None:
            self.enabled = enabled
        if busy is not None:
            self.busy = busy
        if enable_host_for_host_spanning is not None:
            self.enable_host_for_host_spanning = enable_host_for_host_spanning
        if cpu_type is not None:
            self.cpu_type = cpu_type
        if num_of_cpus_packages is not None:
            self.num_of_cpus_packages = num_of_cpus_packages
        if num_of_cpus_logical is not None:
            self.num_of_cpus_logical = num_of_cpus_logical
        if cpu_total is not None:
            self.cpu_total = cpu_total
        if mem_used is not None:
            self.mem_used = mem_used
        if mem_total is not None:
            self.mem_total = mem_total
        if host_os_name is not None:
            self.host_os_name = host_os_name
        if host_os_version is not None:
            self.host_os_version = host_os_version
        if system_messages is not None:
            self.system_messages = system_messages
        if vim_property_page_url is not None:
            self.vim_property_page_url = vim_property_page_url
        if vm_mo_ref is not None:
            self.vm_mo_ref = vm_mo_ref

    @property
    def ready(self):
        return self._ready
    
    @ready.setter
    def ready(self, ready):
        self._ready = ready

    @property
    def available(self):
        return self._available
    
    @available.setter
    def available(self, available):
        self._available = available

    @property
    def enabled(self):
        return self._enabled
    
    @enabled.setter
    def enabled(self, enabled):
        self._enabled = enabled

    @property
    def busy(self):
        return self._busy
    
    @busy.setter
    def busy(self, busy):
        self._busy = busy

    @property
    def enable_host_for_host_spanning(self):
        return self._enable_host_for_host_spanning
    
    @enable_host_for_host_spanning.setter
    def enable_host_for_host_spanning(self, enable_host_for_host_spanning):
        self._enable_host_for_host_spanning = enable_host_for_host_spanning

    @property
    def cpu_type(self):
        return self._cpu_type
    
    @cpu_type.setter
    def cpu_type(self, cpu_type):
        self._cpu_type = cpu_type

    @property
    def num_of_cpus_packages(self):
        return self._num_of_cpus_packages
    
    @num_of_cpus_packages.setter
    def num_of_cpus_packages(self, num_of_cpus_packages):
        self._num_of_cpus_packages = num_of_cpus_packages

    @property
    def num_of_cpus_logical(self):
        return self._num_of_cpus_logical
    
    @num_of_cpus_logical.setter
    def num_of_cpus_logical(self, num_of_cpus_logical):
        self._num_of_cpus_logical = num_of_cpus_logical

    @property
    def cpu_total(self):
        return self._cpu_total
    
    @cpu_total.setter
    def cpu_total(self, cpu_total):
        self._cpu_total = cpu_total

    @property
    def mem_used(self):
        return self._mem_used
    
    @mem_used.setter
    def mem_used(self, mem_used):
        self._mem_used = mem_used

    @property
    def mem_total(self):
        return self._mem_total
    
    @mem_total.setter
    def mem_total(self, mem_total):
        self._mem_total = mem_total

    @property
    def host_os_name(self):
        return self._host_os_name
    
    @host_os_name.setter
    def host_os_name(self, host_os_name):
        self._host_os_name = host_os_name

    @property
    def host_os_version(self):
        return self._host_os_version
    
    @host_os_version.setter
    def host_os_version(self, host_os_version):
        self._host_os_version = host_os_version

    @property
    def system_messages(self):
        return self._system_messages
    
    @system_messages.setter
    def system_messages(self, system_messages):
        self._system_messages = system_messages

    @property
    def vim_property_page_url(self):
        return self._vim_property_page_url
    
    @vim_property_page_url.setter
    def vim_property_page_url(self, vim_property_page_url):
        self._vim_property_page_url = vim_property_page_url

    @property
    def vm_mo_ref(self):
        return self._vm_mo_ref
    
    @vm_mo_ref.setter
    def vm_mo_ref(self, vm_mo_ref):
        self._vm_mo_ref = vm_mo_ref


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HostType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
