"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .vmw_network_pool_type import VMWNetworkPoolType


class GenevePoolType(VMWNetworkPoolType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'transport_zone_path': 'str',
        'nsx_t_manager_ref': 'ReferenceType',
        'used_networks_count': 'int'
    }

    attribute_map = {
        'transport_zone_path': 'transportZonePath',
        'nsx_t_manager_ref': 'nsxTManagerRef',
        'used_networks_count': 'usedNetworksCount'
    }

    def __init__(self, transport_zone_path=None,nsx_t_manager_ref=None,used_networks_count=None):
        self._transport_zone_path = None
        self._nsx_t_manager_ref = None
        self._used_networks_count = None

        if transport_zone_path is not None:
            self.transport_zone_path = transport_zone_path
        if nsx_t_manager_ref is not None:
            self.nsx_t_manager_ref = nsx_t_manager_ref
        if used_networks_count is not None:
            self.used_networks_count = used_networks_count

    @property
    def transport_zone_path(self):
        return self._transport_zone_path
    
    @transport_zone_path.setter
    def transport_zone_path(self, transport_zone_path):
        self._transport_zone_path = transport_zone_path

    @property
    def nsx_t_manager_ref(self):
        return self._nsx_t_manager_ref
    
    @nsx_t_manager_ref.setter
    def nsx_t_manager_ref(self, nsx_t_manager_ref):
        self._nsx_t_manager_ref = nsx_t_manager_ref

    @property
    def used_networks_count(self):
        return self._used_networks_count
    
    @used_networks_count.setter
    def used_networks_count(self, used_networks_count):
        self._used_networks_count = used_networks_count


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GenevePoolType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
