"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .vmw_network_pool_type import VMWNetworkPoolType


class FencePoolType(VMWNetworkPoolType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'fence_id_count': 'int',
        'vlan_id': 'int',
        'vim_switch_ref': 'VimObjectRefType',
        'used_networks_count': 'int',
        'promiscuous_mode': 'bool',
        'mtu': 'int'
    }

    attribute_map = {
        'fence_id_count': 'fenceIdCount',
        'vlan_id': 'vlanId',
        'vim_switch_ref': 'vimSwitchRef',
        'used_networks_count': 'usedNetworksCount',
        'promiscuous_mode': 'promiscuousMode',
        'mtu': 'mtu'
    }

    def __init__(self, fence_id_count=None,vlan_id=None,vim_switch_ref=None,used_networks_count=None,promiscuous_mode=None,mtu=None):
        self._fence_id_count = None
        self._vlan_id = None
        self._vim_switch_ref = None
        self._used_networks_count = None
        self._promiscuous_mode = None
        self._mtu = None

        if fence_id_count is not None:
            self.fence_id_count = fence_id_count
        if vlan_id is not None:
            self.vlan_id = vlan_id
        if vim_switch_ref is not None:
            self.vim_switch_ref = vim_switch_ref
        if used_networks_count is not None:
            self.used_networks_count = used_networks_count
        if promiscuous_mode is not None:
            self.promiscuous_mode = promiscuous_mode
        if mtu is not None:
            self.mtu = mtu

    @property
    def fence_id_count(self):
        return self._fence_id_count
    
    @fence_id_count.setter
    def fence_id_count(self, fence_id_count):
        self._fence_id_count = fence_id_count

    @property
    def vlan_id(self):
        return self._vlan_id
    
    @vlan_id.setter
    def vlan_id(self, vlan_id):
        self._vlan_id = vlan_id

    @property
    def vim_switch_ref(self):
        return self._vim_switch_ref
    
    @vim_switch_ref.setter
    def vim_switch_ref(self, vim_switch_ref):
        self._vim_switch_ref = vim_switch_ref

    @property
    def used_networks_count(self):
        return self._used_networks_count
    
    @used_networks_count.setter
    def used_networks_count(self, used_networks_count):
        self._used_networks_count = used_networks_count

    @property
    def promiscuous_mode(self):
        return self._promiscuous_mode
    
    @promiscuous_mode.setter
    def promiscuous_mode(self, promiscuous_mode):
        self._promiscuous_mode = promiscuous_mode

    @property
    def mtu(self):
        return self._mtu
    
    @mtu.setter
    def mtu(self, mtu):
        self._mtu = mtu


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FencePoolType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
