"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..v_cloud_extensible_type import VCloudExtensibleType


class CbmDataType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'vim_server': 'ReferenceType',
        'backing_ref': 'str',
        'backing_ref_type': 'str'
    }

    attribute_map = {
        'vim_server': 'vimServer',
        'backing_ref': 'backingRef',
        'backing_ref_type': 'backingRefType'
    }

    def __init__(self, vim_server=None,backing_ref=None,backing_ref_type=None):
        self._vim_server = None
        self._backing_ref = None
        self._backing_ref_type = None

        if vim_server is not None:
            self.vim_server = vim_server
        if backing_ref is not None:
            self.backing_ref = backing_ref
        if backing_ref_type is not None:
            self.backing_ref_type = backing_ref_type

    @property
    def vim_server(self):
        return self._vim_server
    
    @vim_server.setter
    def vim_server(self, vim_server):
        self._vim_server = vim_server

    @property
    def backing_ref(self):
        return self._backing_ref
    
    @backing_ref.setter
    def backing_ref(self, backing_ref):
        self._backing_ref = backing_ref

    @property
    def backing_ref_type(self):
        return self._backing_ref_type
    
    @backing_ref_type.setter
    def backing_ref_type(self, backing_ref_type):
        self._backing_ref_type = backing_ref_type


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CbmDataType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
