"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..resource_type import ResourceType


class CatalogSettingsType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'is_sync_enabled': 'bool',
        'sync_start_date': 'str',
        'sync_stop_date': 'str',
        'next_sync_date': 'str',
        'refresh_interval': 'int'
    }

    attribute_map = {
        'is_sync_enabled': 'isSyncEnabled',
        'sync_start_date': 'syncStartDate',
        'sync_stop_date': 'syncStopDate',
        'next_sync_date': 'nextSyncDate',
        'refresh_interval': 'refreshInterval'
    }

    def __init__(self, is_sync_enabled=None,sync_start_date=None,sync_stop_date=None,next_sync_date=None,refresh_interval=None):
        self._is_sync_enabled = None
        self._sync_start_date = None
        self._sync_stop_date = None
        self._next_sync_date = None
        self._refresh_interval = None

        if is_sync_enabled is not None:
            self.is_sync_enabled = is_sync_enabled
        if sync_start_date is not None:
            self.sync_start_date = sync_start_date
        if sync_stop_date is not None:
            self.sync_stop_date = sync_stop_date
        if next_sync_date is not None:
            self.next_sync_date = next_sync_date
        if refresh_interval is not None:
            self.refresh_interval = refresh_interval

    @property
    def is_sync_enabled(self):
        return self._is_sync_enabled
    
    @is_sync_enabled.setter
    def is_sync_enabled(self, is_sync_enabled):
        self._is_sync_enabled = is_sync_enabled

    @property
    def sync_start_date(self):
        return self._sync_start_date
    
    @sync_start_date.setter
    def sync_start_date(self, sync_start_date):
        self._sync_start_date = sync_start_date

    @property
    def sync_stop_date(self):
        return self._sync_stop_date
    
    @sync_stop_date.setter
    def sync_stop_date(self, sync_stop_date):
        self._sync_stop_date = sync_stop_date

    @property
    def next_sync_date(self):
        return self._next_sync_date
    
    @next_sync_date.setter
    def next_sync_date(self, next_sync_date):
        self._next_sync_date = next_sync_date

    @property
    def refresh_interval(self):
        return self._refresh_interval
    
    @refresh_interval.setter
    def refresh_interval(self, refresh_interval):
        self._refresh_interval = refresh_interval


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CatalogSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
