"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..resource_type import ResourceType


class BrandingSettingsType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'company_name': 'str',
        'login_page_customization_theme': 'list[str]',
        'theme': 'str',
        'preview_custom_theme': 'list[str]',
        'final_custom_theme': 'list[str]',
        'about_company_url': 'str',
        'support_url': 'str',
        'sign_up_url': 'str',
        'forgot_user_name_or_password_url': 'str'
    }

    attribute_map = {
        'company_name': 'companyName',
        'login_page_customization_theme': 'loginPageCustomizationTheme',
        'theme': 'theme',
        'preview_custom_theme': 'previewCustomTheme',
        'final_custom_theme': 'finalCustomTheme',
        'about_company_url': 'aboutCompanyUrl',
        'support_url': 'supportUrl',
        'sign_up_url': 'signUpUrl',
        'forgot_user_name_or_password_url': 'forgotUserNameOrPasswordURL'
    }

    def __init__(self, company_name=None,login_page_customization_theme=None,theme=None,preview_custom_theme=None,final_custom_theme=None,about_company_url=None,support_url=None,sign_up_url=None,forgot_user_name_or_password_url=None):
        self._company_name = None
        self._login_page_customization_theme = None
        self._theme = None
        self._preview_custom_theme = None
        self._final_custom_theme = None
        self._about_company_url = None
        self._support_url = None
        self._sign_up_url = None
        self._forgot_user_name_or_password_url = None

        if company_name is not None:
            self.company_name = company_name
        if login_page_customization_theme is not None:
            self.login_page_customization_theme = login_page_customization_theme
        if theme is not None:
            self.theme = theme
        if preview_custom_theme is not None:
            self.preview_custom_theme = preview_custom_theme
        if final_custom_theme is not None:
            self.final_custom_theme = final_custom_theme
        if about_company_url is not None:
            self.about_company_url = about_company_url
        if support_url is not None:
            self.support_url = support_url
        if sign_up_url is not None:
            self.sign_up_url = sign_up_url
        if forgot_user_name_or_password_url is not None:
            self.forgot_user_name_or_password_url = forgot_user_name_or_password_url

    @property
    def company_name(self):
        return self._company_name
    
    @company_name.setter
    def company_name(self, company_name):
        self._company_name = company_name

    @property
    def login_page_customization_theme(self):
        return self._login_page_customization_theme
    
    @login_page_customization_theme.setter
    def login_page_customization_theme(self, login_page_customization_theme):
        self._login_page_customization_theme = login_page_customization_theme

    @property
    def theme(self):
        return self._theme
    
    @theme.setter
    def theme(self, theme):
        self._theme = theme

    @property
    def preview_custom_theme(self):
        return self._preview_custom_theme
    
    @preview_custom_theme.setter
    def preview_custom_theme(self, preview_custom_theme):
        self._preview_custom_theme = preview_custom_theme

    @property
    def final_custom_theme(self):
        return self._final_custom_theme
    
    @final_custom_theme.setter
    def final_custom_theme(self, final_custom_theme):
        self._final_custom_theme = final_custom_theme

    @property
    def about_company_url(self):
        return self._about_company_url
    
    @about_company_url.setter
    def about_company_url(self, about_company_url):
        self._about_company_url = about_company_url

    @property
    def support_url(self):
        return self._support_url
    
    @support_url.setter
    def support_url(self, support_url):
        self._support_url = support_url

    @property
    def sign_up_url(self):
        return self._sign_up_url
    
    @sign_up_url.setter
    def sign_up_url(self, sign_up_url):
        self._sign_up_url = sign_up_url

    @property
    def forgot_user_name_or_password_url(self):
        return self._forgot_user_name_or_password_url
    
    @forgot_user_name_or_password_url.setter
    def forgot_user_name_or_password_url(self, forgot_user_name_or_password_url):
        self._forgot_user_name_or_password_url = forgot_user_name_or_password_url


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BrandingSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
