"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .blocking_task_operation_params_type import BlockingTaskOperationParamsType


class BlockingTaskUpdateProgressParamsType(BlockingTaskOperationParamsType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'timeout_value_in_milliseconds': 'int'
    }

    attribute_map = {
        'timeout_value_in_milliseconds': 'timeoutValueInMilliseconds'
    }

    def __init__(self, timeout_value_in_milliseconds=None):
        self._timeout_value_in_milliseconds = None

        if timeout_value_in_milliseconds is not None:
            self.timeout_value_in_milliseconds = timeout_value_in_milliseconds

    @property
    def timeout_value_in_milliseconds(self):
        return self._timeout_value_in_milliseconds
    
    @timeout_value_in_milliseconds.setter
    def timeout_value_in_milliseconds(self, timeout_value_in_milliseconds):
        self._timeout_value_in_milliseconds = timeout_value_in_milliseconds


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BlockingTaskUpdateProgressParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
