"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..entity_type import EntityType


class AdminServiceType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'namespace': 'str',
        'enabled': 'bool',
        'authorization_enabled': 'bool',
        'routing_key': 'str',
        'priority': 'int',
        'exchange': 'str',
        'vendor': 'str',
        'api_filters': 'ApiFiltersType',
        'service_links': 'AdminServiceLinksType',
        'api_definitions': 'AdminApiDefinitionsType',
        'resource_classes': 'ResourceClassesType'
    }

    attribute_map = {
        'namespace': 'namespace',
        'enabled': 'enabled',
        'authorization_enabled': 'authorizationEnabled',
        'routing_key': 'routingKey',
        'priority': 'priority',
        'exchange': 'exchange',
        'vendor': 'vendor',
        'api_filters': 'apiFilters',
        'service_links': 'serviceLinks',
        'api_definitions': 'apiDefinitions',
        'resource_classes': 'resourceClasses'
    }

    def __init__(self, namespace=None,enabled=None,authorization_enabled=None,routing_key=None,priority=None,exchange=None,vendor=None,api_filters=None,service_links=None,api_definitions=None,resource_classes=None):
        self._namespace = None
        self._enabled = None
        self._authorization_enabled = None
        self._routing_key = None
        self._priority = None
        self._exchange = None
        self._vendor = None
        self._api_filters = None
        self._service_links = None
        self._api_definitions = None
        self._resource_classes = None

        if namespace is not None:
            self.namespace = namespace
        if enabled is not None:
            self.enabled = enabled
        if authorization_enabled is not None:
            self.authorization_enabled = authorization_enabled
        if routing_key is not None:
            self.routing_key = routing_key
        if priority is not None:
            self.priority = priority
        if exchange is not None:
            self.exchange = exchange
        if vendor is not None:
            self.vendor = vendor
        if api_filters is not None:
            self.api_filters = api_filters
        if service_links is not None:
            self.service_links = service_links
        if api_definitions is not None:
            self.api_definitions = api_definitions
        if resource_classes is not None:
            self.resource_classes = resource_classes

    @property
    def namespace(self):
        return self._namespace
    
    @namespace.setter
    def namespace(self, namespace):
        self._namespace = namespace

    @property
    def enabled(self):
        return self._enabled
    
    @enabled.setter
    def enabled(self, enabled):
        self._enabled = enabled

    @property
    def authorization_enabled(self):
        return self._authorization_enabled
    
    @authorization_enabled.setter
    def authorization_enabled(self, authorization_enabled):
        self._authorization_enabled = authorization_enabled

    @property
    def routing_key(self):
        return self._routing_key
    
    @routing_key.setter
    def routing_key(self, routing_key):
        self._routing_key = routing_key

    @property
    def priority(self):
        return self._priority
    
    @priority.setter
    def priority(self, priority):
        self._priority = priority

    @property
    def exchange(self):
        return self._exchange
    
    @exchange.setter
    def exchange(self, exchange):
        self._exchange = exchange

    @property
    def vendor(self):
        return self._vendor
    
    @vendor.setter
    def vendor(self, vendor):
        self._vendor = vendor

    @property
    def api_filters(self):
        return self._api_filters
    
    @api_filters.setter
    def api_filters(self, api_filters):
        self._api_filters = api_filters

    @property
    def service_links(self):
        return self._service_links
    
    @service_links.setter
    def service_links(self, service_links):
        self._service_links = service_links

    @property
    def api_definitions(self):
        return self._api_definitions
    
    @api_definitions.setter
    def api_definitions(self, api_definitions):
        self._api_definitions = api_definitions

    @property
    def resource_classes(self):
        return self._resource_classes
    
    @resource_classes.setter
    def resource_classes(self, resource_classes):
        self._resource_classes = resource_classes


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AdminServiceType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
