"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class DiskAttachOrDetachParamsType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'disk': 'ReferenceType',
        'bus_number': 'int',
        'unit_number': 'int'
    }

    attribute_map = {
        'disk': 'disk',
        'bus_number': 'busNumber',
        'unit_number': 'unitNumber'
    }

    def __init__(self, disk=None,bus_number=None,unit_number=None):
        self._disk = None
        self._bus_number = None
        self._unit_number = None

        if disk is not None:
            self.disk = disk
        if bus_number is not None:
            self.bus_number = bus_number
        if unit_number is not None:
            self.unit_number = unit_number

    @property
    def disk(self):
        return self._disk
    
    @disk.setter
    def disk(self, disk):
        self._disk = disk

    @property
    def bus_number(self):
        return self._bus_number
    
    @bus_number.setter
    def bus_number(self, bus_number):
        self._bus_number = bus_number

    @property
    def unit_number(self):
        return self._unit_number
    
    @unit_number.setter
    def unit_number(self, unit_number):
        self._unit_number = unit_number


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DiskAttachOrDetachParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
