"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_type import ResourceType


class ComputePolicyComplianceType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'last_compliance_check_time': 'str',
        'policy_name': 'str',
        'non_compliance_message': 'list[str]'
    }

    attribute_map = {
        'last_compliance_check_time': 'lastComplianceCheckTime',
        'policy_name': 'policyName',
        'non_compliance_message': 'nonComplianceMessage'
    }

    def __init__(self, last_compliance_check_time=None,policy_name=None,non_compliance_message=None):
        self._last_compliance_check_time = None
        self._policy_name = None
        self._non_compliance_message = None

        if last_compliance_check_time is not None:
            self.last_compliance_check_time = last_compliance_check_time
        if policy_name is not None:
            self.policy_name = policy_name
        if non_compliance_message is not None:
            self.non_compliance_message = non_compliance_message

    @property
    def last_compliance_check_time(self):
        return self._last_compliance_check_time
    
    @last_compliance_check_time.setter
    def last_compliance_check_time(self, last_compliance_check_time):
        self._last_compliance_check_time = last_compliance_check_time

    @property
    def policy_name(self):
        return self._policy_name
    
    @policy_name.setter
    def policy_name(self, policy_name):
        self._policy_name = policy_name

    @property
    def non_compliance_message(self):
        return self._non_compliance_message
    
    @non_compliance_message.setter
    def non_compliance_message(self, non_compliance_message):
        self._non_compliance_message = non_compliance_message


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ComputePolicyComplianceType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
