"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .params_type import ParamsType


class CaptureVmParamsType(ParamsType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'source': 'ReferenceType',
        'vdc_compute_policy': 'ReferenceType'
    }

    attribute_map = {
        'source': 'source',
        'vdc_compute_policy': 'vdcComputePolicy'
    }

    def __init__(self, source=None,vdc_compute_policy=None):
        self._source = None
        self._vdc_compute_policy = None

        if source is not None:
            self.source = source
        if vdc_compute_policy is not None:
            self.vdc_compute_policy = vdc_compute_policy

    @property
    def source(self):
        return self._source
    
    @source.setter
    def source(self, source):
        self._source = source

    @property
    def vdc_compute_policy(self):
        return self._vdc_compute_policy
    
    @vdc_compute_policy.setter
    def vdc_compute_policy(self, vdc_compute_policy):
        self._vdc_compute_policy = vdc_compute_policy


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CaptureVmParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
