"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .vdc_type import VdcType


class AdminVdcType(VdcType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'resource_guaranteed_memory': 'int',
        'resource_guaranteed_cpu': 'int',
        'v_cpu_in_mhz': 'int',
        'is_thin_provision': 'bool',
        'network_pool_reference': 'ReferenceType',
        'vendor_services': 'VendorServicesType',
        'provider_vdc_reference': 'ReferenceType',
        'resource_pool_refs': 'VimObjectRefsType',
        'uses_fast_provisioning': 'bool',
        'over_commit_allowed': 'bool',
        'vm_discovery_enabled': 'bool',
        'universal_network_pool_reference': 'ReferenceType',
        'is_elastic': 'bool',
        'include_memory_overhead': 'bool'
    }

    attribute_map = {
        'resource_guaranteed_memory': 'resourceGuaranteedMemory',
        'resource_guaranteed_cpu': 'resourceGuaranteedCpu',
        'v_cpu_in_mhz': 'vCpuInMhz',
        'is_thin_provision': 'isThinProvision',
        'network_pool_reference': 'networkPoolReference',
        'vendor_services': 'vendorServices',
        'provider_vdc_reference': 'providerVdcReference',
        'resource_pool_refs': 'resourcePoolRefs',
        'uses_fast_provisioning': 'usesFastProvisioning',
        'over_commit_allowed': 'overCommitAllowed',
        'vm_discovery_enabled': 'vmDiscoveryEnabled',
        'universal_network_pool_reference': 'universalNetworkPoolReference',
        'is_elastic': 'isElastic',
        'include_memory_overhead': 'includeMemoryOverhead'
    }

    def __init__(self, resource_guaranteed_memory=None,resource_guaranteed_cpu=None,v_cpu_in_mhz=None,is_thin_provision=None,network_pool_reference=None,vendor_services=None,provider_vdc_reference=None,resource_pool_refs=None,uses_fast_provisioning=None,over_commit_allowed=None,vm_discovery_enabled=None,universal_network_pool_reference=None,is_elastic=None,include_memory_overhead=None):
        self._resource_guaranteed_memory = None
        self._resource_guaranteed_cpu = None
        self._v_cpu_in_mhz = None
        self._is_thin_provision = None
        self._network_pool_reference = None
        self._vendor_services = None
        self._provider_vdc_reference = None
        self._resource_pool_refs = None
        self._uses_fast_provisioning = None
        self._over_commit_allowed = None
        self._vm_discovery_enabled = None
        self._universal_network_pool_reference = None
        self._is_elastic = None
        self._include_memory_overhead = None

        if resource_guaranteed_memory is not None:
            self.resource_guaranteed_memory = resource_guaranteed_memory
        if resource_guaranteed_cpu is not None:
            self.resource_guaranteed_cpu = resource_guaranteed_cpu
        if v_cpu_in_mhz is not None:
            self.v_cpu_in_mhz = v_cpu_in_mhz
        if is_thin_provision is not None:
            self.is_thin_provision = is_thin_provision
        if network_pool_reference is not None:
            self.network_pool_reference = network_pool_reference
        if vendor_services is not None:
            self.vendor_services = vendor_services
        if provider_vdc_reference is not None:
            self.provider_vdc_reference = provider_vdc_reference
        if resource_pool_refs is not None:
            self.resource_pool_refs = resource_pool_refs
        if uses_fast_provisioning is not None:
            self.uses_fast_provisioning = uses_fast_provisioning
        if over_commit_allowed is not None:
            self.over_commit_allowed = over_commit_allowed
        if vm_discovery_enabled is not None:
            self.vm_discovery_enabled = vm_discovery_enabled
        if universal_network_pool_reference is not None:
            self.universal_network_pool_reference = universal_network_pool_reference
        if is_elastic is not None:
            self.is_elastic = is_elastic
        if include_memory_overhead is not None:
            self.include_memory_overhead = include_memory_overhead

    @property
    def resource_guaranteed_memory(self):
        return self._resource_guaranteed_memory
    
    @resource_guaranteed_memory.setter
    def resource_guaranteed_memory(self, resource_guaranteed_memory):
        self._resource_guaranteed_memory = resource_guaranteed_memory

    @property
    def resource_guaranteed_cpu(self):
        return self._resource_guaranteed_cpu
    
    @resource_guaranteed_cpu.setter
    def resource_guaranteed_cpu(self, resource_guaranteed_cpu):
        self._resource_guaranteed_cpu = resource_guaranteed_cpu

    @property
    def v_cpu_in_mhz(self):
        return self._v_cpu_in_mhz
    
    @v_cpu_in_mhz.setter
    def v_cpu_in_mhz(self, v_cpu_in_mhz):
        self._v_cpu_in_mhz = v_cpu_in_mhz

    @property
    def is_thin_provision(self):
        return self._is_thin_provision
    
    @is_thin_provision.setter
    def is_thin_provision(self, is_thin_provision):
        self._is_thin_provision = is_thin_provision

    @property
    def network_pool_reference(self):
        return self._network_pool_reference
    
    @network_pool_reference.setter
    def network_pool_reference(self, network_pool_reference):
        self._network_pool_reference = network_pool_reference

    @property
    def vendor_services(self):
        return self._vendor_services
    
    @vendor_services.setter
    def vendor_services(self, vendor_services):
        self._vendor_services = vendor_services

    @property
    def provider_vdc_reference(self):
        return self._provider_vdc_reference
    
    @provider_vdc_reference.setter
    def provider_vdc_reference(self, provider_vdc_reference):
        self._provider_vdc_reference = provider_vdc_reference

    @property
    def resource_pool_refs(self):
        return self._resource_pool_refs
    
    @resource_pool_refs.setter
    def resource_pool_refs(self, resource_pool_refs):
        self._resource_pool_refs = resource_pool_refs

    @property
    def uses_fast_provisioning(self):
        return self._uses_fast_provisioning
    
    @uses_fast_provisioning.setter
    def uses_fast_provisioning(self, uses_fast_provisioning):
        self._uses_fast_provisioning = uses_fast_provisioning

    @property
    def over_commit_allowed(self):
        return self._over_commit_allowed
    
    @over_commit_allowed.setter
    def over_commit_allowed(self, over_commit_allowed):
        self._over_commit_allowed = over_commit_allowed

    @property
    def vm_discovery_enabled(self):
        return self._vm_discovery_enabled
    
    @vm_discovery_enabled.setter
    def vm_discovery_enabled(self, vm_discovery_enabled):
        self._vm_discovery_enabled = vm_discovery_enabled

    @property
    def universal_network_pool_reference(self):
        return self._universal_network_pool_reference
    
    @universal_network_pool_reference.setter
    def universal_network_pool_reference(self, universal_network_pool_reference):
        self._universal_network_pool_reference = universal_network_pool_reference

    @property
    def is_elastic(self):
        return self._is_elastic
    
    @is_elastic.setter
    def is_elastic(self, is_elastic):
        self._is_elastic = is_elastic

    @property
    def include_memory_overhead(self):
        return self._include_memory_overhead
    
    @include_memory_overhead.setter
    def include_memory_overhead(self, include_memory_overhead):
        self._include_memory_overhead = include_memory_overhead


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AdminVdcType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
