"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re


class MediaTypeMappingType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'media_type': 'str',
        'complex_type_name': 'str',
        'schema_location': 'str',
        'any': 'list[object]',
        'other_attributes': 'object'
    }

    attribute_map = {
        'media_type': 'mediaType',
        'complex_type_name': 'complexTypeName',
        'schema_location': 'schemaLocation',
        'any': 'any',
        'other_attributes': 'otherAttributes'
    }

    def __init__(self, media_type=None,complex_type_name=None,schema_location=None,any=None,other_attributes=None):
        self._media_type = None
        self._complex_type_name = None
        self._schema_location = None
        self._any = None
        self._other_attributes = None

        if media_type is not None:
            self.media_type = media_type
        if complex_type_name is not None:
            self.complex_type_name = complex_type_name
        if schema_location is not None:
            self.schema_location = schema_location
        if any is not None:
            self.any = any
        if other_attributes is not None:
            self.other_attributes = other_attributes

    @property
    def media_type(self):
        return self._media_type
    
    @media_type.setter
    def media_type(self, media_type):
        self._media_type = media_type

    @property
    def complex_type_name(self):
        return self._complex_type_name
    
    @complex_type_name.setter
    def complex_type_name(self, complex_type_name):
        self._complex_type_name = complex_type_name

    @property
    def schema_location(self):
        return self._schema_location
    
    @schema_location.setter
    def schema_location(self, schema_location):
        self._schema_location = schema_location

    @property
    def any(self):
        return self._any
    
    @any.setter
    def any(self, any):
        self._any = any

    @property
    def other_attributes(self):
        return self._other_attributes
    
    @other_attributes.setter
    def other_attributes(self, other_attributes):
        self._other_attributes = other_attributes


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MediaTypeMappingType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
