"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re


class CimDateTime(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cim_date_time': 'str',
        'interval': 'str',
        'date': 'str',
        'time': 'str',
        'datetime': 'str',
        'other_attributes': 'object'
    }

    attribute_map = {
        'cim_date_time': 'cimDateTime',
        'interval': 'interval',
        'date': 'date',
        'time': 'time',
        'datetime': 'datetime',
        'other_attributes': 'otherAttributes'
    }

    def __init__(self, cim_date_time=None,interval=None,date=None,time=None,datetime=None,other_attributes=None):
        self._cim_date_time = None
        self._interval = None
        self._date = None
        self._time = None
        self._datetime = None
        self._other_attributes = None

        if cim_date_time is not None:
            self.cim_date_time = cim_date_time
        if interval is not None:
            self.interval = interval
        if date is not None:
            self.date = date
        if time is not None:
            self.time = time
        if datetime is not None:
            self.datetime = datetime
        if other_attributes is not None:
            self.other_attributes = other_attributes

    @property
    def cim_date_time(self):
        return self._cim_date_time
    
    @cim_date_time.setter
    def cim_date_time(self, cim_date_time):
        self._cim_date_time = cim_date_time

    @property
    def interval(self):
        return self._interval
    
    @interval.setter
    def interval(self, interval):
        self._interval = interval

    @property
    def date(self):
        return self._date
    
    @date.setter
    def date(self, date):
        self._date = date

    @property
    def time(self):
        return self._time
    
    @time.setter
    def time(self, time):
        self._time = time

    @property
    def datetime(self):
        return self._datetime
    
    @datetime.setter
    def datetime(self, datetime):
        self._datetime = datetime

    @property
    def other_attributes(self):
        return self._other_attributes
    
    @other_attributes.setter
    def other_attributes(self, other_attributes):
        self._other_attributes = other_attributes


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CimDateTime):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
