"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnComputer = exports.toJson_CfnComputerProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnComputerProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnComputerProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Container': obj.container,
        'Description': obj.description,
        'Name': obj.name,
        'Pre2kname': obj.pre2Kname,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnComputerProps = toJson_CfnComputerProps;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `TF::AD::Computer`
 *
 * @cloudformationResource TF::AD::Computer
 * @stability external
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
class CfnComputer extends cdk.CfnResource {
    /**
     * Create a new `TF::AD::Computer`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnComputer.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnComputerProps(props) });
        this.props = props;
        this.attrTfcfnid = cdk.Token.asString(this.getAtt('tfcfnid'));
        this.attrDn = cdk.Token.asString(this.getAtt('Dn'));
        this.attrGuid = cdk.Token.asString(this.getAtt('Guid'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrSid = cdk.Token.asString(this.getAtt('Sid'));
    }
}
exports.CfnComputer = CfnComputer;
_a = JSII_RTTI_SYMBOL_1;
CfnComputer[_a] = { fqn: "@cdk-cloudformation/tf-ad-computer.CfnComputer", version: "1.0.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnComputer.CFN_RESOURCE_TYPE_NAME = "TF::AD::Computer";
//# sourceMappingURL=data:application/json;base64,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