import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * CloudFormation equivalent of ad_computer
 *
 * @schema CfnComputerProps
 */
export interface CfnComputerProps {
    /**
     * @schema CfnComputerProps#Container
     */
    readonly container?: string;
    /**
     * @schema CfnComputerProps#Description
     */
    readonly description?: string;
    /**
     * @schema CfnComputerProps#Name
     */
    readonly name: string;
    /**
     * @schema CfnComputerProps#Pre2kname
     */
    readonly pre2Kname?: string;
}
/**
 * Converts an object of type 'CfnComputerProps' to JSON representation.
 */
export declare function toJson_CfnComputerProps(obj: CfnComputerProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `TF::AD::Computer`
 *
 * @cloudformationResource TF::AD::Computer
 * @stability external
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
export declare class CfnComputer extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "TF::AD::Computer";
    /**
     * Resource props.
     */
    readonly props: CfnComputerProps;
    /**
     * Attribute `TF::AD::Computer.tfcfnid`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrTfcfnid: string;
    /**
     * Attribute `TF::AD::Computer.Dn`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrDn: string;
    /**
     * Attribute `TF::AD::Computer.Guid`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrGuid: string;
    /**
     * Attribute `TF::AD::Computer.Id`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrId: string;
    /**
     * Attribute `TF::AD::Computer.Sid`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrSid: string;
    /**
     * Create a new `TF::AD::Computer`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnComputerProps);
}
