from Crypto.Cipher import AES
import base64
import base58
from binascii import hexlify, unhexlify
import json
import requests

import random
from decimal import *
import sys

# import pkg_resources

from ecdsa import SigningKey, SECP256k1, util
from hashlib import sha256
# from . import pbkdf2

import six

VERSION=2
# pkg_resources.get_distribution("crypto-wallet").version

class CryptoWalletInvalidResponseError(Exception):
    """Thrown when we receive an unexpected/unparseable response from Block.io"""

class CryptoWalletUnknownError(Exception):
    """Thrown when response status codes are outside of 200-299, 419-420, 500-599."""

class CryptoWalletAPIThrottleError(Exception):
    """Thrown when API call gets throttled at Block.io."""

class CryptoWalletAPIInternalError(Exception):
    """Thrown on 500-599 errors."""

class CryptoWalletAPIError(Exception):
    """Thrown when block.io API call fails."""


class CryptoWallet(object):

    def __init__(self, api_key, version = 2):
        # initiate the object
        self.api_key = api_key
        self.pin = pin
        self.version = version
        self.clientVersion = VERSION
        self.encryption_key = None
        self.base_url = 'https://cryptowallet.osizdemos.com/api/v'+str(version)+'/API_CALL?api_key='+api_key

    def __getattr__(self, attr, *args, **kwargs):

        def hook(*args, **kwargs):
            return self.api_call(attr, **kwargs)

        return hook

    def api_call(self, method, **kwargs):
        # the actual API call

        # http parameters
        payload = {}

        if self.api_key is not None:
            payload["api_key"] = self.api_key

        payload.update(kwargs)

        if kwargs is not None:
            import urllib
            import urlparse

            base_url = self.base_url.replace('API_CALL',method)
            url_parts = list(urlparse.urlparse(base_url))
            query = dict(urlparse.parse_qsl(url_parts[4]))
            query.update(kwargs)

            url_parts[4] = urllib.urlencode(query)
            url = urlparse.urlunparse(url_parts)
        else:
            url = self.base_url.replace('API_CALL',method)

        # update the parameters with the API key
        session = requests.session()
        response = session.post(url, data = payload)
        status_code = response.status_code
        # six.print_(url)
        
        try:
            response = response.json() # convert response to JSON
        except:
            response = {}

        session.close() # we're done with it, let's close it

        if not ('status' in response.keys()):
            # unexpected response
            raise CryptoWalletInvalidResponseError("Failed, invalid response received from Crypto Wallet, method %s" % method)
        elif ('status' in response.keys()) and (response['status'] == '0'):

            if 'status' in response.keys() and 'result' in response.keys():
                # call failed, and error_message was provided
                raise CryptoWalletAPIError('Failed: '+response['result'])
            else:
                # call failed, and error_message was NOT provided
                raise CryptoWalletAPIError("Failed, error_message was not provided, method %s" % method)

        elif 500 <= status_code <= 599:
            # using the status_code since a JSON response was not provided
            raise CryptoWalletAPIInternalError("API call to Crypto Wallet failed externally, method %s" % method)
        elif 419 <= status_code <= 420:
            # using the status_code since a JSON response was not provided
            raise CryptoWalletAPIThrottleError("API call got throttled by rate limits at Crypto Wallet, method %s" % method)
        elif not (200 <= status_code <= 299):
            # using the status_code since a JSON response was not provided
            raise CryptoWalletUnknownError("Unknown error occurred when querying Crypto Wallet, method %s" % method)

        return response

