/**
 * YAML utilities.
 */
export declare class Yaml {
    /**
     * Saves a set of objects as a multi-document YAML file.
     *
     * @param filePath The output path
     * @param docs The set of objects
     */
    static save(filePath: string, docs: any[]): void;
    /**
     * Stringify a document (or multiple documents) into YAML
     *
     * Undefined values become null.
     * Undefiend documents will be ignored.
     *
     * @param docs A set of objects to convert to YAML
     * @returns a YAML string. Multiple docs are separated by `---`.
     */
    static stringify(...docs: any[]): string;
}
