"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrustBoundaryType = exports.TrustBoundary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const uuid_1 = require("uuid");
class TrustBoundary extends constructs_1.Construct {
    constructor(model, id, props) {
        super(model, id);
        this.uuid = uuid_1.v4();
        this.description = props.description;
        this.type = props.type;
        this.technicalAssetsInside = new Set();
        this.trustBoundariesNested = new Set();
    }
    addTechnicalAssets(...assets) {
        assets.forEach(a => {
            this.technicalAssetsInside.add(a.uuid);
        });
    }
    addTrustBoundary(boundary) {
        this.trustBoundariesNested.add(boundary.uuid);
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.node.id]: {
                id: this.uuid,
                description: this.description,
                type: this.type,
                technical_assets_inside: Array.from(this.technicalAssetsInside),
                trust_boundaries_nested: Array.from(this.trustBoundariesNested),
            },
        };
    }
}
exports.TrustBoundary = TrustBoundary;
_a = JSII_RTTI_SYMBOL_1;
TrustBoundary[_a] = { fqn: "cdktg.TrustBoundary", version: "0.0.4" };
var TrustBoundaryType;
(function (TrustBoundaryType) {
    TrustBoundaryType["NETWORK_ON_PREM"] = "network-on-prem";
    TrustBoundaryType["NETWORK_DEDICATED_HOSTER"] = "network-dedicated-hoster";
    TrustBoundaryType["NETWORK_VIRTUAL_LAN"] = "network-virtual-lan";
    TrustBoundaryType["NETWORK_CLOUD_PROVIDER"] = "network-cloud-provider";
    TrustBoundaryType["NETWORK_CLOUD_SECURITY_GROUP"] = "network-cloud-security-group";
    TrustBoundaryType["NETWORK_POLICY_NAMESPACE_ISOLATION"] = "network-policy-namespace-isolation";
    TrustBoundaryType["EXECUTION_ENVIRONMENT"] = "execution-environment";
})(TrustBoundaryType = exports.TrustBoundaryType || (exports.TrustBoundaryType = {}));
//# sourceMappingURL=data:application/json;base64,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