"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataFormat = exports.Encryption = exports.Machine = exports.Technology = exports.Size = exports.AssetType = exports.TechnicalAsset = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const asset_1 = require("./asset");
const communication_1 = require("./communication");
const scope_1 = require("./scope");
class TechnicalAsset extends asset_1.Asset {
    constructor(model, id, props) {
        super(model, id, props);
        this.assetType = props.assetType;
        this.humanUse = props.humanUse;
        this.internet = props.internet;
        this.scope = props.scope ?? new scope_1.InScope();
        this.size = props.size;
        this.technology = props.technology;
        this.machine = props.machine;
        this.encryption = props.encryption;
        this.owner = props.owner;
        this.multiTenant = props.multiTenant;
        this.redundant = props.redundant;
        this.dataAssetsProcessed = new Set();
        this.dataAssetsStored = new Set();
        this.communications = new Array();
        if (props.trustBoundary) {
            props.trustBoundary.addTechnicalAssets(this);
        }
    }
    processed(...assets) {
        assets.forEach(a => {
            this.dataAssetsProcessed.add(a.uuid);
        });
    }
    stored(...assets) {
        assets.forEach(a => {
            this.dataAssetsStored.add(a.uuid);
        });
    }
    communicatedWith(id, target, options) {
        const communication = new communication_1.Communication(id, {
            target: target,
            ...options,
        });
        this.communications.push(communication);
        return communication;
    }
    /**
     * @internal
     */
    _toThreagile() {
        const threagile = {
            [this.node.id]: {
                id: this.uuid,
                description: this.description,
                type: this.assetType,
                usage: this.usage,
                used_as_client_by_human: this.humanUse,
                ...this.scope?._toThreagile(),
                size: this.size,
                technology: this.technology,
                internet: this.internet,
                machine: this.machine,
                encryption: this.encryption,
                owner: this.owner,
                confidentiality: 'public',
                integrity: 'archive',
                availability: 'archive',
                // ...this.ciaTriad._toThreagile(),
                multitenant: this.multiTenant,
                redundant: this.redundant,
                data_assets_processed: Array.from(this.dataAssetsProcessed),
                data_assets_stored: Array.from(this.dataAssetsStored),
            },
        };
        if (this.communications.length > 0) {
            threagile[this.node.id].communication_links = {};
            this.communications.forEach(c => {
                threagile[this.node.id].communication_links = {
                    ...threagile[this.node.id].communication_links,
                    ...c._toThreagile(),
                };
            });
        }
        return threagile;
    }
}
exports.TechnicalAsset = TechnicalAsset;
_a = JSII_RTTI_SYMBOL_1;
TechnicalAsset[_a] = { fqn: "cdktg.TechnicalAsset", version: "0.0.4" };
var AssetType;
(function (AssetType) {
    AssetType["EXTERNAL_ENTITY"] = "external-entity";
    AssetType["PROCESS"] = "process";
    AssetType["DATASTORE"] = "datastore";
})(AssetType = exports.AssetType || (exports.AssetType = {}));
var Size;
(function (Size) {
    Size["SYSTEM"] = "system";
    Size["SERVICE"] = "service";
    Size["APPLICATION"] = "application";
    Size["COMPONENT"] = "component";
})(Size = exports.Size || (exports.Size = {}));
var Technology;
(function (Technology) {
    Technology["UNKNOWN"] = "unknown-technology";
    Technology["CLIENT_SYSTEM"] = "client-system";
    Technology["BROWSER"] = "browser";
    Technology["DESKTOP"] = "desktop";
    Technology["MOBILE_APP"] = "mobile-app";
    Technology["DEVOPS_CLIENT"] = "devops-client";
    Technology["WEB_SERVER"] = "web-server";
    Technology["WEB_APPLICATION"] = "web-application";
    Technology["APPLICATION_SERVER"] = "application-server";
    Technology["DATABASE"] = "database";
    Technology["FILE_SERVER"] = "file-server";
    Technology["LOCAL_FILE_SERVER"] = "local-file-system";
    Technology["ERP"] = "erp";
    Technology["CMS"] = "cms";
    Technology["WEB_SERVICE_REST"] = "web-service-rest";
    Technology["WEB_SERVICE_SOAP"] = "web-service-soap";
    Technology["EJB"] = "ejb";
    Technology["SEARCH_INDEX"] = "search-index";
    Technology["SEARCH_ENGINE"] = "search-engine";
    Technology["SERVICE_REGISTRY"] = "service-registry";
    Technology["REVERSE_PROXY"] = "reverse-proxy";
    Technology["LOAD_BALANCER"] = "load-balancer";
    Technology["BUILD_PIPELINE"] = "build-pipeline";
    Technology["SOURCECODE_REPOSITORY"] = "sourcecode-repository";
    Technology["ARTIFACT_REGISTRY"] = "artifact-registry";
    Technology["CODE_INSPECTION_PLATFORM"] = "code-inspection-platform";
    Technology["MONITORING"] = "monitoring";
    Technology["LDAP_SERVER"] = "ldap-server";
    Technology["CONTAINER_PLATFORM"] = "container-platform";
    Technology["BATCH_PROCESSING"] = "batch-processing";
    Technology["EVENT_LISTENER"] = "event-listener";
    Technology["IDENTITIY_PROVIDER"] = "identity-provider";
    Technology["IDENTITY_STORE_LDAP"] = "identity-store-ldap";
    Technology["IDENTITY_STORE_DATABASE"] = "identity-store-database";
    Technology["TOOL"] = "tool";
    Technology["CLI"] = "cli";
    Technology["TASK"] = "task";
    Technology["FUNCTION"] = "function";
    Technology["GATEWAY"] = "gateway";
    Technology["IOT_DEVICE"] = "iot-device";
    Technology["MESSAGE_QUEUE"] = "message-queue";
    Technology["STREAM_PROCESSING"] = "stream-processing";
    Technology["SERVICE_MESH"] = "service-mesh";
    Technology["DATA_LAKE"] = "data-lake";
    Technology["REPORT_ENGINE"] = "report-engine";
    Technology["AI"] = "ai";
    Technology["MAIL_SERVER"] = "mail-server";
    Technology["VAULT"] = "vault";
    Technology["HASM"] = "hsm";
    Technology["WAF"] = "waf";
    Technology["IDS"] = "ids";
    Technology["IPS"] = "ips";
    Technology["SCHEDULER"] = "scheduler";
    Technology["MAINFRAME"] = "mainframe";
    Technology["BLOCK_STORAGE"] = "block-storage";
    Technology["LIBRARY"] = "library";
})(Technology = exports.Technology || (exports.Technology = {}));
var Machine;
(function (Machine) {
    Machine["PHYSICAL"] = "physical";
    Machine["VIRTUAL"] = "virtual";
    Machine["CONTAINER"] = "container";
    Machine["SERVERLESS"] = "serverless";
})(Machine = exports.Machine || (exports.Machine = {}));
var Encryption;
(function (Encryption) {
    Encryption["NONE"] = "none";
    Encryption["TRANSPARENT"] = "transparent";
    Encryption["SYMMETRIC_SHARED_KEY"] = "data-with-symmetric-shared-key";
    Encryption["ASYMMETRIC_SHARED_KEY"] = "data-with-asymmetric-shared-key";
    Encryption["ENDUSER_INDIVIDUAL_KEY"] = "data-with-enduser-individual-key";
})(Encryption = exports.Encryption || (exports.Encryption = {}));
var DataFormat;
(function (DataFormat) {
    DataFormat["JSON"] = "json";
    DataFormat["XML"] = "xml";
    DataFormat["SERIALIZATION"] = "serialization";
    DataFormat["FILE"] = "file";
    DataFormat["CSV"] = "csv";
})(DataFormat = exports.DataFormat || (exports.DataFormat = {}));
//# sourceMappingURL=data:application/json;base64,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