export interface OutOfScopeProps {
    readonly outOfScope: boolean;
    readonly justification?: string;
}
export declare abstract class Scope {
    readonly justification?: string | undefined;
    constructor(justification?: string | undefined);
    protected abstract get isInScope(): boolean;
    /**
     * @internal
     */
    _toThreagile(): {
        out_of_scope: boolean;
        justification_out_of_scope: string | undefined;
    };
}
export declare class OutOfScope extends Scope {
    constructor(justification?: string);
    protected get isInScope(): boolean;
}
export declare class InScope extends Scope {
    constructor(justification?: string);
    protected get isInScope(): boolean;
}
