"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Authorization = exports.Authentication = exports.Protocol = exports.Communication = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class Communication {
    constructor(id, props) {
        this.id = id;
        this.target = props.target;
        this.description = props.description;
        this.protocol = props.protocol;
        this.authentication = props.authentication;
        this.authorization = props.authorization;
        this.vpn = props.vpn;
        this.ipFiltered = props.ipFiltered;
        this.readonly = props.readonly;
        this.usage = props.usage;
        this.dataAssetsSent = new Set();
        this.dataAssetsReceived = new Set();
    }
    sent(...assets) {
        assets.forEach(a => {
            this.dataAssetsSent.add(a.uuid);
        });
    }
    received(...assets) {
        assets.forEach(a => {
            this.dataAssetsReceived.add(a.uuid);
        });
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.id]: {
                target: this.target.uuid,
                description: this.description,
                protocol: this.protocol,
                authentication: this.authentication,
                authorization: this.authorization,
                vpn: this.vpn,
                ipFiltered: this.ipFiltered,
                readonly: this.readonly,
                usage: this.usage,
                data_assets_sent: this.dataAssetsSent,
                data_assets_received: this.dataAssetsReceived,
            },
        };
    }
}
exports.Communication = Communication;
_a = JSII_RTTI_SYMBOL_1;
Communication[_a] = { fqn: "cdktg.Communication", version: "0.0.4" };
var Protocol;
(function (Protocol) {
    Protocol["UNKNOEN"] = "unknown-protocol";
    Protocol["HTTP"] = "http";
    Protocol["HTTPS"] = "https";
    Protocol["WS"] = "ws";
    Protocol["WSS"] = "wss";
    Protocol["REVERSE_PROXY_WEB_PROTOCOL"] = "reverse-proxy-web-protocol";
    Protocol["REVERSE_PROXY_WEB_PROTOCOL_ENCRYPTED"] = "reverse-proxy-web-protocol-encrypted";
    Protocol["MQTT"] = "mqtt";
    Protocol["JDBC"] = "jdbc";
    Protocol["JDBC_ENCRYPTED"] = "jdbc-encrypted";
    Protocol["ODBC"] = "odbc";
    Protocol["ODBC_ENCRYPTED"] = "odbc-encrypted";
    Protocol["SQL_ACCESS_PROTOCOL"] = "sql-access-protocol";
    Protocol["SQL_ACCESS_PROTOCOL_ENCRYPTED"] = "sql-access-protocol-encrypted";
    Protocol["NOSQL_ACCESS_PROTOCOL"] = "nosql-access-protocol";
    Protocol["NOSQL_ACCESS_PROTOCOL_ENCRYPTED"] = "nosql-access-protocol-encrypted";
    Protocol["BINARY"] = "binary";
    Protocol["BINARY_ENCRYPTED"] = "binary-encrypted";
    Protocol["TEXT"] = "text";
    Protocol["TEXT_ENCRYPTED"] = "text-encrypted";
    Protocol["SSH"] = "ssh";
    Protocol["SSH_TUNNEL"] = "ssh-tunnel";
    Protocol["SMTP"] = "smtp";
    Protocol["SMTP_ENCRYPTED"] = "smtp-encrypted";
    Protocol["POP3"] = "pop3";
    Protocol["POP3_ENCRYPTED"] = "pop3-encrypted";
    Protocol["IMAP"] = "imap";
    Protocol["IMAP_ENCRYPTED"] = "imap-encrypted";
    Protocol["FTP"] = "ftp";
    Protocol["FTPS"] = "ftps";
    Protocol["SFTP"] = "sftp";
    Protocol["SCP"] = "scp";
    Protocol["LDAP"] = "ldap";
    Protocol["LDAPS"] = "ldaps";
    Protocol["JMS"] = "jms";
    Protocol["NFS"] = "nfs";
    Protocol["SMB"] = "smb";
    Protocol["SMB_ENCRYPTED"] = "smb-encrypted";
    Protocol["LOCAL_FILE_ACCESS"] = "local-file-access";
    Protocol["NRPE"] = "nrpe";
    Protocol["XMPP"] = "xmpp";
    Protocol["IIOP"] = "iiop";
    Protocol["IIOP_ENCRYPTED"] = "iiop-encrypted";
    Protocol["JRMP"] = "jrmp";
    Protocol["JRMP_ENCRYPTED"] = "jrmp-encrypted";
    Protocol["IN_PROCESS_LIBRARY_CALL"] = "in-process-library-call";
    Protocol["CONTAINER_SPAWNING"] = "container-spawning";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
var Authentication;
(function (Authentication) {
    Authentication["NONE"] = "none";
    Authentication["CREDENTIALS"] = "credentials";
    Authentication["SESSION_ID"] = "session-id";
    Authentication["TOKEN"] = "token";
    Authentication["CLIENT_CERTIFICATE"] = "client-certificate";
    Authentication["TWO_FACTOR"] = "two-factor";
    Authentication["EXTERNALIZED"] = "externalized";
})(Authentication = exports.Authentication || (exports.Authentication = {}));
var Authorization;
(function (Authorization) {
    Authorization["NONE"] = "none";
    Authorization["TECHNICAL_USER"] = "technical-user";
    Authorization["ENDUSER_IDENTITY_PROPAGATION"] = "enduser-identity-propagation";
})(Authorization = exports.Authorization || (exports.Authorization = {}));
//# sourceMappingURL=data:application/json;base64,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