import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceExternalWikiConfig extends cdktf.TerraformMetaArguments {
    /**
    * The URL of the external wiki.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_external_wiki#external_wiki_url ServiceExternalWiki#external_wiki_url}
    */
    readonly externalWikiUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_external_wiki#id ServiceExternalWiki#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ID of the project you want to activate integration on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_external_wiki#project ServiceExternalWiki#project}
    */
    readonly project: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/service_external_wiki gitlab_service_external_wiki}
*/
export declare class ServiceExternalWiki extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_service_external_wiki";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/service_external_wiki gitlab_service_external_wiki} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceExternalWikiConfig
    */
    constructor(scope: Construct, id: string, config: ServiceExternalWikiConfig);
    get active(): cdktf.IResolvable;
    get createdAt(): string;
    private _externalWikiUrl?;
    get externalWikiUrl(): string;
    set externalWikiUrl(value: string);
    get externalWikiUrlInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    get slug(): string;
    get title(): string;
    get updatedAt(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
