import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The base domain of the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_cluster#domain ProjectCluster#domain}
    */
    readonly domain?: string;
    /**
    * Determines if cluster is active or not. Defaults to `true`. This attribute cannot be read.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_cluster#enabled ProjectCluster#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The associated environment to the cluster. Defaults to `*`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_cluster#environment_scope ProjectCluster#environment_scope}
    */
    readonly environmentScope?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_cluster#id ProjectCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The URL to access the Kubernetes API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_cluster#kubernetes_api_url ProjectCluster#kubernetes_api_url}
    */
    readonly kubernetesApiUrl: string;
    /**
    * The cluster authorization type. Valid values are `rbac`, `abac`, `unknown_authorization`. Defaults to `rbac`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_cluster#kubernetes_authorization_type ProjectCluster#kubernetes_authorization_type}
    */
    readonly kubernetesAuthorizationType?: string;
    /**
    * TLS certificate (needed if API is using a self-signed TLS certificate).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_cluster#kubernetes_ca_cert ProjectCluster#kubernetes_ca_cert}
    */
    readonly kubernetesCaCert?: string;
    /**
    * The unique namespace related to the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_cluster#kubernetes_namespace ProjectCluster#kubernetes_namespace}
    */
    readonly kubernetesNamespace?: string;
    /**
    * The token to authenticate against Kubernetes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_cluster#kubernetes_token ProjectCluster#kubernetes_token}
    */
    readonly kubernetesToken: string;
    /**
    * Determines if cluster is managed by gitlab or not. Defaults to `true`. This attribute cannot be read.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_cluster#managed ProjectCluster#managed}
    */
    readonly managed?: boolean | cdktf.IResolvable;
    /**
    * The ID of the management project for the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_cluster#management_project_id ProjectCluster#management_project_id}
    */
    readonly managementProjectId?: string;
    /**
    * The name of cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_cluster#name ProjectCluster#name}
    */
    readonly name: string;
    /**
    * The id of the project to add the cluster to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_cluster#project ProjectCluster#project}
    */
    readonly project: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project_cluster gitlab_project_cluster}
*/
export declare class ProjectCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_project_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project_cluster gitlab_project_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectClusterConfig
    */
    constructor(scope: Construct, id: string, config: ProjectClusterConfig);
    get clusterType(): string;
    get createdAt(): string;
    private _domain?;
    get domain(): string;
    set domain(value: string);
    resetDomain(): void;
    get domainInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _environmentScope?;
    get environmentScope(): string;
    set environmentScope(value: string);
    resetEnvironmentScope(): void;
    get environmentScopeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kubernetesApiUrl?;
    get kubernetesApiUrl(): string;
    set kubernetesApiUrl(value: string);
    get kubernetesApiUrlInput(): string | undefined;
    private _kubernetesAuthorizationType?;
    get kubernetesAuthorizationType(): string;
    set kubernetesAuthorizationType(value: string);
    resetKubernetesAuthorizationType(): void;
    get kubernetesAuthorizationTypeInput(): string | undefined;
    private _kubernetesCaCert?;
    get kubernetesCaCert(): string;
    set kubernetesCaCert(value: string);
    resetKubernetesCaCert(): void;
    get kubernetesCaCertInput(): string | undefined;
    private _kubernetesNamespace?;
    get kubernetesNamespace(): string;
    set kubernetesNamespace(value: string);
    resetKubernetesNamespace(): void;
    get kubernetesNamespaceInput(): string | undefined;
    private _kubernetesToken?;
    get kubernetesToken(): string;
    set kubernetesToken(value: string);
    get kubernetesTokenInput(): string | undefined;
    private _managed?;
    get managed(): boolean | cdktf.IResolvable;
    set managed(value: boolean | cdktf.IResolvable);
    resetManaged(): void;
    get managedInput(): boolean | cdktf.IResolvable | undefined;
    private _managementProjectId?;
    get managementProjectId(): string;
    set managementProjectId(value: string);
    resetManagementProjectId(): void;
    get managementProjectIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get platformType(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    get providerType(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
