import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabRepositoryTreeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/repository_tree#id DataGitlabRepositoryTree#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The path inside repository. Used to get content of subdirectories.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/repository_tree#path DataGitlabRepositoryTree#path}
    */
    readonly path?: string;
    /**
    * The ID or full path of the project owned by the authenticated user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/repository_tree#project DataGitlabRepositoryTree#project}
    */
    readonly project: string;
    /**
    * Boolean value used to get a recursive tree (false by default).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/repository_tree#recursive DataGitlabRepositoryTree#recursive}
    */
    readonly recursive?: boolean | cdktf.IResolvable;
    /**
    * The name of a repository branch or tag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/repository_tree#ref DataGitlabRepositoryTree#ref}
    */
    readonly ref: string;
}
export interface DataGitlabRepositoryTreeTree {
}
export declare function dataGitlabRepositoryTreeTreeToTerraform(struct?: DataGitlabRepositoryTreeTree): any;
export declare class DataGitlabRepositoryTreeTreeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabRepositoryTreeTree | undefined;
    set internalValue(value: DataGitlabRepositoryTreeTree | undefined);
    get id(): string;
    get mode(): string;
    get name(): string;
    get path(): string;
    get type(): string;
}
export declare class DataGitlabRepositoryTreeTreeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabRepositoryTreeTreeOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/repository_tree gitlab_repository_tree}
*/
export declare class DataGitlabRepositoryTree extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_repository_tree";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/repository_tree gitlab_repository_tree} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabRepositoryTreeConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabRepositoryTreeConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _recursive?;
    get recursive(): boolean | cdktf.IResolvable;
    set recursive(value: boolean | cdktf.IResolvable);
    resetRecursive(): void;
    get recursiveInput(): boolean | cdktf.IResolvable | undefined;
    private _ref?;
    get ref(): string;
    set ref(value: string);
    get refInput(): string | undefined;
    private _tree;
    get tree(): DataGitlabRepositoryTreeTreeList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
