#define __NR_read                                0
#define __NR_write                               1
#define __NR_open                                2
#define __NR_close                               3
#define __NR_stat                                4
#define __NR_fstat                               5
#define __NR_lstat                               6
#define __NR_poll                                7

#define __NR_lseek                               8
#define __NR_mmap                                9
#define __NR_mprotect                           10
#define __NR_munmap                             11
#define __NR_brk                                12
#define __NR_rt_sigaction                       13
#define __NR_rt_sigprocmask                     14
#define __NR_rt_sigreturn                       15

#define __NR_ioctl                              16
#define __NR_pread                              17
#define __NR_pwrite                             18
#define __NR_readv                              19
#define __NR_writev                             20
#define __NR_access                             21
#define __NR_pipe                               22
#define __NR_select                             23

#define __NR_sched_yield                        24
#define __NR_mremap                             25
#define __NR_msync                              26
#define __NR_mincore                            27
#define __NR_madvise                            28
#define __NR_shmget                             29
#define __NR_shmat                              30
#define __NR_shmctl                             31

#define __NR_dup                                32
#define __NR_dup2                               33
#define __NR_pause                              34
#define __NR_nanosleep                          35
#define __NR_getitimer                          36
#define __NR_alarm                              37
#define __NR_setitimer                          38
#define __NR_getpid                             39

#define __NR_sendfile                           40
#define __NR_socket                             41
#define __NR_connect                            42
#define __NR_accept                             43
#define __NR_sendto                             44
#define __NR_recvfrom                           45
#define __NR_sendmsg                            46
#define __NR_recvmsg                            47

#define __NR_shutdown                           48
#define __NR_bind                               49
#define __NR_listen                             50
#define __NR_getsockname                        51
#define __NR_getpeername                        52
#define __NR_socketpair                         53
#define __NR_setsockopt                         54
#define __NR_getsockopt                         55

#define __NR_clone                              56
#define __NR_fork                               57
#define __NR_vfork                              58
#define __NR_execve                             59
#define __NR_exit                               60
#define __NR_wait4                              61
#define __NR_kill                               62
#define __NR_uname                              63

#define __NR_semget                             64
#define __NR_semop                              65
#define __NR_semctl                             66
#define __NR_shmdt                              67
#define __NR_msgget                             68
#define __NR_msgsnd                             69
#define __NR_msgrcv                             70
#define __NR_msgctl                             71

#define __NR_fcntl                              72
#define __NR_flock                              73
#define __NR_fsync                              74
#define __NR_fdatasync                          75
#define __NR_truncate                           76
#define __NR_ftruncate                          77
#define __NR_getdents                           78
#define __NR_getcwd                             79

#define __NR_chdir                              80
#define __NR_fchdir                             81
#define __NR_rename                             82
#define __NR_mkdir                              83
#define __NR_rmdir                              84
#define __NR_creat                              85
#define __NR_link                               86
#define __NR_unlink                             87

#define __NR_symlink                            88
#define __NR_readlink                           89
#define __NR_chmod                              90
#define __NR_fchmod                             91
#define __NR_chown                              92
#define __NR_fchown                             93
#define __NR_lchown                             94
#define __NR_umask                              95

#define __NR_gettimeofday                       96
#define __NR_getrlimit                          97
#define __NR_getrusage                          98
#define __NR_sysinfo                            99
#define __NR_times                             100
#define __NR_ptrace                            101
#define __NR_getuid                            102
#define __NR_syslog                            103

/* at the very end the stuff that never runs during the benchmarks */
#define __NR_getgid                            104
#define __NR_setuid                            105
#define __NR_setgid                            106
#define __NR_geteuid                           107
#define __NR_getegid                           108
#define __NR_setpgid                           109
#define __NR_getppid                           110
#define __NR_getpgrp                           111

#define __NR_setsid                            112
#define __NR_setreuid                          113
#define __NR_setregid                          114
#define __NR_getgroups                         115
#define __NR_setgroups                         116
#define __NR_setresuid                         117
#define __NR_getresuid                         118
#define __NR_setresgid                         119

#define __NR_getresgid                         120
#define __NR_getpgid                           121
#define __NR_setfsuid                          122
#define __NR_setfsgid                          123
#define __NR_getsid                            124
#define __NR_capget                            125
#define __NR_capset                            126

#define __NR_rt_sigpending                     127
#define __NR_rt_sigtimedwait                   128
#define __NR_rt_sigqueueinfo                   129
#define __NR_rt_sigsuspend                     130
#define __NR_sigaltstack                       131
#define __NR_utime                             132
#define __NR_mknod                             133

#define __NR_uselib                            134
#define __NR_personality                       135

#define __NR_ustat                             136
#define __NR_statfs                            137
#define __NR_fstatfs                           138
#define __NR_sysfs                             139

#define __NR_getpriority                       140
#define __NR_setpriority                       141
#define __NR_sched_setparam                    142
#define __NR_sched_getparam                    143
#define __NR_sched_setscheduler                144
#define __NR_sched_getscheduler                145
#define __NR_sched_get_priority_max            146
#define __NR_sched_get_priority_min            147
#define __NR_sched_rr_get_interval             148

#define __NR_mlock                             149
#define __NR_munlock                           150
#define __NR_mlockall                          151
#define __NR_munlockall                        152

#define __NR_vhangup                           153

#define __NR_modify_ldt                        154

#define __NR_pivot_root                        155

#define __NR__sysctl                           156

#define __NR_prctl                             157
#define __NR_arch_prctl                        158

#define __NR_adjtimex                          159

#define __NR_setrlimit                         160

#define __NR_chroot                            161

#define __NR_sync                              162

#define __NR_acct                              163

#define __NR_settimeofday                      164

#define __NR_mount                             165
#define __NR_umount2                           166

#define __NR_swapon                            167
#define __NR_swapoff                           168

#define __NR_reboot                            169

#define __NR_sethostname                       170
#define __NR_setdomainname                     171

#define __NR_iopl                              172
#define __NR_ioperm                            173

#define __NR_create_module                     174
#define __NR_init_module                       175
#define __NR_delete_module                     176
#define __NR_get_kernel_syms                   177
#define __NR_query_module                      178

#define __NR_quotactl                          179

#define __NR_nfsservctl                        180

#define __NR_getpmsg                           181	/* reserved for LiS/STREAMS */
#define __NR_putpmsg                           182	/* reserved for LiS/STREAMS */

#define __NR_afs_syscall                       183	/* reserved for AFS */

#define __NR_tuxcall      		184 /* reserved for tux */

#define __NR_security			185

#define __NR_gettid		186

#define __NR_readahead		187
#define __NR_setxattr		188
#define __NR_lsetxattr		189
#define __NR_fsetxattr		190
#define __NR_getxattr		191
#define __NR_lgetxattr		192
#define __NR_fgetxattr		193
#define __NR_listxattr		194
#define __NR_llistxattr		195
#define __NR_flistxattr		196
#define __NR_removexattr	197
#define __NR_lremovexattr	198
#define __NR_fremovexattr	199
#define __NR_tkill	200
#define __NR_time      201
#define __NR_futex     202
#define __NR_sched_setaffinity    203
#define __NR_sched_getaffinity     204
#define __NR_set_thread_area	205
#define __NR_io_setup	206
#define __NR_io_destroy	207
#define __NR_io_getevents	208
#define __NR_io_submit	209
#define __NR_io_cancel	210
#define __NR_get_thread_area	211
#define __NR_lookup_dcookie	212
#define __NR_epoll_create	213
#define __NR_epoll_ctl_old	214
#define __NR_epoll_wait_old	215
#define __NR_remap_file_pages	216
#define __NR_getdents64	217
#define __NR_set_tid_address	218
#define __NR_restart_syscall	219
#define __NR_semtimedop		220
#define __NR_fadvise64		221
#define __NR_timer_create		222
#define __NR_timer_settime		223
#define __NR_timer_gettime		224
#define __NR_timer_getoverrun		225
#define __NR_timer_delete	226
#define __NR_clock_settime	227
#define __NR_clock_gettime	228
#define __NR_clock_getres	229
#define __NR_clock_nanosleep	230
#define __NR_exit_group		231
#define __NR_epoll_wait		232
#define __NR_epoll_ctl		233
#define __NR_tgkill		234
#define __NR_utimes		235
#define __NR_vserver		236
#define __NR_vserver		236
#define __NR_mbind 		237
#define __NR_set_mempolicy 	238
#define __NR_get_mempolicy 	239
#define __NR_mq_open 		240
#define __NR_mq_unlink 		241
#define __NR_mq_timedsend 	242
#define __NR_mq_timedreceive	243
#define __NR_mq_notify 		244
#define __NR_mq_getsetattr 	245
#define __NR_kexec_load 	246
#define __NR_waitid		247
#define __NR_add_key		248
#define __NR_request_key	249
#define __NR_keyctl		250
#define __NR_ioprio_set		251
#define __NR_ioprio_get		252
#define __NR_inotify_init	253
#define __NR_inotify_add_watch	254
#define __NR_inotify_rm_watch	255
#define __NR_migrate_pages	256
#define __NR_openat		257
#define __NR_mkdirat		258
#define __NR_mknodat		259
#define __NR_fchownat		260
#define __NR_futimesat		261
#define __NR_newfstatat		262
#define __NR_unlinkat		263
#define __NR_renameat		264
#define __NR_linkat		265
#define __NR_symlinkat		266
#define __NR_readlinkat		267
#define __NR_fchmodat		268
#define __NR_faccessat		269
#define __NR_pselect6		270
#define __NR_ppoll		271
#define __NR_unshare		272
#define __NR_set_robust_list	273
#define __NR_get_robust_list	274
#define __NR_splice		275
#define __NR_tee		276
#define __NR_sync_file_range	277
#define __NR_vmsplice		278
#define __NR_move_pages		279
#define __NR_utimensat		280
#define __IGNORE_getcpu		/* implemented as a vsyscall */
#define __NR_epoll_pwait	281
#define __NR_signalfd		282
#define __NR_timerfd		283
#define __NR_eventfd		284
#define __NR_fallocate		285
#define __NR_timerfd_settime	286
#define __NR_timerfd_gettime	287
#define __NR_accept4		288
#define __NR_signalfd4		289
#define __NR_eventfd2		290
#define __NR_epoll_create1	291
#define __NR_dup3		292
#define __NR_pipe2		293
#define __NR_inotify_init1	294
#define __NR_preadv		295
#define __NR_pwritev		296
#define __NR_rt_tgsigqueueinfo	297
#define __NR_perf_event_open	298
#define __NR_recvmmsg		299
#define __NR_fanotify_init	300
#define __NR_fanotify_mark	301
#define __NR_prlimit64		302

#ifdef __PIC__
#define syscall_weak(name,wsym,sym) \
.text; \
.type wsym,@function; \
.weak wsym; \
wsym: ; \
.type sym,@function; \
.global sym; \
sym: \
	mov	$__NR_##name,%al; \
	jmp	__unified_syscall@PLT

#define syscall(name,sym) \
.text; \
.type sym,@function; \
.global sym; \
sym: \
.ifge __NR_##name-256 ; \
	mov	$__NR_##name,%ax; \
	jmp	__unified_syscall_16bit@PLT;  \
.else ; \
	mov	$__NR_##name,%al; \
	jmp	__unified_syscall@PLT;  \
.endif

#else

#define syscall_weak(name,wsym,sym) \
.text; \
.type wsym,@function; \
.weak wsym; \
wsym: ; \
.type sym,@function; \
.global sym; \
sym: \
.ifge __NR_##name-256 ; \
	mov	$__NR_##name,%ax; \
	jmp	__unified_syscall_16bit;  \
.else ; \
	mov	$__NR_##name,%al; \
	jmp	__unified_syscall;  \
.endif

#define syscall(name,sym) \
.text; \
.type sym,@function; \
.global sym; \
sym: \
.ifge __NR_##name-256 ; \
	mov	$__NR_##name,%ax; \
	jmp	__unified_syscall_16bit; \
.else ; \
	mov	$__NR_##name,%al; \
	jmp	__unified_syscall; \
.endif
#endif
