# AUTOGENERATED! DO NOT EDIT! File to edit: helper.ipynb (unless otherwise specified).

__all__ = ['Helper']

# Cell
import pandas as pd
from datetime import datetime
import pickle, json , boto3, zlib, os

class Helper:
  @staticmethod
  def groupByProduct(data):
    df = pd.DataFrame(data)
    gprcode = df.groupby('ib_prcode')
    # group by ib_prcode, then ib_brcode, add timestamp as well
    res = gprcode.agg(list).apply(lambda x: {
          k:v for k,v in zip(
              x['ib_brcode'], [
                {
                  'ib_cf_qty': int(qty),
                  'new_ib_bs_stock_cv': int(new),
                  'lastUpdate' : datetime.now().timestamp()
                }
                for qty,new in zip(x['ib_cf_qty'], x['new_ib_vs_stock_cv'])
              ]
            )
        } , axis = 1)
    return res.to_dict()
