# Generated by Django 3.2.8 on 2022-06-19 12:36

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='Address',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('house_flat_number', models.CharField(max_length=500, null=True)),
                ('street', models.CharField(max_length=500, null=True)),
                ('area', models.CharField(max_length=500, null=True)),
                ('city', models.CharField(max_length=500, null=True)),
                ('state', models.CharField(max_length=500)),
                ('country', models.CharField(max_length=500)),
                ('type', models.CharField(max_length=50)),
                ('pin', models.IntegerField()),
                ('primary', models.BooleanField(default=False)),
                ('is_shipping', models.BooleanField(default=True)),
                ('phone', models.CharField(max_length=12, null=True)),
                ('alternate_contact', models.CharField(blank=True, max_length=12, null=True)),
                ('customer_name', models.CharField(default=None, max_length=100, null=True)),
                ('user_id', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='Attribute',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('slug', models.CharField(max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name='AttributeValue',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.CharField(max_length=100)),
                ('slug', models.CharField(max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name='Brand',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('slug', models.CharField(max_length=1000, unique=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('address', models.TextField(blank=True, null=True)),
                ('city', models.CharField(blank=True, max_length=100, null=True)),
                ('state', models.CharField(blank=True, max_length=100, null=True)),
                ('country', models.CharField(blank=True, max_length=100, null=True)),
                ('pincode', models.CharField(blank=True, max_length=100, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Cart',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('customer_id', models.CharField(max_length=255, unique=True)),
                ('cart_hash', models.CharField(blank=True, default=None, max_length=255, null=True)),
                ('cart_total', models.DecimalField(blank=True, decimal_places=2, default=None, max_digits=8, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('slug', models.CharField(max_length=100)),
                ('left', models.IntegerField(default=0)),
                ('right', models.IntegerField(default=0)),
                ('display', models.CharField(default=None, max_length=100, null=True)),
                ('image', models.TextField(null=True)),
                ('count', models.IntegerField(default=0)),
                ('header', models.BooleanField(default=False)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='common.category')),
            ],
        ),
        migrations.CreateModel(
            name='Order',
            fields=[
                ('id', models.UUIDField(default=uuid.UUID('5f1c7d64-cd6d-42b9-925e-c947a2036db5'), primary_key=True, serialize=False)),
                ('status', models.IntegerField(db_index=True)),
                ('display_status', models.CharField(max_length=30)),
                ('discount_total', models.DecimalField(decimal_places=2, default=0.0, max_digits=10)),
                ('discount_tax', models.DecimalField(decimal_places=2, default=0.0, max_digits=10)),
                ('shipping_total', models.DecimalField(decimal_places=2, default=0.0, max_digits=10)),
                ('shipping_tax', models.DecimalField(decimal_places=2, default=0.0, max_digits=10)),
                ('total_tax', models.DecimalField(decimal_places=2, default=0.0, max_digits=10)),
                ('total', models.DecimalField(db_index=True, decimal_places=2, max_digits=10)),
                ('total_items', models.IntegerField(db_index=True, default=0)),
                ('payment_paid', models.BooleanField(db_index=True, default=False)),
                ('payment_method', models.CharField(db_index=True, max_length=200, null=True)),
                ('transaction_id', models.CharField(default=None, max_length=100, null=True)),
                ('currency_code', models.CharField(default='INR', max_length=5)),
                ('meta_data', models.JSONField(default=list)),
                ('cancelled_reason', models.CharField(default=None, max_length=400, null=True)),
                ('customer_id', models.CharField(db_index=True, max_length=100)),
                ('customer_first_name', models.CharField(default=None, max_length=255, null=True)),
                ('customer_last_name', models.CharField(default=None, max_length=100, null=True)),
                ('customer_email', models.EmailField(default=None, max_length=100, null=True)),
                ('payment_date', models.DateTimeField(default=None, null=True)),
                ('order_complete_date', models.DateTimeField(default=None, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='OtpData',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('session_token', models.CharField(max_length=250)),
                ('otp_no', models.IntegerField()),
                ('to', models.CharField(max_length=255)),
                ('time', models.DateTimeField(auto_now_add=True)),
                ('otp_count_today', models.IntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=500)),
                ('sku', models.CharField(max_length=20, unique=True)),
                ('slug', models.CharField(max_length=500, unique=True)),
                ('display_type', models.CharField(default=None, max_length=100, null=True)),
                ('display_stock_status', models.CharField(default=None, max_length=100, null=True)),
                ('type', models.IntegerField(choices=[(1, 'Simple'), (2, 'Variable')], default=1)),
                ('stock_status', models.IntegerField(choices=[(1, 'Instock'), (2, 'Outofstock')], default=1)),
                ('product_url', models.TextField(default=None, null=True)),
                ('variant_id', models.JSONField(default=list)),
                ('variants_count', models.IntegerField(default=0)),
                ('description', models.TextField(default=None, null=True)),
                ('featured_image', models.TextField(default=None, null=True)),
                ('thumbnail_image', models.TextField(default=None, null=True)),
                ('gallery', models.JSONField(default=list)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('brand', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='common.brand')),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='common.category')),
            ],
        ),
        migrations.CreateModel(
            name='ShopPlan',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=500, unique=True)),
                ('duration', models.IntegerField()),
                ('active', models.BooleanField(default=True, null=True)),
                ('amount', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='Template',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=500, unique=True)),
                ('active', models.BooleanField(default=True, null=True)),
                ('custom', models.BooleanField(default=True, null=True)),
                ('theme', models.JSONField(default=list)),
            ],
        ),
        migrations.CreateModel(
            name='TokenBlacklist',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('token', models.TextField(default=None, null=True)),
                ('reason', models.CharField(default=None, max_length=100, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='Variant',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=500)),
                ('sku', models.CharField(max_length=200, unique=True)),
                ('slug', models.CharField(max_length=500, unique=True)),
                ('gtin', models.CharField(blank=True, default=None, max_length=255, null=True)),
                ('short_description', models.TextField(blank=True, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('stock_status', models.IntegerField(choices=[(1, 'Instock'), (2, 'Outofstock')], default=1)),
                ('display_stock_status', models.CharField(default=None, max_length=100)),
                ('cogs', models.DecimalField(decimal_places=2, default=0.0, max_digits=10)),
                ('price', models.DecimalField(decimal_places=2, default=0.0, max_digits=10)),
                ('regular_price', models.DecimalField(decimal_places=2, default=0.0, max_digits=10)),
                ('sale_price', models.DecimalField(decimal_places=2, default=0.0, max_digits=10)),
                ('stock_quantity', models.IntegerField(blank=True, default=0, null=True)),
                ('gallery', models.JSONField(blank=True, default=list, null=True)),
                ('featured_image', models.TextField(blank=True, default=None, null=True)),
                ('thumbnail_image', models.TextField(blank=True, default=None, null=True)),
                ('product_url', models.TextField(blank=True, default=None, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('brand', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='common.brand')),
                ('category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='common.category')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='common.product')),
            ],
        ),
        migrations.CreateModel(
            name='VariantAttributeMapping',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('attribute', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='common.attribute')),
                ('value', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='common.attributevalue')),
                ('variant', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='common.variant')),
            ],
        ),
        migrations.CreateModel(
            name='Shop',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=500, unique=True)),
                ('description', models.CharField(max_length=500)),
                ('slug', models.CharField(max_length=500, unique=True)),
                ('address', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='common.address')),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='common.category')),
                ('plan', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='common.shopplan')),
                ('template', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='common.template')),
            ],
        ),
        migrations.CreateModel(
            name='OrderItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('product_name', models.TextField(null=True)),
                ('product_id', models.IntegerField()),
                ('product_sku', models.CharField(max_length=255, null=True)),
                ('quantity', models.IntegerField(db_index=True)),
                ('category_id', models.IntegerField(default=None, null=True)),
                ('tax_class', models.CharField(max_length=255, null=True)),
                ('subtotal', models.DecimalField(decimal_places=2, max_digits=10, null=True)),
                ('subtotal_tax', models.DecimalField(decimal_places=2, max_digits=10, null=True)),
                ('total', models.DecimalField(decimal_places=2, max_digits=10)),
                ('total_tax', models.DecimalField(decimal_places=2, max_digits=10, null=True)),
                ('price', models.DecimalField(db_index=True, decimal_places=2, max_digits=10, null=True)),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='common.order')),
            ],
        ),
        migrations.CreateModel(
            name='OrderAddress',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('house_flat_number', models.CharField(max_length=500, null=True)),
                ('street', models.CharField(max_length=500, null=True)),
                ('area', models.CharField(max_length=500, null=True)),
                ('city', models.CharField(max_length=500, null=True)),
                ('state', models.CharField(max_length=500)),
                ('country', models.CharField(max_length=500)),
                ('type', models.CharField(max_length=50, null=True)),
                ('pin', models.IntegerField()),
                ('is_shipping', models.BooleanField(default=True)),
                ('phone', models.CharField(max_length=12, null=True)),
                ('alternate_contact', models.CharField(blank=True, max_length=12, null=True)),
                ('customer_name', models.CharField(default=None, max_length=100, null=True)),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='common.order')),
            ],
        ),
        migrations.CreateModel(
            name='CartItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('product_id', models.IntegerField()),
                ('quantity', models.IntegerField()),
                ('is_freebie', models.BooleanField(default=False)),
                ('cart', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='common.cart')),
            ],
        ),
        migrations.CreateModel(
            name='AttributeValueMapping',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('attribute', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='common.attribute')),
                ('value', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='common.attributevalue')),
            ],
        ),
        migrations.CreateModel(
            name='CustomUser',
            fields=[
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('first_name', models.CharField(blank=True, max_length=150, verbose_name='first name')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('username', models.CharField(blank=True, default=None, max_length=60, null=True)),
                ('last_name', models.CharField(blank=True, default=None, max_length=60, null=True)),
                ('email', models.EmailField(max_length=254, unique=True)),
                ('user_id', models.AutoField(primary_key=True, serialize=False)),
                ('first_login', models.BooleanField(default=True)),
                ('recovery_email', models.CharField(blank=True, max_length=100)),
                ('email_verified', models.BooleanField(default=False)),
                ('phone', models.CharField(blank=True, max_length=20, null=True)),
                ('status', models.CharField(choices=[('Active', 'Active'), ('Inactive', 'Inactive')], default='Active', max_length=10)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('created_by', models.CharField(blank=True, max_length=100)),
                ('modified_date', models.DateTimeField(auto_now=True, null=True)),
                ('modified_by', models.CharField(blank=True, max_length=100)),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions')),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'abstract': False,
            },
        ),
    ]
