# API Reference

This page provides comprehensive API documentation for memg-core.

## Public API

The main interface for memg-core is through the public API module:

::: memg_core.api.public
    options:
      members: true
      show_source: true
      extra:
        undoc-members: true

## Core Models

Core data models and types:

::: memg_core.core.models
    options:
      members: true
      show_source: true
      extra:
        undoc-members: true

## Configuration

Configuration management:

::: memg_core.core.config
    options:
      members: true
      show_source: true
      extra:
        undoc-members: true

## Exceptions

Exception classes:

::: memg_core.core.exceptions
    options:
      members: true
      show_source: true
      extra:
        undoc-members: true

## YAML Schema

YAML schema handling:

::: memg_core.core.yaml_translator
    options:
      members: true
      show_source: true
      extra:
        undoc-members: true

## Utilities

### HRID Management

Human-readable ID utilities:

::: memg_core.utils.hrid
    options:
      members: true
      show_source: true
      extra:
        undoc-members: true

::: memg_core.utils.hrid_tracker
    options:
      members: true
      show_source: true
      extra:
        undoc-members: true

### Database Clients

Database client utilities:

::: memg_core.utils.db_clients
    options:
      members: true
      show_source: true
      extra:
        undoc-members: true
