from scomconfig import *

MPW = '42'

commands = [
    AssignMasterPassword(new_password=MPW),
    AssignControlOperatorPassword(new_password='52'),
    SetSoftwareSwitch('0004', '1'),
    SetSoftwareSwitch('0003', '1'),
    SetEventTriggeredMacro(port='0', event_macro_number='00', macro_name='B000'),

    EraseMacro('B000'),
    CreateNewMacro('B000', password=MPW, command=SendMessage(message=['9960', '0342', '0242', '1293'])),
    AppendToMacro('B000', macro='B003'),
    SelectMessage('0016', message_contents=['9993', '10', '9960', '0342']),
    SelectMessage('0017', message_contents=['9993', '10', '9960', '3038', '1239', '0342']),
    SelectMessage('0019', message_contents=['9993', '10', '9960', '3038']),
    SelectMessage('0020', message_contents=['9905', '20', '9904', '0068', '9900', '32', '01', '15', '23', '38', '27']),
    SelectMessage('0021', message_contents=['9993', '10', '9961', '3039']),
    SelectMessage('0022', message_contents=['9993', '10', '9961', '3056']),
    SelectMessage('0023', message_contents=['9993', '10', '9961', '3058']),
    SelectMessage('0001', message_contents=['9960', '0016', '0059', '0055']),
    SelectMessage('0002', message_contents=['9960', '0016', '0261', '0001']),
    SelectMessage('0003', message_contents=['9960', '0016', '0261', '0003']),
    SelectPathAccessMode(receiver='1', transmitter='1', mode='3'),
    SelectPathAccessMode(receiver='2', transmitter='1', mode='1'),
    SelectPathAccessMode(receiver='3', transmitter='1', mode='1'),
    SelectPathAccessMode(receiver='1', transmitter='2', mode='3'),
    SelectPathAccessMode(receiver='2', transmitter='2', mode='0'),
    SelectPathAccessMode(receiver='3', transmitter='2', mode='1'),
    SelectPathAccessMode(receiver='1', transmitter='3', mode='3'),
    SelectPathAccessMode(receiver='2', transmitter='3', mode='1'),
    SelectPathAccessMode(receiver='3', transmitter='3', mode='0'),
    SetSoftwareSwitch('0141', '1'),
    SetSoftwareSwitch('0142', '1'),
    SetSoftwareSwitch('0143', '1'),
    SetSoftwareSwitch('0241', '1'),
    SetSoftwareSwitch('0242', '0'),
    SetSoftwareSwitch('0243', '1'),
    SetSoftwareSwitch('0341', '1'),
    SetSoftwareSwitch('0342', '1'),
    SetSoftwareSwitch('0343', '0'),
    SetSoftwareSwitch('0005', '1'),
    SelectFrequencyofCW(transmitter='0', tone_code='0239'),
    SetSoftwareSwitch('0002', '1'),

    EraseMacro('B010'),
    CreateNewMacro('B010', password=MPW, command=AdjustDaylightSavingTime(operation='1')),
    AppendToMacro('B010', password=MPW, command=SendMessage(message=['9961', '0048', '0063', '0064', '0348', '9993', '10', '9961', '0234', '0346', '0816', '0001', '0098'])),
    AppendToMacro('B010', macro='B009'),

    EraseMacro('B011'),
    CreateNewMacro('B011', password=MPW, command=AdjustDaylightSavingTime(operation='2')),
    AppendToMacro('B011', password=MPW, command=SendMessage(message=['9961', '0048', '0063', '0064', '0741', '9993', '10', '9961', '0234', '0346', '0473', '0001', '0098'])),
    AppendToMacro('B011', macro='B009'),
    CreateSetpoint('98', macro='B010', month='03', day='76', hour='02', minute='00'),
    CreateSetpoint('99', macro='B011', month='10', day='76', hour='02', minute='00'),

    EraseMacro('B009'),
    CreateNewMacro('B009', password=MPW, command=SendMessage(message=['9993', '07', '9826', '9829', '9828', '9820', '9821'])),

    EraseMacro('B001'),
    CreateNewMacro('B001', password=MPW, command=SendMessage(message=['9993', '10', '9961', '1352', '0039', '0005', '0035', '1550', '9899'])),

    EraseMacro('B002'),
    CreateNewMacro('B002', password=MPW, command=SendMessage(message=['9993', '10', '9961', '9825', '9832'])),

    EraseMacro('B003'),
    CreateNewMacro('B003', password=MPW, command=IfThenElse(value_type=ValueType.boolean, value='0012', true_macro='CA50', false_macro='CA51')),

    EraseMacro('CA50'),
    CreateNewMacro('CA50', password=MPW, command=SendMessage(message=['9993', '10', '9960', '0342', '0242', '0225', '0287', '0860'])),

    EraseMacro('CA51'),
    CreateNewMacro('CA51', password=MPW, command=SendMessage(message=['9993', '10', '9960', '0342', '0242', '0225', '0373'])),

    EraseMacro('B005'),
    CreateNewMacro('B005', password=MPW, command=EnableDisableSetpoint(setpoint_number_start='02', enabled='1', setpoint_number_end=None)),

    EraseMacro('B006'),
    CreateNewMacro('B006', password=MPW, command=EnableDisableSetpoint(setpoint_number_start='02', enabled='0', setpoint_number_end=None)),

    EraseMacro('B007'),
    CreateNewMacro('B007', password=MPW, command=SendMessage(message=['9993', '10', '9961', '0860', '9831', '9961', '0288', '0287'])),
    AppendToMacro('B007', macro='B009'),
    CreateSetpoint(setpoint_number='00', macro='B005', month='99', day='99', hour='07', minute='59'),
    CreateSetpoint(setpoint_number='01', macro='B006', month='99', day='99', hour='21', minute='01'),
    CreateSetpoint(setpoint_number='02', macro='B007', month='99', day='99', hour='99', minute='00'),
    SelectMessage('0015', message_contents=['9961', '3037', '3031', '3048']),

    EraseMacro('B012'),
    CreateNewMacro('B012', password=MPW, command=SelectIDTailMessages(message='0', message_number='0015')),
    AppendToMacro('B012', password=MPW, command=SelectIDTailMessages(message='1', message_number='0015')),

    EraseMacro('B013'),
    CreateNewMacro('B013', password=MPW, command=SelectIDTailMessages(message='0', message_number=None)),
    AppendToMacro('B013', password=MPW, command=SelectIDTailMessages(message='1', message_number=None)),

    EraseMacro('B014'),
    CreateNewMacro('B014', password=MPW, command=SendMessage(message=['9993', '10', '9961', '3037', '3031', '3048'])),
    CreateSetpoint(setpoint_number='11', macro='B012', month='01', day='51', hour='12', minute='00'),
    CreateSetpoint(setpoint_number='12', macro='B012', month='02', day='51', hour='12', minute='00'),
    CreateSetpoint(setpoint_number='13', macro='B012', month='03', day='51', hour='12', minute='00'),
    CreateSetpoint(setpoint_number='14', macro='B012', month='04', day='51', hour='12', minute='00'),
    CreateSetpoint(setpoint_number='15', macro='B012', month='05', day='51', hour='12', minute='00'),
    CreateSetpoint(setpoint_number='16', macro='B012', month='06', day='51', hour='12', minute='00'),
    CreateSetpoint(setpoint_number='17', macro='B012', month='07', day='51', hour='12', minute='00'),
    CreateSetpoint(setpoint_number='18', macro='B012', month='08', day='51', hour='12', minute='00'),
    CreateSetpoint(setpoint_number='19', macro='B012', month='09', day='51', hour='12', minute='00'),
    CreateSetpoint(setpoint_number='20', macro='B012', month='10', day='44', hour='12', minute='00'),
    CreateSetpoint(setpoint_number='21', macro='B012', month='11', day='51', hour='12', minute='00'),
    CreateSetpoint(setpoint_number='22', macro='B012', month='12', day='51', hour='12', minute='00'),
    CreateSetpoint(setpoint_number='04', macro='B013', month='99', day='40', hour='09', minute='01'),

    EraseMacro('A999'),
    CreateNewMacro('A999', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='C999', false_macro='CA79')),

    EraseMacro('C999'),
    CreateNewMacro('C999', macro='CA82'),
    AppendToMacro('C999', password='DD', command=SendMessage(message=['9961', '1433'])),
    AppendToMacro('C999', macro='C900'),
    AppendToMacro('C999', password='DD', command=SendMessage(message=['9993', '10', '9961', '0328', '0286'])),
    AppendToMacro('C999', macro='C901'),
    AppendToMacro('C999', macro='C902'),
    AppendToMacro('C999', macro='C903'),
    AppendToMacro('C999', password='DD', command=SendMessage(message=['9993', '10', '9961', '0351', '0286'])),
    AppendToMacro('C999', macro='B003'),
    AppendToMacro('C999', macro='B009'),

    EraseMacro('C900'),
    CreateNewMacro('C900', password='DD', command=SendMessage(message=['9993', '10', '9961', '0307', '1093', '0287'])),
    AppendToMacro('C900', password='DD', command=IfThenElse(value_type=ValueType.software_switch, value='0060', true_macro='CA52', false_macro='CA53')),

    EraseMacro('C901'),
    CreateNewMacro('C901', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0001', '0339', '0362', '0365', '0001', '0287'])),
    AppendToMacro('C901', password='DD', command=IfThenElse(value_type=ValueType.boolean, value='0122', true_macro='CA52', false_macro='CA53')),
    AppendToMacro('C901', password='DD', command=SendMessage(message=['9961', '1238', '0001', '0339', '0362', '0365', '0003', '0287'])),
    AppendToMacro('C901', password='DD', command=IfThenElse(value_type=ValueType.boolean, value='0222', true_macro='CA52', false_macro='CA53')),
    AppendToMacro('C901', password='DD', command=SendMessage(message=['9961', '1238', '0001', '0339', '0362', '0365', '0005', '0287'])),
    AppendToMacro('C901', password='DD', command=IfThenElse(value_type=ValueType.boolean, value='0322', true_macro='CA52', false_macro='CA53')),

    EraseMacro('C902'),
    CreateNewMacro('C902', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0003', '0339', '0362', '0365', '0001', '0287'])),
    AppendToMacro('C902', password='DD', command=IfThenElse(value_type=ValueType.boolean, value='0123', true_macro='CA52', false_macro='CA53')),
    AppendToMacro('C902', password='DD', command=SendMessage(message=['9961', '1238', '0003', '0339', '0362', '0365', '0003', '0287'])),
    AppendToMacro('C902', password='DD', command=IfThenElse(value_type=ValueType.boolean, value='0223', true_macro='CA52', false_macro='CA53')),
    AppendToMacro('C902', password='DD', command=SendMessage(message=['9961', '1238', '0003', '0339', '0362', '0365', '0005', '0287'])),
    AppendToMacro('C902', password='DD', command=IfThenElse(value_type=ValueType.boolean, value='0323', true_macro='CA52', false_macro='CA53')),

    EraseMacro('C903'),
    CreateNewMacro('C903', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0005', '0339', '0362', '0365', '0001', '0287'])),
    AppendToMacro('C903', password='DD', command=IfThenElse(value_type=ValueType.boolean, value='0124', true_macro='CA52', false_macro='CA53')),
    AppendToMacro('C903', password='DD', command=SendMessage(message=['9961', '1238', '0005', '0339', '0362', '0365', '0003', '0287'])),
    AppendToMacro('C903', password='DD', command=IfThenElse(value_type=ValueType.boolean, value='0224', true_macro='CA52', false_macro='CA53')),
    AppendToMacro('C903', password='DD', command=SendMessage(message=['9961', '1238', '0005', '0339', '0362', '0365', '0005', '0287'])),
    AppendToMacro('C903', password='DD', command=IfThenElse(value_type=ValueType.boolean, value='0324', true_macro='CA52', false_macro='CA53')),

    EraseMacro('CA52'),
    CreateNewMacro('CA52', password='DD', command=SendMessage(message=['9961', '0255'])),

    EraseMacro('CA53'),
    CreateNewMacro('CA53', password='DD', command=SendMessage(message=['9961', '0248'])),

    EraseMacro('CA77'),
    CreateNewMacro('CA77', password=MPW, command=SelectMessage('0100', message_contents=['9991', '9910', '57', '0300', '03', '61', '57', '0300', '03', '61', '57', '0300', '03'])),

    EraseMacro('CA78'),
    CreateNewMacro('CA78', password=MPW, command=SelectMessage('0100', message_contents=['9991', '9910', '57', '0028', '01', '57', '0048', '01', '57', '0068', '01', '57', '0088', '01', '57', '0108', '01', '57', '0128', '01', '57', '0148', '01', '57', '0168', '01'])),

    EraseMacro('CA79'),
    CreateNewMacro('CA79', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0005', true_macro='CA87', false_macro=None)),

    EraseMacro('CA80'),
    CreateNewMacro('CA80', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0005', true_macro='CA85', false_macro=None)),

    EraseMacro('CA81'),
    CreateNewMacro('CA81', password=MPW, command=ReviewMessage(message_number='0016')),

    EraseMacro('CA82'),
    CreateNewMacro('CA82', password=MPW, command=ReviewMessage(message_number='0017')),

    EraseMacro('CA83'),
    CreateNewMacro('CA83', password=MPW, command=ReviewMessage(message_number='0019')),

    EraseMacro('CA84'),
    CreateNewMacro('CA84', password=MPW, command=ReviewMessage(message_number='0020')),

    EraseMacro('CA85'),
    CreateNewMacro('CA85', macro='CA81'),
    AppendToMacro('CA85', password=MPW, command=SendMessage(message=['9991', '9915', '55', '570044018840'])),

    EraseMacro('CA86'),
    CreateNewMacro('CA86', password=MPW, command=ReviewMessage(message_number='0023')),

    EraseMacro('CA87'),
    CreateNewMacro('CA87', password=MPW, command=SendMessage(message=['9991', '9915', '57', '0036', '0048', '20', '57', '0036', '0018', '20'])),

    EraseMacro('DC70'),
    CreateNewMacro('DC70', macro='CA81'),
    AppendToMacro('DC70', password=MPW, command=SetSoftwareSwitch('0004', '0')),
    AppendToMacro('DC70', password=MPW, command=StopTimer(timer=0)),
    AppendToMacro('DC70', password=MPW, command=SendMessage(message=['9960', '3053'])),

    EraseMacro('DC71'),
    CreateNewMacro('DC71', password=MPW, command=SelectTimerTimeoutValue(timer=0, delay=6000)),
    AppendToMacro('DC71', password=MPW, command=SelectTimerEventMacro(timer=0, macro='DC70')),
    AppendToMacro('DC71', password=MPW, command=StartTimerOneShot(timer=0)),
    AppendToMacro('DC71', password=MPW, command=SetSoftwareSwitch('0004', '1')),
    AppendToMacro('DC71', macro='CA81'),
    AppendToMacro('DC71', password=MPW, command=SendMessage(message=['9960', '3054'])),

    EraseMacro('D990'),
    CreateNewMacro('D990', macro='CA83'),
    AppendToMacro('D990', macro='CA86'),

    EraseMacro('D991'),
    CreateNewMacro('D991', macro='CA82'),
    AppendToMacro('D991', macro='CA86'),

    EraseMacro('D995'),
    CreateNewMacro('D995', macro='CA83'),
    AppendToMacro('D995', password=MPW, command=SendMessage(message=['9961', '3045'])),

    EraseMacro('D99A'),
    CreateNewMacro('D99A', macro='CA82'),
    AppendToMacro('D99A', macro='CA86'),
    AppendToMacro('D99A', password=MPW, command=SetEventTriggeredMacro(port='1', event_macro_number='08', macro_name='D99B')),

    EraseMacro('D99B'),
    CreateNewMacro('D99B', macro='CA82'),
    AppendToMacro('D99B', password=MPW, command=ReviewMessage(message_number='0021')),
    AppendToMacro('D99B', password=MPW, command=SetEventTriggeredMacro(port='1', event_macro_number='08', macro_name='D99C')),

    EraseMacro('D99C'),
    CreateNewMacro('D99C', macro='CA82'),
    AppendToMacro('D99C', password=MPW, command=ReviewMessage(message_number='0022')),
    AppendToMacro('D99C', password=MPW, command=SetEventTriggeredMacro(port='1', event_macro_number='08', macro_name='D99A')),

    EraseMacro('D99D'),
    CreateNewMacro('D99D', password=MPW, command=SendMessage(message=['9961', '3037', '3031', '3048'])),

    EraseMacro('0A90'),
    CreateNewMacro('0A90', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='6153', false_macro='CA79')),

    EraseMacro('0A91'),
    CreateNewMacro('0A91', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='6154', false_macro='CA79')),

    EraseMacro('0A12'),
    CreateNewMacro('0A12', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='6121', false_macro='CA79')),

    EraseMacro('0A21'),
    CreateNewMacro('0A21', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='6120', false_macro='CA79')),

    EraseMacro('A100'),
    CreateNewMacro('A100', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='C901', false_macro='CA79')),

    EraseMacro('A110'),
    CreateNewMacro('A110', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='6140', false_macro='CA79')),

    EraseMacro('A111'),
    CreateNewMacro('A111', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='6141', false_macro='CA79')),

    EraseMacro('A120'),
    CreateNewMacro('A120', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='6140', false_macro='CA79')),
    AppendToMacro('A120', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='6240', false_macro='CA79')),

    EraseMacro('A121'),
    CreateNewMacro('A121', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='6141', false_macro='CA79')),
    AppendToMacro('A121', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='6241', false_macro='CA79')),

    EraseMacro('A130'),
    CreateNewMacro('A130', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='6340', false_macro='CA79')),

    EraseMacro('A131'),
    CreateNewMacro('A131', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='6341', false_macro='CA79')),

    EraseMacro('A190'),
    CreateNewMacro('A190', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='6160', false_macro='CA79')),

    EraseMacro('A191'),
    CreateNewMacro('A191', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='6161', false_macro='CA79')),

    EraseMacro('A200'),
    CreateNewMacro('A200', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='C902', false_macro='CA79')),

    EraseMacro('A220'),
    CreateNewMacro('A220', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='6240', false_macro='CA79')),

    EraseMacro('A221'),
    CreateNewMacro('A221', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='6241', false_macro='CA79')),

    EraseMacro('A300'),
    CreateNewMacro('A300', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='C903', false_macro='CA79')),

    EraseMacro('0A80'),
    CreateNewMacro('0A80', password=MPW, command=SetSoftwareSwitch('0060', '0')),
    AppendToMacro('0A80', macro='CA78'),
    AppendToMacro('0A80', password=MPW, command=SetEventTriggeredMacro(port='1', event_macro_number='08', macro_name='D99A')),
    AppendToMacro('0A80', password=MPW, command=SetEventTriggeredMacro(port='1', event_macro_number='09', macro_name='D991')),
    AppendToMacro('0A80', password=MPW, command=SetEventTriggeredMacro(port='1', event_macro_number='54', macro_name=None)),
    AppendToMacro('0A80', password=MPW, command=SetTimerValue(resolution='0', port='1', timer='01', time_value=200)),
    AppendToMacro('0A80', password=MPW, command=SetSoftwareSwitch('0161', '0')),
    AppendToMacro('0A80', macro='CA81'),
    AppendToMacro('0A80', password=MPW, command=SendMessage(message=['9993', '10', '9961', '0307', '1093', '0248'])),

    EraseMacro('0A81'),
    CreateNewMacro('0A81', password=MPW, command=SetSoftwareSwitch('0060', '1')),
    AppendToMacro('0A81', macro='CA77'),
    AppendToMacro('0A81', password=MPW, command=SetEventTriggeredMacro(port='1', event_macro_number='08', macro_name='D995')),
    AppendToMacro('0A81', password=MPW, command=SetEventTriggeredMacro(port='1', event_macro_number='09', macro_name='D995')),
    AppendToMacro('0A81', password=MPW, command=SetEventTriggeredMacro(port='1', event_macro_number='54', macro_name='D995')),
    AppendToMacro('0A81', password=MPW, command=SetTimerValue(resolution='2', port='1', timer='03', time_value=180)),
    AppendToMacro('0A81', password=MPW, command=SetTimerValue(resolution='0', port='1', timer='01', time_value=50)),
    AppendToMacro('0A81', macro='CA81'),
    AppendToMacro('0A81', password=MPW, command=SendMessage(message=['9993', '10', '9961', '0307', '1093', '0255'])),
    SetTimerValue(resolution='0', port='1', timer='19', time_value=75),
    SetTimerValue(resolution='0', port='1', timer='03', time_value=100),
    SetTimerValue(resolution='0', port='1', timer='02', time_value=75),
    SetTimerValue(resolution='2', port='1', timer='06', time_value=450),
    SetTimerValue(resolution='0', port='1', timer='00', time_value=50),
    SetTimerValue(resolution='0', port='1', timer='01', time_value=200),
    SetTimerValue(resolution='2', port='1', timer='11', time_value=0),
    SetTimerValue(resolution='2', port='1', timer='07', time_value=120),
    SetTimerValue(resolution='0', port='1', timer='00', time_value=50),
    ControlCTCSSEncoder(transmitter='1', mode='1', reverse_burst='2'),
    SelectCTCSSEncoderFrequency(transmitter='1', tone_number=26),
    SelectMessage('0109', message_contents=[]),
    SetEventTriggeredMacro(port='1', event_macro_number='08', macro_name='D99A'),
    SelectMessage('0110', message_contents=[]),
    SetEventTriggeredMacro(port='1', event_macro_number='09', macro_name='D991'),
    SelectMessage('0111', message_contents=[]),
    SetEventTriggeredMacro(port='1', event_macro_number='10', macro_name='CA84'),
    SelectMessage('0103', message_contents=['9960', '3062']),
    SelectMessage('0106', message_contents=['9961', '0339', '0001', '0360', '1293', '0005', '0101']),
    SelectMessage('0104', message_contents=['9960', '0339', '0003', '1487']),
    SelectMessage('0107', message_contents=['9961', '0339', '0003', '0360', '1293', '0005', '0101']),
    SelectMessage('0105', message_contents=['9960', '0339', '0005', '1487']),
    SelectMessage('0108', message_contents=['9961', '0339', '0003', '0360', '1293', '0005', '0101']),

    EraseMacro('6100'),
    CreateNewMacro('6100', macro='6141'),
    AppendToMacro('6100', password=MPW, command=SetSoftwareSwitch('0005', '0')),
    AppendToMacro('6100', macro='6151'),
    AppendToMacro('6100', macro='6154'),
    AppendToMacro('6100', macro='6156'),
    AppendToMacro('6100', macro='6161'),
    AppendToMacro('6100', macro='6162'),
    AppendToMacro('6100', macro='6121'),
    AppendToMacro('6100', macro='6131'),
    AppendToMacro('6100', password=MPW, command=SetSoftwareSwitch('0005', '1')),
    AppendToMacro('6100', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA81', false_macro=None)),
    AppendToMacro('6100', password='DD', command=SendMessage(message=['9961', '1238', '0001', '0287', '1155', '0283', '1144', '1093'])),

    EraseMacro('6101'),
    CreateNewMacro('6101', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6101', macro='6141'),
    AppendToMacro('6101', macro='6151'),
    AppendToMacro('6101', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0001', '0255'])),

    EraseMacro('6102'),
    CreateNewMacro('6102', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6102', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0001', '0248'])),
    AppendToMacro('6102', password='DD', command=Pause(seconds=500)),
    AppendToMacro('6102', macro='6140'),
    AppendToMacro('6102', macro='6150'),

    EraseMacro('6120'),
    CreateNewMacro('6120', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6120', password='DD', command=SetSoftwareSwitch('0142', '0')),
    AppendToMacro('6120', password='DD', command=SetSoftwareSwitch('0241', '0')),
    AppendToMacro('6120', password='DD', command=SendMessage(message=['9712', '9993', '10', '9961', '0339', '0001', '0362', '1238', '0003', '0646', '0294', '0341', '0314'])),

    EraseMacro('6121'),
    CreateNewMacro('6121', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6121', password='DD', command=SetSoftwareSwitch('0142', '1')),
    AppendToMacro('6121', password='DD', command=SetSoftwareSwitch('0241', '1')),
    AppendToMacro('6121', password='DD', command=SendMessage(message=['9712', '9993', '10', '9961', '0339', '0001', '0362', '1238', '0003', '0646', '0294', '0341', '0315'])),

    EraseMacro('6122'),
    CreateNewMacro('6122', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6122', password='DD', command=SetSoftwareSwitch('0142', '1')),
    AppendToMacro('6122', password='DD', command=SetSoftwareSwitch('0241', '0')),
    AppendToMacro('6122', password='DD', command=SendMessage(message=['9993', '10', '9961', '0339', '0003', '0362', '0365', '0001', '1100', '1173'])),

    EraseMacro('6123'),
    CreateNewMacro('6123', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6123', password='DD', command=SelectPathAccessMode(receiver='2', transmitter='1', mode='1')),
    AppendToMacro('6123', password='DD', command=SendMessage(message=['9993', '10', '9961', '0339', '0003', '0362', '0365', '0001', '0243', '0314'])),

    EraseMacro('6124'),
    CreateNewMacro('6124', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6124', password='DD', command=SelectPathAccessMode(receiver='2', transmitter='1', mode='3')),
    AppendToMacro('6124', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0003', '0362', '0365', '0001', '0243', '0315'])),

    EraseMacro('6125'),
    CreateNewMacro('6125', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6125', password='DD', command=SetSoftwareSwitch('0152', '0')),
    AppendToMacro('6125', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0003', '0362', '0365', '0001', '0252', '1489', '0325', '0315'])),

    EraseMacro('6126'),
    CreateNewMacro('6126', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6126', password='DD', command=SetSoftwareSwitch('0152', '1')),
    AppendToMacro('6126', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0003', '0362', '0365', '0001', '0252', '1489', '0325', '0314'])),

    EraseMacro('6129'),
    CreateNewMacro('6129', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6129', password='DD', command=SetSoftwareSwitch('0172', '1')),
    AppendToMacro('6129', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0003', '0362', '0365', '0001', '1487', '0360', '1293'])),

    EraseMacro('6130'),
    CreateNewMacro('6130', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6130', password='DD', command=SetSoftwareSwitch('0143', '0')),
    AppendToMacro('6130', password='DD', command=SetSoftwareSwitch('0341', '0')),
    AppendToMacro('6130', password='DD', command=SendMessage(message=['9713', '9993', '10', '9961', '0339', '0001', '0362', '0365', '0005', '0646', '0294', '0341', '0314'])),

    EraseMacro('6131'),
    CreateNewMacro('6131', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6131', password='DD', command=SetSoftwareSwitch('0143', '1')),
    AppendToMacro('6131', password='DD', command=SetSoftwareSwitch('0341', '1')),
    AppendToMacro('6131', password='DD', command=SendMessage(message=['9713', '9993', '10', '9961', '0339', '0001', '0362', '0365', '0005', '0646', '0294', '0341', '0315'])),

    EraseMacro('6132'),
    CreateNewMacro('6132', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6132', password='DD', command=SetSoftwareSwitch('0143', '1')),
    AppendToMacro('6132', password='DD', command=SetSoftwareSwitch('0341', '0')),
    AppendToMacro('6132', password='DD', command=SendMessage(message=['9993', '10', '9961', '0339', '0005', '0362', '0365', '0001', '1100', '1173'])),

    EraseMacro('6133'),
    CreateNewMacro('6133', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6133', password='DD', command=SelectPathAccessMode(receiver='3', transmitter='1', mode='1')),
    AppendToMacro('6133', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0005', '0362', '0365', '0001', '0243', '0314'])),

    EraseMacro('6134'),
    CreateNewMacro('6134', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6134', password='DD', command=SelectPathAccessMode(receiver='2', transmitter='1', mode='3')),
    AppendToMacro('6134', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0005', '0362', '0365', '0001', '0243', '0315'])),

    EraseMacro('6135'),
    CreateNewMacro('6135', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6135', password='DD', command=SetSoftwareSwitch('0153', '0')),
    AppendToMacro('6135', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0005', '0362', '0365', '0001', '0252', '1489', '0325', '0315'])),

    EraseMacro('6136'),
    CreateNewMacro('6136', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6136', password='DD', command=SetSoftwareSwitch('0153', '1')),
    AppendToMacro('6136', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0005', '0362', '0365', '0001', '0252', '1489', '0325', '0314'])),

    EraseMacro('6139'),
    CreateNewMacro('6139', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6139', password='DD', command=SetSoftwareSwitch('0173', '1')),
    AppendToMacro('6139', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0005', '0362', '0365', '0001', '1487', '0360', '1293'])),

    EraseMacro('6140'),
    CreateNewMacro('6140', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6140', password='DD', command=SendMessage(message=['9960', '1238', '0001', '0364', '0248'])),
    AppendToMacro('6140', password='DD', command=Pause(seconds=500)),
    AppendToMacro('6140', password='DD', command=SetSoftwareSwitch('0112', '0')),
    AppendToMacro('6140', password='DD', command=SetSoftwareSwitch('0113', '0')),

    EraseMacro('6141'),
    CreateNewMacro('6141', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6141', password='DD', command=SetSoftwareSwitch('0112', '1')),
    AppendToMacro('6141', password='DD', command=SetSoftwareSwitch('0113', '0')),
    AppendToMacro('6141', password='DD', command=SendMessage(message=['9960', '1238', '0001', '0364', '0255'])),

    EraseMacro('6142'),
    CreateNewMacro('6142', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6142', password='DD', command=SendMessage(message=['9960', '1238', '0001', '0742', '0364', '0315'])),
    AppendToMacro('6142', password='DD', command=SetSoftwareSwitch('0112', '1')),
    AppendToMacro('6142', password='DD', command=SetSoftwareSwitch('0113', '1')),

    EraseMacro('6143'),
    CreateNewMacro('6143', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6143', password='DD', command=SetSoftwareSwitch('0114', '1')),

    EraseMacro('6144'),
    CreateNewMacro('6144', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6144', password='DD', command=SetSoftwareSwitch('0115', '1')),

    EraseMacro('6150'),
    CreateNewMacro('6150', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6150', password='DD', command=SetSoftwareSwitch('0119', '0')),
    AppendToMacro('6150', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0314'])),

    EraseMacro('6151'),
    CreateNewMacro('6151', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6151', password='DD', command=SetSoftwareSwitch('0119', '1')),
    AppendToMacro('6151', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0315'])),

    EraseMacro('6153'),
    CreateNewMacro('6153', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6153', password='DD', command=SelectPathAccessMode(receiver='1', transmitter='1', mode='1')),
    AppendToMacro('6153', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0362', '0365', '0001', '0243', '0314'])),

    EraseMacro('6154'),
    CreateNewMacro('6154', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6154', password='DD', command=SelectPathAccessMode(receiver='1', transmitter='1', mode='3')),
    AppendToMacro('6154', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0362', '0365', '0001', '0243', '0315'])),

    EraseMacro('6155'),
    CreateNewMacro('6155', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6155', password='DD', command=SetSoftwareSwitch('0151', '0')),
    AppendToMacro('6155', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0362', '0365', '0001', '0252', '1489', '0325', '0315'])),

    EraseMacro('6156'),
    CreateNewMacro('6156', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6156', password='DD', command=SetSoftwareSwitch('0151', '1')),
    AppendToMacro('6156', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0362', '0365', '0001', '0252', '1489', '0325', '0314'])),

    EraseMacro('6159'),
    CreateNewMacro('6159', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6159', password='DD', command=SetSoftwareSwitch('0171', '1')),
    AppendToMacro('6159', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0362', '0365', '0001', '1487', '0360', '1293'])),

    EraseMacro('6160'),
    CreateNewMacro('6160', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6160', password='DD', command=SetSoftwareSwitch('0161', '0')),
    AppendToMacro('6160', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0362', '0365', '0001', '1487', '0360', '0248'])),

    EraseMacro('6161'),
    CreateNewMacro('6161', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6161', password='DD', command=SetSoftwareSwitch('0161', '0')),
    AppendToMacro('6161', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0362', '0365', '0001', '1487', '0360', '0255'])),

    EraseMacro('6162'),
    CreateNewMacro('6162', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6162', password='DD', command=SetSoftwareSwitch('0110', '0')),
    AppendToMacro('6162', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0349', '0983', '0248'])),

    EraseMacro('6163'),
    CreateNewMacro('6163', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6163', password='DD', command=SetSoftwareSwitch('0110', '1')),
    AppendToMacro('6163', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0349', '0983', '0255'])),

    EraseMacro('6190'),
    CreateNewMacro('6190', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6190', password='DD', command=SetSoftwareSwitch('0118', '0')),
    AppendToMacro('6190', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0001', '1040', '0397', '0314'])),

    EraseMacro('6191'),
    CreateNewMacro('6191', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6191', password='DD', command=SetSoftwareSwitch('0118', '1')),
    AppendToMacro('6191', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0001', '1040', '0397', '0315'])),

    EraseMacro('6192'),
    CreateNewMacro('6192', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6192', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0001', '1363', '0651', '0355', '1489'])),
    AppendToMacro('6192', password='DD', command=SendMessage(message=['9993', '10', '9710', '99', '00', '00', '01', '02', '03', '04', '05', '06', '07', '08', '09'])),

    EraseMacro('6193'),
    CreateNewMacro('6193', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6193', password='DD', command=SetDefaultMessageLevel(transmitter='1', message_type=MessageType.Single_Tone_Page, level=0)),
    AppendToMacro('6193', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0001', '1363', '0323', '1489'])),
    AppendToMacro('6193', password='DD', command=SendMessage(message=['9993', '10', '9710', '9920', '0165', '80'])),

    EraseMacro('6194'),
    CreateNewMacro('6194', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6194', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0001', '1363', '0252', '0355', '1489'])),
    AppendToMacro('6194', password='DD', command=SendMessage(message=['9993', '10', '9710', '9950', '5199', '05'])),
    SetTimerValue(resolution='0', port='2', timer='19', time_value=75),
    SetTimerValue(resolution='0', port='2', timer='03', time_value=100),
    SetTimerValue(resolution='0', port='2', timer='02', time_value=0),
    SetTimerValue(resolution='2', port='2', timer='06', time_value=450),
    SetTimerValue(resolution='0', port='2', timer='00', time_value=0),
    SetTimerValue(resolution='0', port='2', timer='01', time_value=0),
    SetTimerValue(resolution='2', port='2', timer='11', time_value=0),
    ControlCTCSSEncoder(transmitter='2', mode='0', reverse_burst='0'),
    SelectMessage('0200', message_contents=[]),
    SelectMessage('0201', message_contents=[]),
    SelectMessage('0202', message_contents=[]),
    SelectMessage('0209', message_contents=[]),
    SetEventTriggeredMacro(port='2', event_macro_number='08', macro_name='D990'),
    SelectMessage('0210', message_contents=[]),
    SetEventTriggeredMacro(port='2', event_macro_number='09', macro_name='D991'),
    SelectMessage('0211', message_contents=[]),
    SetEventTriggeredMacro(port='2', event_macro_number='10', macro_name='CA84'),
    SelectMessage('0203', message_contents=['9960', '0339', '0001', '1487']),
    SelectMessage('0206', message_contents=['9961', '0339', '0001', '0360', '1293', '0005', '0101']),
    SelectMessage('0204', message_contents=['9960', '0339', '0003', '1487']),
    SelectMessage('0207', message_contents=['9961', '0339', '0003', '0360', '1293', '0005', '0101']),
    SelectMessage('0205', message_contents=['9960', '0339', '0005', '1487']),
    SelectMessage('0208', message_contents=['9961', '0339', '0003', '0360', '1293', '0005', '0101']),

    EraseMacro('6200'),
    CreateNewMacro('6200', macro='6241'),
    AppendToMacro('6200', password=MPW, command=SetSoftwareSwitch('0005', '0')),
    AppendToMacro('6200', macro='6251'),
    AppendToMacro('6200', macro='6254'),
    AppendToMacro('6200', macro='6256'),
    AppendToMacro('6200', macro='6260'),
    AppendToMacro('6200', macro='6211'),
    AppendToMacro('6200', macro='6231'),
    AppendToMacro('6200', password=MPW, command=SetSoftwareSwitch('0005', '1')),
    AppendToMacro('6200', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA81')),
    AppendToMacro('6200', password='DD', command=SendMessage(message=['9961', '1238', '0003', '0287', '1155', '0283', '1144', '1093'])),

    EraseMacro('6201'),
    CreateNewMacro('6201', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6201', macro='6241'),
    AppendToMacro('6201', macro='6251'),
    AppendToMacro('6201', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0003', '0255'])),

    EraseMacro('6202'),
    CreateNewMacro('6202', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6202', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0003', '0248'])),
    AppendToMacro('6202', password='DD', command=Pause(seconds=500)),
    AppendToMacro('6202', macro='6240'),
    AppendToMacro('6202', macro='6250'),

    EraseMacro('6210'),
    CreateNewMacro('6210', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6210', password='DD', command=SetSoftwareSwitch('0142', '0')),
    AppendToMacro('6210', password='DD', command=SetSoftwareSwitch('0241', '0')),
    AppendToMacro('6210', password='DD', command=SendMessage(message=['9712', '9993', '10', '9961', '1238', '0003', '0362', '1238', '0001', '0646', '0294', '0341', '0314'])),

    EraseMacro('6211'),
    CreateNewMacro('6211', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6211', password='DD', command=SetSoftwareSwitch('0142', '1')),
    AppendToMacro('6211', password='DD', command=SetSoftwareSwitch('0241', '1')),
    AppendToMacro('6211', password='DD', command=SendMessage(message=['9712', '9993', '10', '9961', '1238', '0003', '0362', '1238', '0001', '0646', '0294', '0341', '0315'])),

    EraseMacro('6212'),
    CreateNewMacro('6212', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6212', password='DD', command=SetSoftwareSwitch('0142', '0')),
    AppendToMacro('6212', password='DD', command=SetSoftwareSwitch('0241', '1')),
    AppendToMacro('6212', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0001', '0362', '0365', '0003', '1100', '1173'])),

    EraseMacro('6213'),
    CreateNewMacro('6213', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6213', password='DD', command=SelectPathAccessMode(receiver='1', transmitter='2', mode='1')),
    AppendToMacro('6213', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0362', '0365', '0003', '0243', '0314'])),

    EraseMacro('6214'),
    CreateNewMacro('6214', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6214', password='DD', command=SelectPathAccessMode(receiver='1', transmitter='2', mode='3')),
    AppendToMacro('6214', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0362', '0365', '0003', '0243', '0315'])),

    EraseMacro('6215'),
    CreateNewMacro('6215', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6215', password='DD', command=SetSoftwareSwitch('0251', '0')),
    AppendToMacro('6215', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0362', '0365', '0003', '0252', '1489', '0325', '0315'])),

    EraseMacro('6216'),
    CreateNewMacro('6216', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6216', password='DD', command=SetSoftwareSwitch('0251', '1')),
    AppendToMacro('6216', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0362', '0365', '0003', '0252', '1489', '0325', '0314'])),

    EraseMacro('6219'),
    CreateNewMacro('6219', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6219', password='DD', command=SetSoftwareSwitch('0271', '1')),
    AppendToMacro('6219', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0362', '0365', '0003', '1487', '0360', '1293'])),

    EraseMacro('6230'),
    CreateNewMacro('6230', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6230', password='DD', command=SetSoftwareSwitch('0243', '0')),
    AppendToMacro('6230', password='DD', command=SetSoftwareSwitch('0342', '0')),
    AppendToMacro('6230', password='DD', command=SendMessage(message=['9723', '9993', '10', '9961', '1238', '0005', '0362', '1238', '0003', '0646', '0294', '0341', '0314'])),

    EraseMacro('6231'),
    CreateNewMacro('6231', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6231', password='DD', command=SetSoftwareSwitch('0243', '1')),
    AppendToMacro('6231', password='DD', command=SetSoftwareSwitch('0342', '1')),
    AppendToMacro('6231', password='DD', command=SendMessage(message=['9723', '9993', '10', '9961', '1238', '0005', '0362', '1238', '0003', '0646', '0294', '0341', '0315'])),

    EraseMacro('6232'),
    CreateNewMacro('6232', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6232', password='DD', command=SetSoftwareSwitch('0243', '1')),
    AppendToMacro('6232', password='DD', command=SetSoftwareSwitch('0342', '0')),
    AppendToMacro('6232', password='DD', command=SendMessage(message=['9993', '10', '9961', '0339', '0005', '0362', '0365', '0003', '1100', '1173'])),

    EraseMacro('6233'),
    CreateNewMacro('6233', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6233', password='DD', command=SelectPathAccessMode(receiver='3', transmitter='2', mode='1')),
    AppendToMacro('6233', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0005', '0362', '0365', '0003', '0243', '0314'])),

    EraseMacro('6234'),
    CreateNewMacro('6234', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6234', password='DD', command=SelectPathAccessMode(receiver='2', transmitter='2', mode='3')),
    AppendToMacro('6234', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0005', '0362', '0365', '0003', '0243', '0315'])),

    EraseMacro('6235'),
    CreateNewMacro('6235', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6235', password='DD', command=SetSoftwareSwitch('0253', '0')),
    AppendToMacro('6235', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0005', '0362', '0365', '0003', '0252', '1489', '0325', '0315'])),

    EraseMacro('6236'),
    CreateNewMacro('6236', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6236', password='DD', command=SetSoftwareSwitch('0253', '1')),
    AppendToMacro('6236', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0005', '0362', '0365', '0003', '0252', '1489', '0325', '0314'])),

    EraseMacro('6239'),
    CreateNewMacro('6239', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6239', password='DD', command=SetSoftwareSwitch('0273', '1')),
    AppendToMacro('6239', password='DD', command=SendMessage(message=['9993', '10', '9960', '1238', '0005', '0362', '1238', '0003', '1487', '0360', '1293'])),

    EraseMacro('6240'),
    CreateNewMacro('6240', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6240', password='DD', command=SendMessage(message=['9960', '1238', '0003', '0365', '0248'])),
    AppendToMacro('6240', password='DD', command=Pause(seconds=500)),
    AppendToMacro('6240', password='DD', command=SetSoftwareSwitch('0212', '0')),
    AppendToMacro('6240', password='DD', command=SetSoftwareSwitch('0213', '0')),

    EraseMacro('6241'),
    CreateNewMacro('6241', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6241', password='DD', command=SetSoftwareSwitch('0212', '1')),
    AppendToMacro('6241', password='DD', command=SetSoftwareSwitch('0213', '0')),
    AppendToMacro('6241', password='DD', command=SendMessage(message=['9960', '1238', '0003', '0365', '0255'])),

    EraseMacro('6242'),
    CreateNewMacro('6242', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6242', password='DD', command=SendMessage(message=['9960', '1238', '0003', '0742', '0364', '0315'])),
    AppendToMacro('6242', password='DD', command=SetSoftwareSwitch('0212', '1')),
    AppendToMacro('6242', password='DD', command=SetSoftwareSwitch('0213', '1')),

    EraseMacro('6243'),
    CreateNewMacro('6243', password='99', command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6243', password='DD', command=SetSoftwareSwitch('0214', '1')),

    EraseMacro('6244'),
    CreateNewMacro('6244', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6244', password='DD', command=SetSoftwareSwitch('0215', '1')),

    EraseMacro('6250'),
    CreateNewMacro('6250', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6250', password='DD', command=SetSoftwareSwitch('0219', '0')),
    AppendToMacro('6250', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0003', '0314'])),

    EraseMacro('6251'),
    CreateNewMacro('6251', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6251', password='DD', command=SetSoftwareSwitch('0219', '1')),
    AppendToMacro('6251', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0003', '0315'])),

    EraseMacro('6253'),
    CreateNewMacro('6253', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6253', password='DD', command=SelectPathAccessMode(receiver='2', transmitter='2', mode='1')),
    AppendToMacro('6253', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0003', '0362', '0365', '0003', '0243', '0314'])),

    EraseMacro('6254'),
    CreateNewMacro('6254', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6254', password='DD', command=SelectPathAccessMode(receiver='2', transmitter='2', mode='3')),
    AppendToMacro('6254', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0003', '0362', '0365', '0003', '0243', '0315'])),

    EraseMacro('6255'),
    CreateNewMacro('6255', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6255', password='DD', command=SetSoftwareSwitch('0252', '0')),
    AppendToMacro('6255', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0003', '0362', '0365', '0003', '0252', '1489', '0325', '0315'])),

    EraseMacro('6256'),
    CreateNewMacro('6256', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6256', password='DD', command=SetSoftwareSwitch('0252', '1')),
    AppendToMacro('6256', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0003', '0362', '0365', '0003', '0252', '1489', '0325', '0314'])),

    EraseMacro('6259'),
    CreateNewMacro('6259', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6259', password='DD', command=SetSoftwareSwitch('0272', '1')),
    AppendToMacro('6259', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0003', '0362', '0365', '0003', '1487', '0360', '1293'])),

    EraseMacro('6290'),
    CreateNewMacro('6290', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6290', password='DD', command=SetSoftwareSwitch('0218', '0')),
    AppendToMacro('6290', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0003', '1040', '0397', '0314'])),

    EraseMacro('6291'),
    CreateNewMacro('6291', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6291', password='DD', command=SetSoftwareSwitch('0218', '1')),
    AppendToMacro('6291', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0003', '1040', '0397', '0315'])),

    EraseMacro('6292'),
    CreateNewMacro('6292', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6292', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0003', '1363', '0651', '0355', '1489'])),
    AppendToMacro('6292', password='DD', command=SendMessage(message=['9720', '9993', '10', '99', '00', '00', '01', '02', '03', '04', '05', '06', '07', '08', '09'])),

    EraseMacro('6293'),
    CreateNewMacro('6293', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6293', password='DD', command=SetDefaultMessageLevel(transmitter='1', message_type=MessageType.Single_Tone_Page, level=0)),
    AppendToMacro('6293', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0003', '1363', '0323', '1489'])),
    AppendToMacro('6293', password='DD', command=SendMessage(message=['9720', '9993', '10', '9920', '0165', '80'])),

    EraseMacro('6294'),
    CreateNewMacro('6294', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6294', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0003', '1363', '0252', '0355', '1489'])),
    AppendToMacro('6294', password='DD', command=SendMessage(message=['9720', '9993', '10', '9950', '5199', '05'])),
    SetTimerValue(resolution='0', port='3', timer='19', time_value=75),
    SetTimerValue(resolution='0', port='3', timer='03', time_value=100),
    SetTimerValue(resolution='0', port='3', timer='02', time_value=0),
    SetTimerValue(resolution='2', port='3', timer='06', time_value=450),
    SetTimerValue(resolution='0', port='3', timer='00', time_value=0),
    SetTimerValue(resolution='0', port='3', timer='01', time_value=0),
    SetTimerValue(resolution='2', port='3', timer='11', time_value=0),
    ControlCTCSSEncoder(transmitter='3', mode='0', reverse_burst='0'),
    SelectMessage('0300', message_contents=[]),
    SelectMessage('0301', message_contents=[]),
    SelectMessage('0302', message_contents=[]),
    SelectMessage('0309', message_contents=[]),
    SetEventTriggeredMacro(port='3', event_macro_number='08', macro_name='CA84'),
    SelectMessage('0310', message_contents=[]),
    SetEventTriggeredMacro(port='3', event_macro_number='09', macro_name='CA84'),
    SelectMessage('0311', message_contents=[]),
    SetEventTriggeredMacro(port='3', event_macro_number='10', macro_name='CA84'),
    SelectMessage('0303', message_contents=['9960', '0339', '0001', '1487']),
    SelectMessage('0306', message_contents=['9961', '0339', '0001', '0360', '1293', '0005', '0101']),
    SelectMessage('0304', message_contents=['9960', '0339', '0003', '1487']),
    SelectMessage('0307', message_contents=['9961', '0339', '0003', '0360', '1293', '0005', '0101']),
    SelectMessage('0305', message_contents=['9960', '0339', '0005', '1487']),
    SelectMessage('0308', message_contents=['9961', '0339', '0003', '0360', '1293', '0005', '0101']),

    EraseMacro('6300'),
    CreateNewMacro('6300', macro='6341'),
    AppendToMacro('6300', password=MPW, command=SetSoftwareSwitch('0005', '0')),
    AppendToMacro('6300', macro='6351'),
    AppendToMacro('6300', macro='6353'),
    AppendToMacro('6300', macro='6356'),
    AppendToMacro('6300', macro='6360'),
    AppendToMacro('6300', macro='6311'),
    AppendToMacro('6300', macro='6321'),
    AppendToMacro('6300', password=MPW, command=SetSoftwareSwitch('0005', '1')),
    AppendToMacro('6300', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA81', false_macro=None)),
    AppendToMacro('6300', password='DD', command=SendMessage(message=['9961', '1238', '0005', '0287', '1155', '0283', '1144', '1093'])),

    EraseMacro('6301'),
    CreateNewMacro('6301', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6301', macro='6341'),
    AppendToMacro('6301', macro='6351'),
    AppendToMacro('6301', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0005', '0255'])),

    EraseMacro('6302'),
    CreateNewMacro('6302', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6302', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0005', '0248'])),
    AppendToMacro('6302', password='DD', command=Pause(seconds=500)),
    AppendToMacro('6302', macro='6340'),
    AppendToMacro('6302', macro='6350'),

    EraseMacro('6310'),
    CreateNewMacro('6310', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6310', password='DD', command=SetSoftwareSwitch('0143', '0')),
    AppendToMacro('6310', password='DD', command=SetSoftwareSwitch('0341', '0')),
    AppendToMacro('6310', password='DD', command=SendMessage(message=['9713', '9993', '10', '9961', '1238', '0005', '0362', '1238', '0001', '0646', '0294', '0341', '0314'])),

    EraseMacro('6311'),
    CreateNewMacro('6311', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6311', password='DD', command=SetSoftwareSwitch('0143', '1')),
    AppendToMacro('6311', password='DD', command=SetSoftwareSwitch('0341', '1')),
    AppendToMacro('6311', password='DD', command=SendMessage(message=['9713', '9993', '10', '9961', '1238', '0005', '0362', '1238', '0001', '0646', '0294', '0341', '0315'])),

    EraseMacro('6312'),
    CreateNewMacro('6312', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6312', password='DD', command=SetSoftwareSwitch('0143', '0')),
    AppendToMacro('6312', password='DD', command=SetSoftwareSwitch('0341', '1')),
    AppendToMacro('6312', password='DD', command=SendMessage(message=['9993', '10', '9961', '0339', '0001', '0362', '0365', '0005', '1100', '1173'])),

    EraseMacro('6313'),
    CreateNewMacro('6313', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6313', password='DD', command=SelectPathAccessMode(receiver='1', transmitter='3', mode='1')),
    AppendToMacro('6313', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0362', '0365', '0005', '0243', '0314'])),

    EraseMacro('6314'),
    CreateNewMacro('6314', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6314', password='DD', command=SelectPathAccessMode(receiver='1', transmitter='3', mode='3')),
    AppendToMacro('6313', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0362', '0365', '0005', '0243', '0315'])),

    EraseMacro('6315'),
    CreateNewMacro('6315', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6315', password='DD', command=SetSoftwareSwitch('0351', '0')),
    AppendToMacro('6315', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0362', '0365', '0005', '0252', '1489', '0325', '0315'])),

    EraseMacro('6316'),
    CreateNewMacro('6316', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6316', password='DD', command=SetSoftwareSwitch('0351', '1')),
    AppendToMacro('6315', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0362', '0365', '0005', '0252', '1489', '0325', '0315'])),

    EraseMacro('6319'),
    CreateNewMacro('6319', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6319', password='DD', command=SetSoftwareSwitch('0371', '1')),
    AppendToMacro('6319', password='DD', command=SendMessage(message=['9993', '10', '9960', '1238', '0001', '0362', '1238', '0005', '1487', '0360', '1293'])),

    EraseMacro('6320'),
    CreateNewMacro('6320', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6320', password='DD', command=SetSoftwareSwitch('0243', '0')),
    AppendToMacro('6320', password='DD', command=SetSoftwareSwitch('0342', '0')),
    AppendToMacro('6320', password='DD', command=SendMessage(message=['9723', '9993', '10', '9961', '1238', '0005', '0362', '1238', '0003', '0646', '0294', '0341', '0314'])),

    EraseMacro('6321'),
    CreateNewMacro('6321', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6321', password='DD', command=SetSoftwareSwitch('0243', '1')),
    AppendToMacro('6321', password='DD', command=SetSoftwareSwitch('0342', '1')),
    AppendToMacro('6321', password='DD', command=SendMessage(message=['9723', '9993', '10', '9961', '1238', '0005', '0362', '1238', '0003', '0646', '0294', '0341', '0315'])),

    EraseMacro('6322'),
    CreateNewMacro('6322', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6322', password='DD', command=SetSoftwareSwitch('0243', '1')),
    AppendToMacro('6322', password='DD', command=SetSoftwareSwitch('0342', '0')),
    AppendToMacro('6322', password='DD', command=SendMessage(message=['9993', '10', '9961', '0339', '0003', '0362', '0365', '0005', '1100', '1173'])),

    EraseMacro('6323'),
    CreateNewMacro('6323', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6323', password='DD', command=SelectPathAccessMode(receiver='2', transmitter='3', mode='1')),
    AppendToMacro('6323', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0003', '0362', '0365', '0005', '0243', '0314'])),

    EraseMacro('6324'),
    CreateNewMacro('6324', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6324', password='DD', command=SelectPathAccessMode(receiver='2', transmitter='3', mode='3')),
    AppendToMacro('6323', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0003', '0362', '0365', '0005', '0243', '0315'])),

    EraseMacro('6325'),
    CreateNewMacro('6325', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6325', password='DD', command=SetSoftwareSwitch('0352', '0')),
    AppendToMacro('6325', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0362', '0365', '0005', '0252', '1489', '0325', '0315'])),

    EraseMacro('6326'),
    CreateNewMacro('6326', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6326', password='DD', command=SetSoftwareSwitch('0352', '1')),
    AppendToMacro('6325', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0001', '0362', '0365', '0005', '0252', '1489', '0325', '0314'])),

    EraseMacro('6329'),
    CreateNewMacro('6329', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6329', password='DD', command=SetSoftwareSwitch('0372', '1')),
    AppendToMacro('6329', password='DD', command=SendMessage(message=['9993', '10', '9960', '1238', '0003', '0362', '1238', '0003', '1487', '0360', '1293'])),

    EraseMacro('6340'),
    CreateNewMacro('6340', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6340', password='DD', command=SendMessage(message=['9960', '1238', '0005', '0364', '0248'])),
    AppendToMacro('6340', password='DD', command=Pause(seconds=500)),
    AppendToMacro('6340', password='DD', command=SetSoftwareSwitch('0312', '0')),
    AppendToMacro('6340', password='DD', command=SetSoftwareSwitch('0313', '0')),

    EraseMacro('6341'),
    CreateNewMacro('6341', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6341', password='DD', command=SetSoftwareSwitch('0312', '1')),
    AppendToMacro('6341', password='DD', command=SetSoftwareSwitch('0313', '0')),
    AppendToMacro('6341', password='DD', command=SendMessage(message=['9960', '1238', '0005', '0364', '0255'])),

    EraseMacro('6342'),
    CreateNewMacro('6342', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6342', password='DD', command=SendMessage(message=['9960', '1238', '0005', '0742', '0364', '0315'])),
    AppendToMacro('6342', password='DD', command=SetSoftwareSwitch('0312', '1')),
    AppendToMacro('6342', password='DD', command=SetSoftwareSwitch('0313', '1')),

    EraseMacro('6343'),
    CreateNewMacro('6343', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6343', password='DD', command=SetSoftwareSwitch('0314', '1')),

    EraseMacro('6350'),
    CreateNewMacro('6350', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6350', password='DD', command=SetSoftwareSwitch('0319', '0')),
    AppendToMacro('6350', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0005', '0314'])),

    EraseMacro('6351'),
    CreateNewMacro('6351', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6351', password='DD', command=SetSoftwareSwitch('0319', '1')),
    AppendToMacro('6351', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0005', '0315'])),

    EraseMacro('6353'),
    CreateNewMacro('6353', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6353', password='DD', command=SelectPathAccessMode(receiver='3', transmitter='3', mode='1')),
    AppendToMacro('6353', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0005', '0362', '0365', '0005', '0243', '0314'])),

    EraseMacro('6354'),
    CreateNewMacro('6354', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6354', password='DD', command=SelectPathAccessMode(receiver='3', transmitter='3', mode='3')),
    AppendToMacro('6254', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0005', '0362', '0365', '0005', '0243', '0315'])),

    EraseMacro('6355'),
    CreateNewMacro('6355', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6355', password='DD', command=SetSoftwareSwitch('0353', '0')),
    AppendToMacro('6355', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0005', '0362', '0365', '0005', '0252', '1489', '0325', '0315'])),

    EraseMacro('6356'),
    CreateNewMacro('6356', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6356', password='DD', command=SetSoftwareSwitch('0353', '1')),
    AppendToMacro('6356', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0005', '0362', '0365', '0005', '0252', '1489', '0325', '0314'])),

    EraseMacro('6359'),
    CreateNewMacro('6359', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6359', password='DD', command=SetSoftwareSwitch('0373', '1')),
    AppendToMacro('6359', password='DD', command=SendMessage(message=['9993', '10', '9960', '0339', '0005', '0362', '0365', '0005', '1487', '0360', '1293'])),

    EraseMacro('6390'),
    CreateNewMacro('6390', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6390', password='DD', command=SetSoftwareSwitch('0318', '0')),
    AppendToMacro('6390', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0005', '1040', '0397', '0314'])),

    EraseMacro('6391'),
    CreateNewMacro('6391', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6391', password='DD', command=SetSoftwareSwitch('0318', '1')),
    AppendToMacro('6391', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0005', '1040', '0397', '0315'])),

    EraseMacro('6392'),
    CreateNewMacro('6392', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6392', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0005', '1363', '0651', '0355', '1489'])),
    AppendToMacro('6392', password='DD', command=SendMessage(message=['9730', '9993', '10', '99', '00', '00', '01', '02', '03', '04', '05', '06', '07', '08', '09'])),

    EraseMacro('6393'),
    CreateNewMacro('6393', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6393', password='DD', command=SetDefaultMessageLevel(transmitter='1', message_type=MessageType.Single_Tone_Page, level=0)),
    AppendToMacro('6393', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0005', '1363', '0323', '1489'])),
    AppendToMacro('6393', password='DD', command=SendMessage(message=['9730', '9993', '10', '9920', '0165', '80'])),

    EraseMacro('6394'),
    CreateNewMacro('6394', password=MPW, command=IfThenElse(value_type=ValueType.software_switch, value='0004', true_macro='CA80', false_macro='CA79')),
    AppendToMacro('6394', password='DD', command=SendMessage(message=['9993', '10', '9961', '1238', '0005', '1363', '0252', '0355', '1489'])),
    AppendToMacro('6394', password='DD', command=SendMessage(message=['9730', '9993', '10', '9950', '5199', '05'])),
    SetSoftwareSwitch('0003', '0'),
]

with open('cmd.txt', 'w') as f:
    for command in commands:
        f.write(MPW + ' ' + command.to_dtmf().strip() + ' *\n')
