# Malwoverview

      Copyright (C)  2018-2020 Alexandre Borges <alexandreborges at blackstormsecurity dot com>

      This program is free software: you can redistribute it and/or modify
      it under the terms of the GNU General Public License as published by
      the Free Software Foundation, either version 3 of the License, or
      (at your option) any later version.

      This program is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
      GNU General Public License for more details.

      See GNU Public License on <http://www.gnu.org/licenses/>.


# Current Version: 4.0.3 

     Important note:  Malwoverview does NOT submit samples to Virus Total or Hybrid Analysis by 
     default. It submits only hashes, so respecting Non-Disclosure Agreements (NDAs). Nonetheless, 
     if you use the "-V" (uppercase), "-A" (uppercase) or "-P" (uppercase), so Malwoverview SUBMITS your 
     malware sample to Virus Total, Hybrid Analysis and Polyswarm, respectively. Additionally, options 
     "-Y" and "-T" also sent the Android package from Android device to Hybrid-Analysis and Virus 
     Total, respectively.  


# ABOUT

Malwoverview.py is a simple tool to perform an initial and quick triage of malware samples, URLs and hashes. 
Additionally, Malwoverview is able to show some threat intelligence information.   

This tool aims to : 

1. Determine similar executable malware samples (PE/PE+) according to the import table (imphash) and group 
   them by different colors (pay attention to the second column from output). Thus, colors matter!
2. Show hash information on Virus Total, Hybrid Analysis, Malshare, Polyswarm, URLhaus, Alien Vault, i
   Malpedia and ThreatCrowd engines. 
3. Determining whether the malware samples contain overlay and, if you want, extract it. 
4. Check suspect files on Virus Total, Hybrid Analysis and Polyswarm.
5. Check URLs on Virus Total, Malshare, Polyswarm, URLhaus engines and Alien Vault. 
6. Download malware samples from Hybrid Analysis, Malshare, HausURL, Polyswarm and Malpedia engines.
7. Submit malware samples to VirusTotal, Hybrid Analysis and Polyswarm.
8. List last suspected URLs from URLHaus.
9. List last payloads from URLHaus. 
10. Search for specific payloads on the Malshare.
11. Search for similar payloads (PE32/PE32+) on Polyswarm engine.
12. Classify all files in a directory searching information on Virus Total and Hybrid Analysis. 
13. Make reports about a suspect domain using different engines such as VirusTotal, Malpedia and 
    ThreatCrowd. 
14. Check APK packages directly from Android devices against Hybrid Analysis and Virus Total. 
15. Submit APK packages directly from Android devices to Hybrid Analysis and Virus Total. 
16. Show URLs related to an user provided tag from URLHaus.
17. Show payloads related to a tag (signature) from URLHaus.
18. Show information about an IP address from Virus Total, Alien Vault, Malpedia and ThreatCrowd.
19. Show IP address, domain and URL information from Polyswarm. 
21. Perform meta-search on Polyswarm Network using several criteria: imphash, IPv4, domain, URL and
    malware family. 
22. Gather threat hunting information from AlienVault using different criteria. 
23. Gather threat hunting information from Malpedia using different criteria. 
24. Gather threat hunting information from ThreatCrowd using different criteria. 

# CONTRIBUTORS:

      Alexandre Borges (project owner)
      Corey Forman (https://github.com/digitalsleuth)

# INSTALLATION 

This tool has been tested on Ubuntu, Kali Linux 2020, REMnux, Windows 8.1 and 10. Malwoverview 
can be installed by executing the following command:

      pip3.8 install git+https://github.com/alexandreborges/malwoverview (preferred method) 
      or...
      python -m pip install -U malwoverview
      or...
      git clone https://github.com/alexandreborges/malwoverview


To use Malwoverview you should insert VirusTotal, Hybrid Analysis, URLHaus, Malshare, Polyswarm,
Alien Vault and Malpedia APIs into the .malwapi.conf configuration file (the default one at the 
home directory -- if the file doesn't exist, so you should create it) or you could create a 
custom configuration file and indicate it by using the -c option. 

A special note about the Alien Vault: it is necessary to subscribe to pulses on Alien Vault 
website before using -n 1 option.  

The .malwapi.conf configuration file (from the the home directory) has the following format: 

      [VIRUSTOTAL]
      VTAPI = 

      [HYBRID-ANALYSIS]
      HAAPI = 

      [MALSHARE]
      MALSHAREAPI = 

      [HAUSSUBMIT]
      HAUSSUBMITAPI = 

      [POLYSWARM]
      POLYAPI = 

      [ALIENVAULT]
      ALIENAPI = 

      [MALPEDIA]
      MALPEDIAAPI =

In Windows systems, when the package is installed using pip, the suggestion is to create the 
.malwapi.conf in either C:\Users\<username> directory.  Additionally, you don't need to specify 
"-w 1" option while using malwoverview.py on Windows anymore. 

To check the installation, execute:

       malwoverview.py --help
       
Further information is available on: 

       (PYPI.org repository) https://pypi.org/project/malwoverview/
       (Github) https://github.com/alexandreborges/malwoverview

If you want to perform the manual steps (usually, it is not necessary), so few steps will be necessary:

## Kali Linux (manual steps)

1. Python version 3.8 or later (Only Python 3.x !!! It does NOT work using Python 2.7) 

       $ apt-get install python3.8  (for example)

2. Python-magic.  

      To install python-magic package you can execute the following command:

       $ pip3.8 install python-magic

      Or compiling it from the github repository:

       $ git clone https://github.com/ahupp/python-magic
       $ cd python-magic/
       $ python3.8 setup.py build
       $ python3.8 setup.py install

      As there are serious problems about existing two versions of python-magic package, my 
      recommendation is to install it from github (second procedure above) and copy the magic.py 
      file to the SAME directory of malwoverview tool. 
      
3. Install several Python packages: 

       $ pip3.8 install -r requirements.txt

       OR

       $ pip3.8 install -U pefile
       $ pip3.8 install -U colorama
       $ pip3.8 install -U simplejson
       $ pip3.8 install -U python-magic
       $ pip3.8 install -U requests
       $ pip3.8 install -U validators
       $ pip3.8 install -U geocoder
       $ pip3.8 install -U polyswarm-api
       $ pip3.8 install -U pathlib
       $ pip3.8 install -U configparser
       
4. To check an Android mobile you need to install the "adb" program by executing the following command:

       # apt get install adb

   PS: before trying Android's options, check:

       * If the adb program is listed in the PATH environment variable.
       * If the system has authorized access to the device by using "adb devices -l"

5. Finally, you can install Malwoverview using one of the following methods:

         pip3.8 install git+https://github.com/alexandreborges/malwoverview (preferred method) 

         or...

         python -m pip install -U malwoverview

         or...

         git clone https://github.com/alexandreborges/malwoverview


## Windows (manual steps)

1. Install the Python version 3.8.x or later from https://www.python.org/downloads/windows/ 

2. Python-magic. 

      To install python-magic package you can execute the following command:

       C:\> python.exe -m pip install python-magic

      Or compiling it from the github repository:

       C:\> git clone https://github.com/ahupp/python-magic
       C:\> cd python-magic/
       C:\> python.exe setup.py build
       C:\> python.exe setup.py install

3. Install several Python packages: 

       C:\> python.exe -m pip install -r requirements.txt

       OR: 

       C:\> python.exe -m pip install -U pefile
       C:\> python.exe -m pip install -U colorama
       C:\> python.exe -m pip install -U simplejson
       C:\> python.exe -m pip install -U python-magic
       C:\> python.exe -m pip install -U requests
       C:\> python.exe -m pip install -U validators
       C:\> python.exe -m pip install -U geocoder
       C:\> python.exe -m pip install -U polyswarm-api
       C:\> python.exe -m pip install -U pathlib
       C:\> python.exe -m pip install -U configparser
       C:\> python.exe -m pip install -U python-magic-bin

4. To check an Android mobile you need to install the "adb" program by:

       * Downloading and installing the Android Studio from: https://developer.android.com/
         studio#downloads (Recommended)
       * Downloading it from https://dl.google.com/android/repository/platform-tools-latest-windows.zip

   PS: before trying Android's options, check:

       * If the adb program is listed in the PATH environment variable.
       * If the system has authorized access to the device by using "adb devices -l"

5. Finally, you can install Malwoverview using one of the following methods:

         pip3.8 install git+https://github.com/alexandreborges/malwoverview (preferred method)

         or...

         python -m pip install -U malwoverview

         or...

         git clone https://github.com/alexandreborges/malwoverview
  
       
# USAGE

To use the malwoverview, execute the command as shown below:

      root@ubuntu19:~/malwoverview# python3.8 malwoverview.py  | more

      usage: python malwoverview.py -c <API configuration file> -d <directory> -f <fullpath> 
      -b <0|1> -v <0|1|2|3> -a <0|1|2|3|4|5> -x <0|1> -w <0|1> -u <url> -H <hash file> -V <filename>
      -D <0|1> -e<0|1|2|3|4> -A <filename> -g <job_id> -r <domain> -t <0|1> -l <1-14> -L <hash> 
      -U <url> -S <url> -z <tags> -K <0|1|2> -j <hash> -J <hash> -P <filename> -R <PE file, IP address, 
      domain or URL> -G <0|1|2|3|4> -y <0|1|2|3> -Y <file name> -Y <file name> -T <file name> -W <tag> 
      -k <signature> -I <ip address> -n <1|2|3|4|5> -N <argument> -M <1-8> -m <argument> -Q <1-5> 
      -q <argument>

Malwoverview is a malware triage tool written by Alexandre Borges.

optional arguments:

      -h, --help        Show this help message and exit
      -c CONFIG FILE, --config CONFIG FILE
                        Use a custom config file to specify API's
      -d DIRECTORY, --directory DIRECTORY
                        Specifies the directory containing malware samples.
      -f FILENAME, --filename FILENAME
                        Specifies a full path to a malware sample. It returns general information 
                        about the file (any filetype)
      -b BACKGROUND, --background BACKGROUND
                        Adapts the output colors to a white terminal. The default is black terminal
      -x OVERLAY, --overlay OVERLAY
                        Extracts the overlay (it is used with -f option).
      -v VIRUSTOTAL, --virustotal VIRUSTOTAL
                        If using "-v 1", so it queries the Virus Total database for positives and 
                        totals. If "v 2" (which can be used only together with -f option), so it 
                        shows antivirus reports from the main players. If "v 3", so the binary's IAT 
                        and EAT are also shown. Remember: you need to edit the .malwapi.conf and insert 
                        your VT API.
      -a HYBRID_ANALYSIS, --hybrid HYBRID_ANALYSIS
                        Queries the Hybrid Analysis database for getting a general report. Possible 
                        values are: 1: Windows 7 32-bit; 2: Windows 7 32-bit (HWP Support); 3: 
                        Windows 64-bit; 4: Android; 5: Linux 64-bit. Remember: you need to edit the
                        .malwapi.conf and insert your HA API and secret.
      -u URL_VT, --vturl URL_VT
                        SUBMITS a URL to the Virus Total scanning.
      -I IP_VT, --ipaddrvt IP_VT
                        This option checks an IP address on Virus Total.
      -r URL_DOMAIN, --urldomain URL_DOMAIN
                        This option gets a domain's report from Virus Total.
      -H FILE_HASH, --hash FILE_HASH
                        This option specifies the hash to be checked on Virus Total and Hybrid Analysis. 
                        For the Hybrid Analysis report you must use it with the -e option.
      -V FILENAME_VT, --vtsubmit FILENAME_VT
                        Submits a file(up to 32MB) for Virus Total scanning and gets the report. Attention: 
                        use forward slash to specify the target file even on Windows systems. Furthermore, 
                        the minimum waiting time is set up in 90 seconds because the Virus Total waiting 
                        queue. If an error occurs, so wait few minutes and try to access the report by 
                        using -f option.
      -A SUBMIT_HA, --submitha SUBMIT_HA
                        Submits a file(up to 32MB) to be scanned by the Hybrid Analysis engine. Use the 
                        -e option to specify the best environment to run the suspicious file.
      -g HA_STATUS, --hastatus HA_STATUS
                        Checks the report's status of submitted samples to Hybrid Analysis engine by 
                        providing the job ID. Possible returned status values are: IN_QUEUE, SUCCESS,
                        ERROR, IN_PROGRESS and PARTIAL_SUCCESS.
      -D DOWNLOAD, --download DOWNLOAD
                        Downloads the sample from Hybrid Analysis, Malshare and Polyswarm. Options i
                        -H or -L (Hybrid Analysis and Malshare, respectively) must be specified as well 
                        -O option for Polyswarm engine.
      -e HA_ENVIRONMENT, --haenv HA_ENVIRONMENT
                        This option specifies the used environment to be used to test the samlple on 
                        Hybrid Analysis: <0> Windows 7 32-bits; <1> Windows 7 32-bits (with HWP Support); 
                        <2> Windows 7 64-bits; <3> Android; <4> Linux 64-bits environment. This option 
                        is used together either -H option or the -A option.
      -t MULTITHREAD, --thread MULTITHREAD
                        (optional) This option has several different meanings according to chosen the 
                        value. Possible values: <1>: This value is used to force multithreads on Linux 
                        whether: the -d option is specified AND you have a PAID Virus Total API or you
                        are NOT checking the VT while using the -d option. PS1: using this option causes 
                        Imphashes not to be grouped anymore; PS2: it also works on Windows, but there is 
                        not gain in performance; <2>: This value should be used with -d option in
                        two scenarios: 1) either including the "-v 1" option (Virus Total -- you'll see 
                        a complete VT response whether you have the private API) for a multithread searching
                        and reduced output; 2) or including the -a option (Hybrid Analysis) for a multithread 
                        searching to get a complete and amazing output. If you are using the -a option, so 
                        you should pickup the right number represening the testing environment to adjust the 
                        output to your sample types. PS1: certainly, if you have a directory holding 
                        many malware samples, so you will want to test this option with -a option; PS2: it 
                        also works on Windows, but there is not gain in performance; <3>: You should use 
                        this value with -v option if you have a public Virus Total API. It forces a one 
                        minute wait every 4 malware samples, but allows obtaining a complete evaluation of 
                        the malware repository.
      -l MALSHARE_HASHES, --malsharelist MALSHARE_HASHES
                        This option shows hashes of a specific type from the last 24 hours from Malshare 
                        repository. Possible values are: 1: PE32 (default) ; 2: Dalvik ; 3: ELF ; 4: HTML ;
                        5: ASCII ; 6: PHP ; 7: Java ; 8: RAR ; 9: Zip ; 10: UTF-8 ; 11: MS-DOS ; 12: data ; 
                        13: PDF ; 14: Composite(OLE). You need to insert your Malshare API into the 
                        .malwapi.conf file.
      -L MALSHARE_HASH_SEARCH, --malsharehash MALSHARE_HASH_SEARCH
                        Searches for the provided hash on the Malshare repository. You need to insert your 
                        Malshare API into the .malwapi.conf file. PS: sometimes the Malshare website is 
                        unavailable, so should check the website availability if you get some error message.
      -K HAUS_PAYLOAD_URL, --haus_payloadbatch HAUS_PAYLOAD_URL
                        THis option has few possible values: <1> Retrieves a list of downloadable links of 
                        recent PAYLOADS (last 3 days, limited to 1000 entries) from URLHaus website; <2>: 
                        Retrieves a list of recent URLs (last 3 days, limited to 1000 entries) from URLHaus
                        website. Take care: each link take you to download a passworless zip file containing 
                        a malware, so your AV can generate alerts!
      -U URL_HAUS_QUERY, --haus_query URL_HAUS_QUERY
                        Queries a URL on the URLHaus website.
      -j HAUS_HASH, --haus_hash HAUS_HASH
                        Queries information about a provided payload's hash (md5 or sha256) on the URLHaus 
                        website.
      -S URL_HAUS_SUB, --haus_submission URL_HAUS_SUB
                        Submits a URL used to distribute malware (executable, script, document) to the 
                        URLHaus website. Pay attention: Any other submission will be ignored/deleted from 
                        URLhaus. You have to register your URLHaus API into the .malwapi.conf file.
      -z [HAUSTAG [HAUSTAG ...]], --haustag [HAUSTAG [HAUSTAG ...]]
                        Associates tags (separated by spaces) to the specified URL. Please, only upper case, 
                        lower case, '-' and '.' are allowed. This parameter is optional, which could be used 
                        with the -S option.
      -W [HAUSTAGSEARCH [HAUSTAGSEARCH ...]], --haustagsearch [HAUSTAGSEARCH [HAUSTAGSEARCH ...]]
                        This option is for searching malicious URLs by tag on URLhaus. Tags are case-senstive 
                        and only upper case, lower case, '-' and '.' are allowed.
      -k [HAUSSIGSEARCH [HAUSSIGSEARCH ...]], --haussigsearch [HAUSSIGSEARCH [HAUSSIGSEARCH ...]]
                        This option is for searching malicious payload by tag on URLhaus. Tags are 
                        case-sensitive and only upper case, lower case, '-' and '.' are allowed.
      -J HAUS_DOWNLOAD, --haus_download HAUS_DOWNLOAD
                        Downloads a malware sample (if it is available) from the URLHaus repository. It is 
                        necessary to provide the SHA256 hash.
      -P POLYSWARMFILE, --polyswarm_scan POLYSWARMFILE
                        (Only for Linux) Submits a sample to Polyswarm engine and performs a file scan.
      -O POLYSWARMHASH, --polyswarm_hash POLYSWARMHASH
                        (Only for Linux) Performs a hash scanning using the Polyswarm engine. Optionally, 
                        you can specify -D option to download the sample. Take care: Polyswarm enforces a 
                        restriction to number of downloaded samples in 20/month.
      -R POLYSWARMMETA, --polyswarm_meta POLYSWARMMETA
                        (Only for Linux) Provides the argument value for searches on Polyswarm engine through 
                        imphash (the PE file must be provided), ipv4, domain, URL and family. This argument 
                        must be used with -G option, so check it, please. Pay attention: you should check your 
                        metadata search limit on your Polyswarm account because once you have got the limit,
                        so you will got an error.
      -G METATYPE, --metatype METATYPE
                        (Only for Linux) This parameter specifies search type for arguments provided by
                        -R option (above) while searching on Polyswarm engine. Thus, the following values are 
                        valid -- 0: PE Executable (look for samples with the same ImpHash); 1: IP Address ; 
                        2: Domain ; 3. URL; 4. Family
      -y ANDROID_HA, --androidha ANDROID_HA
                        This option has multiple options: <1>: Check all third-party APK packages from the 
                        USB-connected Android device against Hybrid Analysis using multithreads. The Android 
                        device does not need to be rooted and the system does need to
                        have the adb tool in the PATH environment variable; <2>: Check all third-party APK 
                        packages from the USB-connected
                        Android device against VirusTotal using Public API (slower because of 60 seconds delay 
                        for each 4 hashes). The Android device does not need to be rooted and the system does 
                        need to have adb tool in the PATH environment variable; <3>: Check all third-party 
                        APK packages from the USB-connected Android device against VirusTotal using 
                        multithreads (only for Private Virus API). The Android device does not need to be 
                        rooted and the system needs to have adb tool in the PATH environment variable.
      -Y ANDROID_SEND_HA, --androidsendha ANDROID_SEND_HA
                        Sends an third-party APK package from your USB-connected Android device to Hybrid 
                        Analysis. The Android device does not need to be rooted and the system needs to have 
                        adb tool in the PATH environment variable.
      -T ANDROID_SEND_VT, --androidsendvt ANDROID_SEND_VT
                        Sends an third-party APK package from your USB-connected Android device to Virus 
                        Total. The Android device does not need be rooted and the system needis to have the 
                        adb tool in the PATH environment variable.
      -n ALIENVAULT, --alienvault ALIENVAULT
                        Checks multiple information from AlienVault. The possible values are: 1: Get the 
                        subscribed pulses ; 2: Get information about an IP address; 3: Get information about 
                        a domain; 4: Get information about a hash; 5: Get information about a URL
      -N ALIENVAULT_ARGS, --alienvaultargs ALIENVAULT_ARGS
                        Provides argument to AlienVault -n option.The allowed values are: 1, 2, 3, 4, 5.
      -M MALPEDIA, --malpedia MALPEDIA
                        This option is related to MALPEDIA and presents different meanings depending on the 
                        chosen value. Thus, 1: List meta information for all families ; 2: List all actors 
                        ID ; 3: List all available payloads organized by family from Malpedia; 4: Get meta 
                        information from an specific actor, so it is necessary to use the -m option. 
                        Additionally, try to confirm the correct actor ID by executing malwoverview with 
                        option -M 3; 5: List all families IDs; 6: Get meta information from an specific 
                        family, so it is necessary to use the -m option. Additionally, try to confirm the 
                        correct family ID by executing malwoverview with option -M 5; 7: Get a malware 
                        sample from malpedia (zip format -- password: infected). It is necessary to specify 
                        the requested hash by using -m option; 8: Get a zip file containing Yara rules for 
                        a specific family (get the possible families using -M 5), which must be specified 
                        by using -m option.
      -m MALPEDIAARG, --malpediarg MALPEDIAARG
                        This option provides an argument to the -M option, which is related to MALPEDIA.
      -Q THREATCROWD, --threatcrowd THREATCROWD
                        Checks multiple information from ThreatCrowd. The possible values are: 1: Get 
                        information about the provided e-mail ;
                        2: Get information about an IP address; 3: Get information about a domain; 4: Get 
                        information about a provided MD5 hash; 5: Get information about a specific malware 
                        family.
      -q THREATCROWDARG, --threatcrowdarg THREATCROWDARG
                        This option provides an argument to the -Q option, which is related to THREATCROWD.

      Remember that public VT API only allows 4 searches per second (as shown at the image above). Therefore,
      if you are willing to wait some minutes, so you can use the -p option, which forces a one minute wait 
      every 4 malware samples, but allows obtaining a complete evaluation of the repository.


      * ATTENTION 1: if the directory contains many malware samples while using -d option, so malwoverview.py
                     could take some time. Nonetheless, you can use the new -t option (multithreading) to
                     speed-up things. :)
         
      ** ATTENTION 2: All engines enforces quota of submission and/or verification per day and/or month. 
                      Take care!
       
      *** ATTENTION 3: Some options searching on Hybrid Analysis strongly depend of the "-e" option, which 
                       specifies the environment. Therefore, to check an Android sample (for example) it is 
                       necessary to use the right environment (-e 3 for Android).


## Examples:

      python3.8 malwoverview.py -d /root/malware/misc/
      python3.8 malwoverview.py -d /root/malware/misc -t 1
      python3.8 malwoverview.py -d /root/malware/misc -v 1 -t 3
      python3.8 malwoverview.py -d /root/malware/misc -v 1 -t 1
      python3.8 malwoverview.py -d /root/malware/misc -a 1 -t 2
      python3.8 malwoverview.py -f /root/malware/misc/8a87a1261603af4d976faa57e49ebdd8fd8317e9dd13bd36ff25
                                   99d1031f53ce -v 2
      python3.8 malwoverview.py -f /root/malware/misc/806fc33650b7ec35dd01a06be3037674ae3cc0db6ba1e3f690ee
                                   9ba9403c0627 -a 1 -v 1
      python3.8 malwoverview.py -f /root/malware/misc/8a87a1261603af4d976faa57e49ebdd8fd8317e9dd13bd36ff25
                                   99d1031f53ce -v 3
      python3.8 malwoverview.py -f /root/malware/misc/blackstorm.php -v 2 -x 
      python3.8 malwoverview.py -u http://mobiletech.net/images/138907/8g7c645373370255099hf4at12buy2lgrdeqo/
      python3.8 malwoverview.py -r xurl.es
      python3.8 malwoverview.py -H 9ce861b93e7ddeebec8ed052450fc136162fb3239c502aab8fa9bc8962572457
      python3.8 malwoverview.py -H 893339624602c7b3a6f481aed9509b53e4e995d6771c72d726ba5a6b319608a7 -e 1
      python3.8 malwoverview.py -d /root/malware/linux/ -a 5
      python3.8 malwoverview.py -d /root/malware/android/ -a 4
      python3.8 malwoverview.py -d /root/malware/android/ -v 1 -t 3
      python3.8 malwoverview.py -d /root/malware/android/ -a 4 -t 2
      python3.8 malwoverview.py -V /root/malware/misc/malware999
      python3.8 malwoverview.py -A /root/malware/android/NubankConvidado.apk -e 3
      python3.8 malwoverview.py -g 5f2e727f70fa896603576725
      python3.8 malwoverview.py -A /root/malware/windows/806fc33650b7ec35dd01a06be3037674ae3cc0db6ba1e3f690
                                   ee9ba9403c0627
      python3.8 malwoverview.py -l 1
      python3.8 malwoverview.py -l 6
      python3.8 malwoverview.py -l 4
      python3.8 malwoverview.py -L bc9d356f8d08396d620d249b8f34a664c9397467b1a6033013c788df734f8bda
      python3.8 malwoverview.py -K 1
      python3.8 malwoverview.py -K 2
      python3.8 malwoverview.py -U http://pusatppm.poltekkesbandung.com/wp-admin/report/b17892056589733xcz
                                   cjkjvqctpr9v9sm/ 
      python3.8 malwoverview.py -J 9e7d263c3c9f155229a7d6fb29dfa4b62bfec31ed0d3bf4cc2dc60ffd9fd6d0e
      python3.8 malwoverview.py -S http://jamogames.com/templates/JLHk/
      python3.8 malwoverview.py -S http://pusatppm.poltekkesbandung.com/wp-admin/report/b17892056589733xc
                                   zcjkjvqctpr9v9sm/
      python3.8 malwoverview.py -P 9e7d263c3c9f155229a7d6fb29dfa4b62bfec31ed0d3bf4cc2dc60ffd9fd6d0e
      python malwoverview.py -O f3ebeeeba13c82daef9731a5f3e8dbe535e963f83e531918ba1a8904b094d3b8
      python malwoverview.py -R /root/malware/windows/Scarab_Ransomware -G 0
      python./malwoverview.py -R 164.132.92.180 -G 1
      python3.8 malwoverview.py -R sndoffo79.ddns.net -G 2
      python3.8 malwoverview.py -R http://0uso87.com/bolb/jaent.php?l=liut1.cab -G 3
      python3.8 malwoverview.py -R *Trickbot* -G 4
      python3.8 malwoverview.py -R *Trojan* -G 4
      python3.8 malwoverview.py -R *Ransomware* -G 4
      python3.8 malwoverview.py -y 1
      python3.8 malwoverview.py -y 2
      python3.8 malwoverview.py -y 3
      python3.8 malwoverview.py -T icompass
      python3.8 malwoverview.py -Y icompass
      python3.8 malwoverview.py -k Trickbot | more
      python3.8 malwoverview.py -W Quakbot
      python3.8 malwoverview.py -I 149.56.79.215
      python3.8 malwoverview.py -n 1 -N 12
      python3.8 malwoverview.py -n 2 -N 79.124.8.24
      python3.8 malwoverview.py -n 3 -N covid19tracer.ca
      python3.8 malwoverview.py -n 4 -N ba42665872ea41e3d2edd8978bc38c24
      python3.8 malwoverview.py -n 5 -N http://ksahosting.net/wp-includes/utf8.php
      python3.8 malwoverview.py -M 1
      python3.8 malwoverview.py -M 2 | more
      python3.8 malwoverview.py -M 3 | more
      python3.8 malwoverview.py -M 4 -m apt41 | more
      python3.8 malwoverview.py -M 5 | more
      python3.8 malwoverview.py -M 6 -m win.locky
      python3.8 malwoverview.py -M 7 -m efbdb14f38c20c55e32cd98e4b2fdf197709581581d31fac683aabbf361df5f3
      python3.8 malwoverview.py -M 8 -m win.trickbot
      python3.8 malwoverview.py -Q 1 -q potrafamin44as@gmail.com
      python3.8 malwoverview.py -Q 2 -q 188.40.75.132
      python3.8 malwoverview.py -Q 3 -q aoldaily.com
      python3.8 malwoverview.py -Q 4 -q fa6fbd1dd2d58885772bd0b37633d5d7
      python3.8 malwoverview.py -Q 5 -q plugx

# HISTORY

Version 4.0.3:

      This version:

            * Fixes the fact of Virus Total evaluation wasn't showed when the user specified "-v 2" and 
              "-v 3" options.
            * The version of the Python request package is fixed to prevent issues with Polyswarm API 2.x.

Version 4.0.2:

      This version:

            * Two small bugs (typos) in the functions for Polyswarm downloading and Android package checking
              have been fixed. 
            * An unnecessary and dead code has been removed.
            * Several typos in the README.md and in the help have been corrected. 
            * All fixes for this version have been suggested by Christian Clauss (https://github.com/cclauss)


Version 4.0.1:

      This version:

            * Fixes small typos and the README. 


Version 4.0.0:

      This version:

            * Introduces new engines such as Alien Vault, Malpedia and ThreatCrowd. 
            * The -s option has been removed. Use -v 2 option for antivirus report.
            * The -n option is not longer associated to Malshare. Use -l option with 
              values between 1 and 14.
            * To specify the hash in Malshare use the L option instead of -m option. 
            * The -i option has been removed. Use the -v 3 option for IAT/EAT. 
            * The -a option has been changed to include the system environments in Hybrid 
              Analysis. However, the -e option has been kept to be used with other options. 
            * The -M option is not longer responsible for downloading samples in Malshare. Use
              -D option for this task. 
            * The -B option for list URLs from URLHaus has been replaced by -K 2 option. 
            * The -Z and -X options (related to Android) have been replaced for -y 2 and -y 3, 
              respectively. 
            * The -D option (download a malware sample) has been extended to Polyswarm. 
            * The malware sample's DLL list has been introduced. 
            * The -R and -G options from Polyswarm have been completely fixed. Additionally, both
              ones also include the polyscore in the output. 
            * The -N option is not longer associated to Polyswarm . 
            * The -G 4 option has been introduced and it makes possible to search samples by 
              families and types such as "*Trickbot*", "*Ransomware", "*Trojan*" and so on. 
            * Colors from -I option have been fixed. 
            * The -w option has been removed. 
            * Several issues in the help have been fixed. 


Version 3.1.2:

      This version:

            * Introduces the -c option that allows the user to specify a custom API configuration file. 
            * The API configuration file has been changed to .malwapi.conf file.
            * The project structure has been changed to make easier to install it in different operating 
              systems.
            * Updates for this version are a contribution from Corey Forman (https://github.com/digitalsleuth).

Version 3.0.0:

      This version:

            * Includes fixes in the URL reporting (-u option) from Virus Total.  
            * New players have have been included in the URL reporting (-u option) from Virus Total.
            * Fixes have been included in payload listing (-K option) from URLhaus.
            * Yara information has been include in the hash report (-m option) from Malshare.
            * Fixes have been included in the -l option. 
            * New file types have been included in the -n option: Java, Zip, data, RAR, PDF, Composite (OLE),
              MS_DOS and UTF-8.
            * New -W option, which is used to show URLs related to an user provided tags from URLHaus.
            * New -k option, which is used to show payloads related to a tag from URLHaus
            * New -I option, which is used to show information related to an IP address from Virus Total.
            * The -R option was refactored and now it supports searching for file, IPv4, domain or URL on 
              Polyswarm. 

Version 2.5.0:

      This version:

            * Introduces the following options:
                  * -y to check all third-party APKs from an Android device against 
                       the Hybrid Analysis. 
                  * -Y to send a third-party APKs from an Android device to the Hybrid
                       Analysis. 
                  * -Z to check all third-party APKs from an Android device against 
                       the Virus Total. 
                  * -X to check all third-party APKs from an Android device against the
                       Virus Total (it is necessary private API). 
                  * -T to send a third-party APK from an Android device to Virus Total. 
            * Fixes several issues related to color in command outputs.  
            * Adds the filename identification in the report while sending a sample to Virus Total.

Version 2.1.9.1:

      This version:

            * Fixes several issues about colors in outputs. 
            * Removes the -L option from Malshare (unfortunately, Malshare doesn't provide an 
              URL list anymore). 
            * Removes the -c option.
            * Introduces some verification lines in the URLHaus command. 

Version 2.1:

      This version:

            * Fixes formatting issues related to Hybrid Analysis output (-Q 1 -a 1). 
            * Fixes color issues. 
            * Fixes small issues related to Polyswarm. 

Version 2.0.8.1:

      This version:

            * Introduces installation using: pip3.8 install malwoverview (Linux) or 
              python -m pip install malwoverviewwin (Windows). 
            * Fixes small problems related to Polyswarm usage. 
            * Changes the help to verify whether the APIs were inserted into configmalw.py file. 

Version 2.0.1:

      This version:

            * Fixes a problem related to searching by hash on Malshare (-m option). 
            * Fixes a problem related to searching by hash on Polyswarm (-O option). 

Version 2.0.0:

      This version:

            * Introduces a completely ported version of Malwoverview to Python 3.x (it does not work in 
              Python 2.7.x anymore!)
            * Fixes several bugs related to IAT/EAT listing. 
            * Fixes several bugs related to colors. 
            * Introduces multi-threading to some options. 
            * Introduces several options related to Malshare. 
            * Introduces several options related to URLHaus.
            * Introduces several options related to Polyswarm engine. 
            * Changes the place of the API key configuration. Now you should edit the configmalw.py file. 
            * Changes the help libraries and functions, so making the Malwoverview's help more complete. 
            * Introduces geolocation feature by using the package named Geocoder written by Dennis Carrierre.
            * Fixes problems related to Hybrid Analysis engine. 
            * Fixes several mistaked related to a mix between spaces and Tab.
            * Extends the -d option to include Hybrid Analysis. 
            
Version 1.7.5:

      This version: 

            * It has been fixed a problem related to sample submission to Hybrid Analysis on Windows operating 
              system. Additionally, file name handling has been also fixed. 
            
Version 1.7.3:

      This version: 

            * Malwoverview has been adapted to API version 2.6.0 of Hybrid Analysis.
            * -A option has been fixed according to new version (2.6.0) of Hybrid Analysis.
            * -a option has been modified to work together with  -e option.
            * help information has been modified. 
            
Version 1.7.2:

      This version: 

            * A small fix related to -g option has been included. 
            
Version 1.7.1:

      This version: 

            * Relevant fix of a problem related to options -A and -H options.
            * Includes a new Hybrid Analysis environment to the -e option (Windows 7 32-bits with HWP support).
            * Updates the Malwoverview to support Hybrid Analysis API version 2.5.0.

Version 1.7.0:

      This version: 

            * Includes -A option for submitting a sample to Hybrid Analysis.
            * Includes -g option for checking the status a submission of a sample to Hybrid Analysis.
            * Includes -e option for specifying the testing environment on the Hybrid Analysis.
            * Includes -r option for getting a complete domain report from Virus Total.
            * Modifies the -H options for working together the -e option.
            * Modifies several functions of the tool to prepare it for version 1.8.0

Version 1.6.3:

      This version: 

            * Includes creation of new functions aiming 1.7.0 version.
            * Includes new exception handling blocks.

Version 1.6.2:

      This version: 

            * Includes small fixes.
            * For the Hybrid Analysis API version 2.40 is not longer necessary to include the API Secret.  

Version 1.6.1:

      This version: 

            * Includes small format fixes.

Version 1.6.0:

      This version: 

            * It is using the Hybrid Analysis API version 2.4.0.
            * Includes certificate information in the Hybrid Analysis report. 
            * Includes MITRE information in the Hybrid Analysis report. 
            * Includes an option to download samples from Hybrid Analysis. 

Version 1.5.1:

      This version: 

            * Small change to fix format issue in -d option. 

Version 1.5.0:

      This version: 

            * Includes the -u option to check URLs against Virus Total and associated engines. 
            * Includes the -H option to find existing reports on Virus Total and Hybrid Analysis through the 
              hash.
            * Includes the -V option to submit a file to Virus Total. Additionally, the report is shown after 
              few minutes.
            * Includes two small fixes. 

Version 1.4.5.2:

      This version:

            * Includes two small fixes.

Version 1.4.5.1:

      This version:

            * Includes one small fix. 

Version 1.4.5:

      This version:

            * Adds the -w option to use malwoverview in Windows systems.
            * Improves and fixes colors when using -b option with black window.  

Version 1.4: 

      This version:

            * Adds the -a option for getting the Hybrid Analysis summary report.
            * Adds the -i option for listing imported and exported functions. Therefore, imported/exported
              function report was decoupled for a separated option.  

Version 1.3: 

      This version:

            * Adds the -p option for public Virus Total API.

Version 1.2: 

      This version includes:

            * evaluates a single file (any filetype)
            * shows PE sessions.
            * shows imported functions.
            * shows exported function.
            * extracts overlay.
            * shows AV report from the main players. (any filetype)

Version 1.1: 

      This version:

            * Adds the VT checking feature.


Version 1.0:

      Malwoverview is a tool to perform a first triage of malware samples in a directory and group them 
      according to their import functions (imphash) using colors. This version:

            * Shows the imphash information classified by color. 
            * Checks whether malware samples are packed.  
            * Checks whether malware samples have overlay. 
            * Shows the entropy of the malware samples. 


