# Generated by Django 4.0.4 on 2022-11-07 16:19

from django.db import migrations, models
import django.utils.timezone
import uuid


def library_to_id(key):
    module, method = key.split('.')
    class_path = '.'.join([module, 'post_deploy', method])
    return class_path


def populate_log(apps, schema_editor):
    # load post_deploy_actions
    PostDeployAction = apps.get_model('post_deploy', 'PostDeployAction')
    PostDeployLog = apps.get_model('post_deploy', 'PostDeployLog')

    for action in PostDeployAction.objects.all():
        if action.completed_at:
            PostDeployLog.objects.create(
                import_name=library_to_id(action.id),
                created_at=action.started_at,
                completed_at=action.completed_at,
                task_id=action.task_id,
                message=action.message,
            )


class Migration(migrations.Migration):
    dependencies = [
        ('post_deploy', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='PostDeployLog',
            fields=[
                ('uuid', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('import_name', models.TextField()),
                ('created_at', models.DateTimeField(default=django.utils.timezone.localtime)),
                ('started_at', models.DateTimeField(null=True)),
                ('completed_at', models.DateTimeField(default=None, null=True)),
                ('task_id', models.UUIDField(blank=True, null=True)),
                ('has_error', models.BooleanField(default=False)),
                ('message', models.TextField(blank=True, null=True)),
            ],
            options={
                'ordering': ('-created_at',),
            },
        ),
        migrations.RunPython(populate_log, reverse_code=migrations.RunPython.noop),
    ]
