# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['inducoapi']

package_data = \
{'': ['*']}

install_requires = \
['openapi-spec-validator>=0.3.0,<0.4.0', 'pyyaml>=5.3.1,<6.0.0']

entry_points = \
{'console_scripts': ['my-script = inducoapi:main']}

setup_kwargs = {
    'name': 'inducoapi',
    'version': '2.0.0',
    'description': 'A simple python program to generate OpenApi documentation by supplying request/response bodies.',
    'long_description': "![pytest](https://github.com/TheWall89/inducoapi/workflows/pytest/badge.svg?branch=master)\n[![PyPI version](https://badge.fury.io/py/inducoapi.svg)](https://badge.fury.io/py/inducoapi)\n\n# InducOapi\n\nA simple python module to generate OpenAPI Description Documents by supplying request/response bodies.\n\n*Contributions for new features, fixes or improvements are welcome. Feel free to send a pull request.*\n\n## Motivation\n\nSometimes you have a fully functioning HTTP service without OpenAPI documentation. At some point in time, others may\nneed to use your service. Writing the documentation by hand is a pain and can feel like an overwhelming job for complex\nservices.\n_inducoapi_ helps you generate your OpenAPI Description Documents by taking as input request/response examples plus some\nother information.\n\nThe generated OpenAPI documentation is validated\nwith [openapi-spec-validator](https://github.com/p1c2u/openapi-spec-validator).\n\n_Warning_: This program also generates the `example` fields in OpenAPI schemas by default. If you have sensible data in\nyour request/response files, disable this feature with `--no-example`.\n\n## Installation\n\nWith `pip`:\n\n```shell script\npip install inducoapi\n```\n\nWith [poetry](https://python-poetry.org/).\n\n```shell script\ngit clone git@github.com:TheWall89/inducoapi.git\ncd inducoapi\npoetry install\n```\n\n## Usage\n\n### From CLI\n\n`inducoapi` provides its own help. Check it out with:\n\n```shell script\npython -m inducoapi -h\n```\n\nLet's consider a simple case: you have an HTTP service managing employees. We want to generate the OpenAPI Description\nDocument for a GET on all the employees, returning a 200 status code:\n\n```shell script\npython -m inducoapi GET /employees 200\n```\n\n<details><summary>output</summary>\n\n```yaml\nopenapi: 3.0.0\ninfo:\n  title: Generated by InducOapi\n  version: v1\npaths:\n  /employees:\n    get:\n      responses:\n        200:\n          description: ''\n```\n\n</details>\n\nNow, a GET request with an empty response is not quite useful. Let's add an argument with a JSON file containing a\nresponse example. Input examples can be found in [examples](examples).\n\n```shell script\npython -m inducoapi GET /employees 200 --response examples/employees.json\n```\n\n<details><summary>output</summary>\n\n```yaml\nopenapi: 3.0.0\ninfo:\n  title: Generated by InducOapi\n  version: v1\npaths:\n  /employees:\n    get:\n      responses:\n        200:\n          description: ''\n          content:\n            application/json:\n              schema:\n                type: array\n                items:\n                  type: object\n                  properties:\n                    id:\n                      type: integer\n                      example: 1\n                    name:\n                      type: string\n                      example: Dwight Schrute\n                    role:\n                      type: string\n                      example: salesman\n```\n\n</details>\n\nLet's add a parameter to filter the employees by name.\n\n```shell script\npython -m inducoapi GET /employees 200 --response examples/employees.json --parameter name,query \n```\n\n<details><summary>output</summary>\n\n```yaml\nopenapi: 3.0.0\ninfo:\n  title: Generated by InducOapi\n  version: v1\npaths:\n  /employees:\n    get:\n      responses:\n        '200':\n          description: ''\n          content:\n            application/json:\n              schema:\n                type: array\n                items:\n                  type: object\n                  properties:\n                    id:\n                      type: integer\n                      example: 1\n                    name:\n                      type: string\n                      example: Dwight Schrute\n                    role:\n                      type: string\n                      example: salesman\n      parameters:\n        - name: name\n          in: query\n          required: false\n          description: ''\n          schema: { }\n```\n\n</details>\n\nFinally, let's try a POST request with both request and response examples.\n\n```shell script\npython -m inducoapi POST /employees 201 --request examples/new_employee_req.json --response examples/new_employee_resp.json\n```\n\n<details><summary>output</summary>\n\n```yaml\nopenapi: 3.0.0\ninfo:\n  title: Generated by InducOapi\n  version: v1\npaths:\n  /employees:\n    post:\n      requestBody:\n        content:\n          application/json:\n            schema:\n              type: object\n              properties:\n                name:\n                  type: string\n                  example: Michael Scott\n                role:\n                  type: string\n                  example: manager\n      responses:\n        201:\n          description: ''\n          content:\n            application/json:\n              schema:\n                type: object\n                properties:\n                  id:\n                    type: integer\n                    example: 4\n                  name:\n                    type: string\n                    example: Michael Scott\n                  role:\n                    type: string\n                    example: manager\n```\n\n</details>\n\nIf you want to directly write the generated OpenAPI Description Documents to a YAML file, just\nadd `--output openapi.yaml`\n\n### From python\n\n[test_inducoapi.py](tests/test_inducoapi.py) provides usage examples of the module from python.\n\n## TODO list\n\n- [x] Add support for request/response files in YAML\n- [x] Add support for `application/yaml` content\n- [x] Customize title and version in info\n- [x] Package module\n- [x] Support for `$ref` in response schemas\n- [x] Add support for `parameters`\n- [ ] ~~Add support for `links`~~ (I don't think it is very useful)\n- [ ] ~~Add support for `format`~~ (hard to infer)\n",
    'author': 'Matteo Pergolesi',
    'author_email': 'matpergo@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/TheWall89/inducoapi',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
