# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['VpcPublicGatewayDhcpArgs', 'VpcPublicGatewayDhcp']

@pulumi.input_type
class VpcPublicGatewayDhcpArgs:
    def __init__(__self__, *,
                 subnet: pulumi.Input[str],
                 address: Optional[pulumi.Input[str]] = None,
                 dns_local_name: Optional[pulumi.Input[str]] = None,
                 dns_searches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_servers_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_dynamic: Optional[pulumi.Input[bool]] = None,
                 pool_high: Optional[pulumi.Input[str]] = None,
                 pool_low: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 push_default_route: Optional[pulumi.Input[bool]] = None,
                 push_dns_server: Optional[pulumi.Input[bool]] = None,
                 rebind_timer: Optional[pulumi.Input[int]] = None,
                 renew_timer: Optional[pulumi.Input[int]] = None,
                 valid_lifetime: Optional[pulumi.Input[int]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VpcPublicGatewayDhcp resource.
        :param pulumi.Input[str] subnet: The subnet to associate with the public gateway DHCP config.
        :param pulumi.Input[str] address: The IP address of the public gateway DHCP config.
        :param pulumi.Input[str] dns_local_name: TLD given to hostnames in the Private Network. Allowed characters are `a-z0-9-.`. Defaults to the slugified Private Network name if created along a GatewayNetwork, or else to `priv`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_searches: Additional DNS search paths
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers_overrides: Override the DNS server list pushed to DHCP clients, instead of the gateway itself
        :param pulumi.Input[bool] enable_dynamic: Whether to enable dynamic pooling of IPs. By turning the dynamic pool off, only pre-existing DHCP reservations will be handed out. Defaults to `true`.
        :param pulumi.Input[str] pool_high: High IP (excluded) of the dynamic address pool. Defaults to the last address of the subnet.
        :param pulumi.Input[str] pool_low: Low IP (included) of the dynamic address pool. Defaults to the second address of the subnet.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the public gateway DHCP config is associated with.
        :param pulumi.Input[bool] push_default_route: Whether the gateway should push a default route to DHCP clients or only hand out IPs. Defaults to `true`.
        :param pulumi.Input[bool] push_dns_server: Whether the gateway should push custom DNS servers to clients. This allows for instance hostname > IP resolution. Defaults to `true`.
        :param pulumi.Input[int] rebind_timer: After how long, in seconds, a DHCP client will query for a new lease if previous renews fail. Must be 30s lower than `valid_lifetime`. Defaults to 51m (3060s).
        :param pulumi.Input[int] renew_timer: After how long, in seconds, a renewal will be attempted. Must be 30s lower than `rebind_timer`. Defaults to 50m (3000s).
        :param pulumi.Input[int] valid_lifetime: For how long, in seconds, will DHCP entries will be valid. Defaults to 1h (3600s).
        :param pulumi.Input[str] zone: `zone`) The zone in which the public gateway DHCP config should be created.
        """
        pulumi.set(__self__, "subnet", subnet)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if dns_local_name is not None:
            pulumi.set(__self__, "dns_local_name", dns_local_name)
        if dns_searches is not None:
            pulumi.set(__self__, "dns_searches", dns_searches)
        if dns_servers_overrides is not None:
            pulumi.set(__self__, "dns_servers_overrides", dns_servers_overrides)
        if enable_dynamic is not None:
            pulumi.set(__self__, "enable_dynamic", enable_dynamic)
        if pool_high is not None:
            pulumi.set(__self__, "pool_high", pool_high)
        if pool_low is not None:
            pulumi.set(__self__, "pool_low", pool_low)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if push_default_route is not None:
            pulumi.set(__self__, "push_default_route", push_default_route)
        if push_dns_server is not None:
            pulumi.set(__self__, "push_dns_server", push_dns_server)
        if rebind_timer is not None:
            pulumi.set(__self__, "rebind_timer", rebind_timer)
        if renew_timer is not None:
            pulumi.set(__self__, "renew_timer", renew_timer)
        if valid_lifetime is not None:
            pulumi.set(__self__, "valid_lifetime", valid_lifetime)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Input[str]:
        """
        The subnet to associate with the public gateway DHCP config.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the public gateway DHCP config.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="dnsLocalName")
    def dns_local_name(self) -> Optional[pulumi.Input[str]]:
        """
        TLD given to hostnames in the Private Network. Allowed characters are `a-z0-9-.`. Defaults to the slugified Private Network name if created along a GatewayNetwork, or else to `priv`.
        """
        return pulumi.get(self, "dns_local_name")

    @dns_local_name.setter
    def dns_local_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_local_name", value)

    @property
    @pulumi.getter(name="dnsSearches")
    def dns_searches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Additional DNS search paths
        """
        return pulumi.get(self, "dns_searches")

    @dns_searches.setter
    def dns_searches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_searches", value)

    @property
    @pulumi.getter(name="dnsServersOverrides")
    def dns_servers_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Override the DNS server list pushed to DHCP clients, instead of the gateway itself
        """
        return pulumi.get(self, "dns_servers_overrides")

    @dns_servers_overrides.setter
    def dns_servers_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_servers_overrides", value)

    @property
    @pulumi.getter(name="enableDynamic")
    def enable_dynamic(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable dynamic pooling of IPs. By turning the dynamic pool off, only pre-existing DHCP reservations will be handed out. Defaults to `true`.
        """
        return pulumi.get(self, "enable_dynamic")

    @enable_dynamic.setter
    def enable_dynamic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dynamic", value)

    @property
    @pulumi.getter(name="poolHigh")
    def pool_high(self) -> Optional[pulumi.Input[str]]:
        """
        High IP (excluded) of the dynamic address pool. Defaults to the last address of the subnet.
        """
        return pulumi.get(self, "pool_high")

    @pool_high.setter
    def pool_high(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool_high", value)

    @property
    @pulumi.getter(name="poolLow")
    def pool_low(self) -> Optional[pulumi.Input[str]]:
        """
        Low IP (included) of the dynamic address pool. Defaults to the second address of the subnet.
        """
        return pulumi.get(self, "pool_low")

    @pool_low.setter
    def pool_low(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool_low", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        `project_id`) The ID of the project the public gateway DHCP config is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="pushDefaultRoute")
    def push_default_route(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the gateway should push a default route to DHCP clients or only hand out IPs. Defaults to `true`.
        """
        return pulumi.get(self, "push_default_route")

    @push_default_route.setter
    def push_default_route(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "push_default_route", value)

    @property
    @pulumi.getter(name="pushDnsServer")
    def push_dns_server(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the gateway should push custom DNS servers to clients. This allows for instance hostname > IP resolution. Defaults to `true`.
        """
        return pulumi.get(self, "push_dns_server")

    @push_dns_server.setter
    def push_dns_server(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "push_dns_server", value)

    @property
    @pulumi.getter(name="rebindTimer")
    def rebind_timer(self) -> Optional[pulumi.Input[int]]:
        """
        After how long, in seconds, a DHCP client will query for a new lease if previous renews fail. Must be 30s lower than `valid_lifetime`. Defaults to 51m (3060s).
        """
        return pulumi.get(self, "rebind_timer")

    @rebind_timer.setter
    def rebind_timer(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rebind_timer", value)

    @property
    @pulumi.getter(name="renewTimer")
    def renew_timer(self) -> Optional[pulumi.Input[int]]:
        """
        After how long, in seconds, a renewal will be attempted. Must be 30s lower than `rebind_timer`. Defaults to 50m (3000s).
        """
        return pulumi.get(self, "renew_timer")

    @renew_timer.setter
    def renew_timer(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "renew_timer", value)

    @property
    @pulumi.getter(name="validLifetime")
    def valid_lifetime(self) -> Optional[pulumi.Input[int]]:
        """
        For how long, in seconds, will DHCP entries will be valid. Defaults to 1h (3600s).
        """
        return pulumi.get(self, "valid_lifetime")

    @valid_lifetime.setter
    def valid_lifetime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "valid_lifetime", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        `zone`) The zone in which the public gateway DHCP config should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _VpcPublicGatewayDhcpState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 dns_local_name: Optional[pulumi.Input[str]] = None,
                 dns_searches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_servers_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_dynamic: Optional[pulumi.Input[bool]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 pool_high: Optional[pulumi.Input[str]] = None,
                 pool_low: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 push_default_route: Optional[pulumi.Input[bool]] = None,
                 push_dns_server: Optional[pulumi.Input[bool]] = None,
                 rebind_timer: Optional[pulumi.Input[int]] = None,
                 renew_timer: Optional[pulumi.Input[int]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 valid_lifetime: Optional[pulumi.Input[int]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering VpcPublicGatewayDhcp resources.
        :param pulumi.Input[str] address: The IP address of the public gateway DHCP config.
        :param pulumi.Input[str] created_at: The date and time of the creation of the public gateway DHCP config.
        :param pulumi.Input[str] dns_local_name: TLD given to hostnames in the Private Network. Allowed characters are `a-z0-9-.`. Defaults to the slugified Private Network name if created along a GatewayNetwork, or else to `priv`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_searches: Additional DNS search paths
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers_overrides: Override the DNS server list pushed to DHCP clients, instead of the gateway itself
        :param pulumi.Input[bool] enable_dynamic: Whether to enable dynamic pooling of IPs. By turning the dynamic pool off, only pre-existing DHCP reservations will be handed out. Defaults to `true`.
        :param pulumi.Input[str] organization_id: The organization ID the public gateway DHCP config is associated with.
        :param pulumi.Input[str] pool_high: High IP (excluded) of the dynamic address pool. Defaults to the last address of the subnet.
        :param pulumi.Input[str] pool_low: Low IP (included) of the dynamic address pool. Defaults to the second address of the subnet.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the public gateway DHCP config is associated with.
        :param pulumi.Input[bool] push_default_route: Whether the gateway should push a default route to DHCP clients or only hand out IPs. Defaults to `true`.
        :param pulumi.Input[bool] push_dns_server: Whether the gateway should push custom DNS servers to clients. This allows for instance hostname > IP resolution. Defaults to `true`.
        :param pulumi.Input[int] rebind_timer: After how long, in seconds, a DHCP client will query for a new lease if previous renews fail. Must be 30s lower than `valid_lifetime`. Defaults to 51m (3060s).
        :param pulumi.Input[int] renew_timer: After how long, in seconds, a renewal will be attempted. Must be 30s lower than `rebind_timer`. Defaults to 50m (3000s).
        :param pulumi.Input[str] subnet: The subnet to associate with the public gateway DHCP config.
        :param pulumi.Input[str] updated_at: The date and time of the last update of the public gateway DHCP config.
        :param pulumi.Input[int] valid_lifetime: For how long, in seconds, will DHCP entries will be valid. Defaults to 1h (3600s).
        :param pulumi.Input[str] zone: `zone`) The zone in which the public gateway DHCP config should be created.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if dns_local_name is not None:
            pulumi.set(__self__, "dns_local_name", dns_local_name)
        if dns_searches is not None:
            pulumi.set(__self__, "dns_searches", dns_searches)
        if dns_servers_overrides is not None:
            pulumi.set(__self__, "dns_servers_overrides", dns_servers_overrides)
        if enable_dynamic is not None:
            pulumi.set(__self__, "enable_dynamic", enable_dynamic)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if pool_high is not None:
            pulumi.set(__self__, "pool_high", pool_high)
        if pool_low is not None:
            pulumi.set(__self__, "pool_low", pool_low)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if push_default_route is not None:
            pulumi.set(__self__, "push_default_route", push_default_route)
        if push_dns_server is not None:
            pulumi.set(__self__, "push_dns_server", push_dns_server)
        if rebind_timer is not None:
            pulumi.set(__self__, "rebind_timer", rebind_timer)
        if renew_timer is not None:
            pulumi.set(__self__, "renew_timer", renew_timer)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if valid_lifetime is not None:
            pulumi.set(__self__, "valid_lifetime", valid_lifetime)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the public gateway DHCP config.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of the creation of the public gateway DHCP config.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="dnsLocalName")
    def dns_local_name(self) -> Optional[pulumi.Input[str]]:
        """
        TLD given to hostnames in the Private Network. Allowed characters are `a-z0-9-.`. Defaults to the slugified Private Network name if created along a GatewayNetwork, or else to `priv`.
        """
        return pulumi.get(self, "dns_local_name")

    @dns_local_name.setter
    def dns_local_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_local_name", value)

    @property
    @pulumi.getter(name="dnsSearches")
    def dns_searches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Additional DNS search paths
        """
        return pulumi.get(self, "dns_searches")

    @dns_searches.setter
    def dns_searches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_searches", value)

    @property
    @pulumi.getter(name="dnsServersOverrides")
    def dns_servers_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Override the DNS server list pushed to DHCP clients, instead of the gateway itself
        """
        return pulumi.get(self, "dns_servers_overrides")

    @dns_servers_overrides.setter
    def dns_servers_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_servers_overrides", value)

    @property
    @pulumi.getter(name="enableDynamic")
    def enable_dynamic(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable dynamic pooling of IPs. By turning the dynamic pool off, only pre-existing DHCP reservations will be handed out. Defaults to `true`.
        """
        return pulumi.get(self, "enable_dynamic")

    @enable_dynamic.setter
    def enable_dynamic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dynamic", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        The organization ID the public gateway DHCP config is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="poolHigh")
    def pool_high(self) -> Optional[pulumi.Input[str]]:
        """
        High IP (excluded) of the dynamic address pool. Defaults to the last address of the subnet.
        """
        return pulumi.get(self, "pool_high")

    @pool_high.setter
    def pool_high(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool_high", value)

    @property
    @pulumi.getter(name="poolLow")
    def pool_low(self) -> Optional[pulumi.Input[str]]:
        """
        Low IP (included) of the dynamic address pool. Defaults to the second address of the subnet.
        """
        return pulumi.get(self, "pool_low")

    @pool_low.setter
    def pool_low(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool_low", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        `project_id`) The ID of the project the public gateway DHCP config is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="pushDefaultRoute")
    def push_default_route(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the gateway should push a default route to DHCP clients or only hand out IPs. Defaults to `true`.
        """
        return pulumi.get(self, "push_default_route")

    @push_default_route.setter
    def push_default_route(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "push_default_route", value)

    @property
    @pulumi.getter(name="pushDnsServer")
    def push_dns_server(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the gateway should push custom DNS servers to clients. This allows for instance hostname > IP resolution. Defaults to `true`.
        """
        return pulumi.get(self, "push_dns_server")

    @push_dns_server.setter
    def push_dns_server(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "push_dns_server", value)

    @property
    @pulumi.getter(name="rebindTimer")
    def rebind_timer(self) -> Optional[pulumi.Input[int]]:
        """
        After how long, in seconds, a DHCP client will query for a new lease if previous renews fail. Must be 30s lower than `valid_lifetime`. Defaults to 51m (3060s).
        """
        return pulumi.get(self, "rebind_timer")

    @rebind_timer.setter
    def rebind_timer(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rebind_timer", value)

    @property
    @pulumi.getter(name="renewTimer")
    def renew_timer(self) -> Optional[pulumi.Input[int]]:
        """
        After how long, in seconds, a renewal will be attempted. Must be 30s lower than `rebind_timer`. Defaults to 50m (3000s).
        """
        return pulumi.get(self, "renew_timer")

    @renew_timer.setter
    def renew_timer(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "renew_timer", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet to associate with the public gateway DHCP config.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of the last update of the public gateway DHCP config.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="validLifetime")
    def valid_lifetime(self) -> Optional[pulumi.Input[int]]:
        """
        For how long, in seconds, will DHCP entries will be valid. Defaults to 1h (3600s).
        """
        return pulumi.get(self, "valid_lifetime")

    @valid_lifetime.setter
    def valid_lifetime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "valid_lifetime", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        `zone`) The zone in which the public gateway DHCP config should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class VpcPublicGatewayDhcp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 dns_local_name: Optional[pulumi.Input[str]] = None,
                 dns_searches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_servers_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_dynamic: Optional[pulumi.Input[bool]] = None,
                 pool_high: Optional[pulumi.Input[str]] = None,
                 pool_low: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 push_default_route: Optional[pulumi.Input[bool]] = None,
                 push_dns_server: Optional[pulumi.Input[bool]] = None,
                 rebind_timer: Optional[pulumi.Input[int]] = None,
                 renew_timer: Optional[pulumi.Input[int]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 valid_lifetime: Optional[pulumi.Input[int]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway VPC Public Gateway DHCP.
        For more information, see [the documentation](https://developers.scaleway.com/en/products/vpc-gw/api/v1/#dhcp-c05544).

        ## Example

        ```python
        import pulumi
        import lbrlabs_pulumi_scaleway as scaleway

        main = scaleway.VpcPublicGatewayDhcp("main", subnet="192.168.1.0/24")
        ```

        ## Import

        Public gateway DHCP config can be imported using the `{zone}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/vpcPublicGatewayDhcp:VpcPublicGatewayDhcp main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: The IP address of the public gateway DHCP config.
        :param pulumi.Input[str] dns_local_name: TLD given to hostnames in the Private Network. Allowed characters are `a-z0-9-.`. Defaults to the slugified Private Network name if created along a GatewayNetwork, or else to `priv`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_searches: Additional DNS search paths
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers_overrides: Override the DNS server list pushed to DHCP clients, instead of the gateway itself
        :param pulumi.Input[bool] enable_dynamic: Whether to enable dynamic pooling of IPs. By turning the dynamic pool off, only pre-existing DHCP reservations will be handed out. Defaults to `true`.
        :param pulumi.Input[str] pool_high: High IP (excluded) of the dynamic address pool. Defaults to the last address of the subnet.
        :param pulumi.Input[str] pool_low: Low IP (included) of the dynamic address pool. Defaults to the second address of the subnet.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the public gateway DHCP config is associated with.
        :param pulumi.Input[bool] push_default_route: Whether the gateway should push a default route to DHCP clients or only hand out IPs. Defaults to `true`.
        :param pulumi.Input[bool] push_dns_server: Whether the gateway should push custom DNS servers to clients. This allows for instance hostname > IP resolution. Defaults to `true`.
        :param pulumi.Input[int] rebind_timer: After how long, in seconds, a DHCP client will query for a new lease if previous renews fail. Must be 30s lower than `valid_lifetime`. Defaults to 51m (3060s).
        :param pulumi.Input[int] renew_timer: After how long, in seconds, a renewal will be attempted. Must be 30s lower than `rebind_timer`. Defaults to 50m (3000s).
        :param pulumi.Input[str] subnet: The subnet to associate with the public gateway DHCP config.
        :param pulumi.Input[int] valid_lifetime: For how long, in seconds, will DHCP entries will be valid. Defaults to 1h (3600s).
        :param pulumi.Input[str] zone: `zone`) The zone in which the public gateway DHCP config should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcPublicGatewayDhcpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway VPC Public Gateway DHCP.
        For more information, see [the documentation](https://developers.scaleway.com/en/products/vpc-gw/api/v1/#dhcp-c05544).

        ## Example

        ```python
        import pulumi
        import lbrlabs_pulumi_scaleway as scaleway

        main = scaleway.VpcPublicGatewayDhcp("main", subnet="192.168.1.0/24")
        ```

        ## Import

        Public gateway DHCP config can be imported using the `{zone}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/vpcPublicGatewayDhcp:VpcPublicGatewayDhcp main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param VpcPublicGatewayDhcpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcPublicGatewayDhcpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 dns_local_name: Optional[pulumi.Input[str]] = None,
                 dns_searches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_servers_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_dynamic: Optional[pulumi.Input[bool]] = None,
                 pool_high: Optional[pulumi.Input[str]] = None,
                 pool_low: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 push_default_route: Optional[pulumi.Input[bool]] = None,
                 push_dns_server: Optional[pulumi.Input[bool]] = None,
                 rebind_timer: Optional[pulumi.Input[int]] = None,
                 renew_timer: Optional[pulumi.Input[int]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 valid_lifetime: Optional[pulumi.Input[int]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcPublicGatewayDhcpArgs.__new__(VpcPublicGatewayDhcpArgs)

            __props__.__dict__["address"] = address
            __props__.__dict__["dns_local_name"] = dns_local_name
            __props__.__dict__["dns_searches"] = dns_searches
            __props__.__dict__["dns_servers_overrides"] = dns_servers_overrides
            __props__.__dict__["enable_dynamic"] = enable_dynamic
            __props__.__dict__["pool_high"] = pool_high
            __props__.__dict__["pool_low"] = pool_low
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["push_default_route"] = push_default_route
            __props__.__dict__["push_dns_server"] = push_dns_server
            __props__.__dict__["rebind_timer"] = rebind_timer
            __props__.__dict__["renew_timer"] = renew_timer
            if subnet is None and not opts.urn:
                raise TypeError("Missing required property 'subnet'")
            __props__.__dict__["subnet"] = subnet
            __props__.__dict__["valid_lifetime"] = valid_lifetime
            __props__.__dict__["zone"] = zone
            __props__.__dict__["created_at"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["updated_at"] = None
        super(VpcPublicGatewayDhcp, __self__).__init__(
            'scaleway:index/vpcPublicGatewayDhcp:VpcPublicGatewayDhcp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            dns_local_name: Optional[pulumi.Input[str]] = None,
            dns_searches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            dns_servers_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            enable_dynamic: Optional[pulumi.Input[bool]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            pool_high: Optional[pulumi.Input[str]] = None,
            pool_low: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            push_default_route: Optional[pulumi.Input[bool]] = None,
            push_dns_server: Optional[pulumi.Input[bool]] = None,
            rebind_timer: Optional[pulumi.Input[int]] = None,
            renew_timer: Optional[pulumi.Input[int]] = None,
            subnet: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            valid_lifetime: Optional[pulumi.Input[int]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'VpcPublicGatewayDhcp':
        """
        Get an existing VpcPublicGatewayDhcp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: The IP address of the public gateway DHCP config.
        :param pulumi.Input[str] created_at: The date and time of the creation of the public gateway DHCP config.
        :param pulumi.Input[str] dns_local_name: TLD given to hostnames in the Private Network. Allowed characters are `a-z0-9-.`. Defaults to the slugified Private Network name if created along a GatewayNetwork, or else to `priv`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_searches: Additional DNS search paths
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers_overrides: Override the DNS server list pushed to DHCP clients, instead of the gateway itself
        :param pulumi.Input[bool] enable_dynamic: Whether to enable dynamic pooling of IPs. By turning the dynamic pool off, only pre-existing DHCP reservations will be handed out. Defaults to `true`.
        :param pulumi.Input[str] organization_id: The organization ID the public gateway DHCP config is associated with.
        :param pulumi.Input[str] pool_high: High IP (excluded) of the dynamic address pool. Defaults to the last address of the subnet.
        :param pulumi.Input[str] pool_low: Low IP (included) of the dynamic address pool. Defaults to the second address of the subnet.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the public gateway DHCP config is associated with.
        :param pulumi.Input[bool] push_default_route: Whether the gateway should push a default route to DHCP clients or only hand out IPs. Defaults to `true`.
        :param pulumi.Input[bool] push_dns_server: Whether the gateway should push custom DNS servers to clients. This allows for instance hostname > IP resolution. Defaults to `true`.
        :param pulumi.Input[int] rebind_timer: After how long, in seconds, a DHCP client will query for a new lease if previous renews fail. Must be 30s lower than `valid_lifetime`. Defaults to 51m (3060s).
        :param pulumi.Input[int] renew_timer: After how long, in seconds, a renewal will be attempted. Must be 30s lower than `rebind_timer`. Defaults to 50m (3000s).
        :param pulumi.Input[str] subnet: The subnet to associate with the public gateway DHCP config.
        :param pulumi.Input[str] updated_at: The date and time of the last update of the public gateway DHCP config.
        :param pulumi.Input[int] valid_lifetime: For how long, in seconds, will DHCP entries will be valid. Defaults to 1h (3600s).
        :param pulumi.Input[str] zone: `zone`) The zone in which the public gateway DHCP config should be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcPublicGatewayDhcpState.__new__(_VpcPublicGatewayDhcpState)

        __props__.__dict__["address"] = address
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["dns_local_name"] = dns_local_name
        __props__.__dict__["dns_searches"] = dns_searches
        __props__.__dict__["dns_servers_overrides"] = dns_servers_overrides
        __props__.__dict__["enable_dynamic"] = enable_dynamic
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["pool_high"] = pool_high
        __props__.__dict__["pool_low"] = pool_low
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["push_default_route"] = push_default_route
        __props__.__dict__["push_dns_server"] = push_dns_server
        __props__.__dict__["rebind_timer"] = rebind_timer
        __props__.__dict__["renew_timer"] = renew_timer
        __props__.__dict__["subnet"] = subnet
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["valid_lifetime"] = valid_lifetime
        __props__.__dict__["zone"] = zone
        return VpcPublicGatewayDhcp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[str]:
        """
        The IP address of the public gateway DHCP config.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The date and time of the creation of the public gateway DHCP config.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="dnsLocalName")
    def dns_local_name(self) -> pulumi.Output[str]:
        """
        TLD given to hostnames in the Private Network. Allowed characters are `a-z0-9-.`. Defaults to the slugified Private Network name if created along a GatewayNetwork, or else to `priv`.
        """
        return pulumi.get(self, "dns_local_name")

    @property
    @pulumi.getter(name="dnsSearches")
    def dns_searches(self) -> pulumi.Output[Sequence[str]]:
        """
        Additional DNS search paths
        """
        return pulumi.get(self, "dns_searches")

    @property
    @pulumi.getter(name="dnsServersOverrides")
    def dns_servers_overrides(self) -> pulumi.Output[Sequence[str]]:
        """
        Override the DNS server list pushed to DHCP clients, instead of the gateway itself
        """
        return pulumi.get(self, "dns_servers_overrides")

    @property
    @pulumi.getter(name="enableDynamic")
    def enable_dynamic(self) -> pulumi.Output[bool]:
        """
        Whether to enable dynamic pooling of IPs. By turning the dynamic pool off, only pre-existing DHCP reservations will be handed out. Defaults to `true`.
        """
        return pulumi.get(self, "enable_dynamic")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        The organization ID the public gateway DHCP config is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="poolHigh")
    def pool_high(self) -> pulumi.Output[str]:
        """
        High IP (excluded) of the dynamic address pool. Defaults to the last address of the subnet.
        """
        return pulumi.get(self, "pool_high")

    @property
    @pulumi.getter(name="poolLow")
    def pool_low(self) -> pulumi.Output[str]:
        """
        Low IP (included) of the dynamic address pool. Defaults to the second address of the subnet.
        """
        return pulumi.get(self, "pool_low")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        `project_id`) The ID of the project the public gateway DHCP config is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="pushDefaultRoute")
    def push_default_route(self) -> pulumi.Output[bool]:
        """
        Whether the gateway should push a default route to DHCP clients or only hand out IPs. Defaults to `true`.
        """
        return pulumi.get(self, "push_default_route")

    @property
    @pulumi.getter(name="pushDnsServer")
    def push_dns_server(self) -> pulumi.Output[bool]:
        """
        Whether the gateway should push custom DNS servers to clients. This allows for instance hostname > IP resolution. Defaults to `true`.
        """
        return pulumi.get(self, "push_dns_server")

    @property
    @pulumi.getter(name="rebindTimer")
    def rebind_timer(self) -> pulumi.Output[int]:
        """
        After how long, in seconds, a DHCP client will query for a new lease if previous renews fail. Must be 30s lower than `valid_lifetime`. Defaults to 51m (3060s).
        """
        return pulumi.get(self, "rebind_timer")

    @property
    @pulumi.getter(name="renewTimer")
    def renew_timer(self) -> pulumi.Output[int]:
        """
        After how long, in seconds, a renewal will be attempted. Must be 30s lower than `rebind_timer`. Defaults to 50m (3000s).
        """
        return pulumi.get(self, "renew_timer")

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[str]:
        """
        The subnet to associate with the public gateway DHCP config.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The date and time of the last update of the public gateway DHCP config.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="validLifetime")
    def valid_lifetime(self) -> pulumi.Output[int]:
        """
        For how long, in seconds, will DHCP entries will be valid. Defaults to 1h (3600s).
        """
        return pulumi.get(self, "valid_lifetime")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        `zone`) The zone in which the public gateway DHCP config should be created.
        """
        return pulumi.get(self, "zone")

