# living-tree-toolkit

An efficient toolkit for processing taxonomic trees (abundance calculations, reads count statistics, etc.)  and generating taxonomic trees using lineages data retrieved from the NCBI taxonomy database.

![Status Beta](https://img.shields.io/badge/Status-Beta-yellow.svg?style=flat-square&logo=appveyor)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square&logo=appveyor)](http://makeapullrequest.com)
[![Read the Docs (version)](https://img.shields.io/readthedocs/living-tree-toolkit/latest?label=documentation&style=flat-square)](https://living-tree-toolkit.readthedocs.io/en/latest/)


Use [`treelib`](https://github.com/caesar0301/treelib) API to achieve rapid construction of complex trees and [`ete3 toolkit`](http://etetoolkit.org/) API to retrieve data from NCBI taxonomy database.

This project is a sub-project of the ONN4MDM project, if you use it for academic purposes, please cite us.

## Update

- 2020/03/27:  
    - start finalizing project framework and release initial version.
- 2020/04/14:  
    - Api update `update_value` and `get_matrix`
    - New method `get_top_down_ids`, `get_bottom_up_ids`, `get_ids_by_level` and `get_paths_to_level`
    - Execution efficiency are improved significantly
    
## Documentation

For Installation, examples and API references, see [https://living-tree-toolkit.readthedocs.io/en/latest/](https://living-tree-toolkit.readthedocs.io/en/latest/)

## Maintainer

| Name      | Email                   | Organization                                                 |
| --------- | ----------------------- | ------------------------------------------------------------ |
| Hui Chong | huichong.me@gmail.com | Research Assistant, Institute of Science and Technology for Brain-inspired Intelligence, Fudan University |

